/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.VerticalLayout;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;

public class KscDashletConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;
    private NativeSelect m_kscSelect;

    public KscDashletConfigurationWindow(DashletSpec dashletSpec) {
        this.m_dashletSpec = dashletSpec;
        this.setHeight(210.0f, Sizeable.Unit.PIXELS);
        this.setWidth(40.0f, Sizeable.Unit.PERCENTAGE);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setMargin(true);
        FormLayout formLayout = new FormLayout();
        formLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        formLayout.setSpacing(true);
        formLayout.setMargin(true);
        this.m_kscSelect = new NativeSelect();
        this.m_kscSelect.setDescription("Select KSC-report to be displayed");
        this.m_kscSelect.setCaption("KSC-Report");
        this.m_kscSelect.setImmediate(true);
        this.m_kscSelect.setNewItemsAllowed(false);
        this.m_kscSelect.setMultiSelect(false);
        this.m_kscSelect.setInvalidAllowed(false);
        this.m_kscSelect.setNullSelectionAllowed(false);
        this.m_kscSelect.setImmediate(true);
        final KSC_PerformanceReportFactory kscPerformanceReportFactory = KSC_PerformanceReportFactory.getInstance();
        Map reportsMap = kscPerformanceReportFactory.getReportList();
        for (Map.Entry entry : reportsMap.entrySet()) {
            this.m_kscSelect.addItem(entry.getKey());
            this.m_kscSelect.setItemCaption(entry.getKey(), (String)entry.getValue());
            if (this.m_kscSelect.getValue() != null) continue;
            this.m_kscSelect.setValue(entry.getKey());
        }
        String chartName = (String)this.m_dashletSpec.getParameters().get("kscReport");
        if (chartName != null && reportsMap.values().contains(chartName)) {
            this.m_kscSelect.setValue((Object)chartName);
        }
        formLayout.addComponent((Component)this.m_kscSelect);
        this.m_kscSelect.setValue((Object)chartName);
        this.m_kscSelect.setImmediate(true);
        horizontalLayout.addComponent((Component)formLayout);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                KscDashletConfigurationWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Map reportsMap = kscPerformanceReportFactory.getReportList();
                KscDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("kscReport", reportsMap.get(KscDashletConfigurationWindow.this.m_kscSelect.getValue()));
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)KscDashletConfigurationWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                KscDashletConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        if (reportsMap.size() == 0) {
            this.m_kscSelect.setEnabled(false);
            ok.setEnabled(false);
        }
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)buttonLayout);
        this.setContent((Component)verticalLayout);
    }
}

