/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class ImageDashlet
extends AbstractDashlet {
    private String m_imageUrl = null;
    private DashletComponent m_dashletComponent;

    public ImageDashlet(String name, DashletSpec dashletSpec) {
        super(name, dashletSpec);
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_dashletComponent == null) {
            this.m_dashletComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(ImageDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    boolean maximizeWidth;
                    String newImage = (String)ImageDashlet.this.getDashletSpec().getParameters().get("imageUrl");
                    String maximizeHeightString = (String)ImageDashlet.this.getDashletSpec().getParameters().get("maximizeHeight");
                    String maximizeWidthString = (String)ImageDashlet.this.getDashletSpec().getParameters().get("maximizeWidth");
                    boolean maximizeHeight = "true".equals(maximizeHeightString) || "yes".equals(maximizeHeightString) || "1".equals(maximizeHeightString);
                    boolean bl = maximizeWidth = "true".equals(maximizeWidthString) || "yes".equals(maximizeWidthString) || "1".equals(maximizeWidthString);
                    if (!newImage.equals(ImageDashlet.this.m_imageUrl)) {
                        ImageDashlet.this.m_imageUrl = newImage;
                        this.m_verticalLayout.removeAllComponents();
                        Image image = new Image(null, (Resource)new ExternalResource(ImageDashlet.this.m_imageUrl));
                        if (maximizeHeight && maximizeWidth) {
                            image.setSizeFull();
                        } else {
                            if (maximizeHeight) {
                                image.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
                            }
                            if (maximizeWidth) {
                                image.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
                            }
                        }
                        this.m_verticalLayout.addComponent((Component)image);
                        this.m_verticalLayout.setComponentAlignment((Component)image, Alignment.MIDDLE_CENTER);
                    }
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashletComponent;
    }

    public DashletComponent getDashboardComponent() {
        return this.getWallboardComponent();
    }
}

