/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.google.common.base.Strings;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.TextField;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.dashlets.GrafanaDashletQuickRangePicker;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class GrafanaDashletConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;

    public GrafanaDashletConfigurationWindow(DashletSpec dashletSpec) {
        Map<String, String> grafanaDashboards;
        this.m_dashletSpec = dashletSpec;
        this.setWidth("60%");
        this.setHeight("58%");
        FormLayout topLayout = new FormLayout();
        topLayout.setSizeFull();
        topLayout.setWidth("100%");
        NativeSelect dashboardSelect = new NativeSelect();
        dashboardSelect.setCaption("Grafana Dashboard");
        dashboardSelect.addItem((Object)"Test");
        dashboardSelect.setDescription("Grafana Dashboard to be displayed");
        dashboardSelect.setImmediate(true);
        dashboardSelect.setNewItemsAllowed(false);
        dashboardSelect.setMultiSelect(false);
        dashboardSelect.setInvalidAllowed(false);
        dashboardSelect.setNullSelectionAllowed(false);
        dashboardSelect.setWidth("80%");
        GrafanaDashletQuickRangePicker grafanaDashletQuickRangePicker = new GrafanaDashletQuickRangePicker();
        grafanaDashletQuickRangePicker.setCaption("Quick ranges");
        grafanaDashletQuickRangePicker.setDescription("Quick ranges defined");
        grafanaDashletQuickRangePicker.setWidth("100%");
        TextField timeRangeFrom = new TextField();
        timeRangeFrom.setCaption("From");
        timeRangeFrom.setDescription("Start of time range to be displayed");
        timeRangeFrom.setImmediate(true);
        timeRangeFrom.setWidth("60%");
        timeRangeFrom.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        TextField timeRangeTo = new TextField();
        timeRangeTo.setCaption("To");
        timeRangeTo.setDescription("End of time range to be displayed");
        timeRangeTo.setImmediate(true);
        timeRangeTo.setWidth("60%");
        timeRangeTo.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        topLayout.addComponent((Component)dashboardSelect);
        topLayout.addComponent((Component)grafanaDashletQuickRangePicker);
        topLayout.addComponent((Component)timeRangeFrom);
        topLayout.addComponent((Component)timeRangeTo);
        grafanaDashletQuickRangePicker.addQuickRangeListener(q -> {
            timeRangeFrom.setValue(q.getFrom());
            timeRangeTo.setValue(q.getTo());
        });
        timeRangeFrom.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)e -> grafanaDashletQuickRangePicker.selectQuickRange(e.getText(), (String)timeRangeTo.getValue()));
        timeRangeTo.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)e -> grafanaDashletQuickRangePicker.selectQuickRange((String)timeRangeFrom.getValue(), e.getText()));
        try {
            grafanaDashboards = this.getGrafanaDashboards();
            String firstItem = null;
            for (Map.Entry<String, String> grafanaDashboard : grafanaDashboards.entrySet()) {
                dashboardSelect.addItem((Object)grafanaDashboard.getKey());
                if (firstItem != null) continue;
                firstItem = grafanaDashboard.getKey();
            }
            dashboardSelect.select(firstItem);
            if (!Strings.isNullOrEmpty((String)((String)this.m_dashletSpec.getParameters().get("title")))) {
                dashboardSelect.select(this.m_dashletSpec.getParameters().get("title"));
            }
            timeRangeFrom.setValue((String)this.m_dashletSpec.getParameters().get("from"));
            timeRangeTo.setValue((String)this.m_dashletSpec.getParameters().get("to"));
            grafanaDashletQuickRangePicker.selectQuickRange((String)timeRangeFrom.getValue(), (String)timeRangeTo.getValue());
        }
        catch (GrafanaDashletException e2) {
            Label errorLabel = new Label("<b>Error retrieving Grafana Dashboards via HTTP API!</b><br/>Please verify that the following entries are correctly configured in your opennms.properties:<ul><li>org.opennms.grafanaBox.apiKey</li><li>org.opennms.grafanaBox.protocol</li><li>org.opennms.grafanaBox.hostname</li><li>org.opennms.grafanaBox.port</li></ul>Error message:<br/><pre>" + StringEscapeUtils.escapeHtml((String)e2.getMessage()) + "</pre>");
            errorLabel.setContentMode(ContentMode.HTML);
            VerticalLayout errorLayout = new VerticalLayout();
            errorLayout.addComponent((Component)errorLabel);
            VerticalLayout verticalLayout = new VerticalLayout();
            verticalLayout.setMargin(true);
            HorizontalLayout closeButtonLayout = new HorizontalLayout();
            closeButtonLayout.setMargin(true);
            closeButtonLayout.setSpacing(true);
            closeButtonLayout.setWidth("100%");
            Button closeButton = new Button("Close", (Button.ClickListener & Serializable)event -> this.close());
            closeButton.setClickShortcut(13, null);
            closeButtonLayout.addComponent((Component)closeButton);
            verticalLayout.addComponent((Component)errorLayout);
            verticalLayout.addComponent((Component)closeButtonLayout);
            verticalLayout.setExpandRatio((Component)errorLayout, 0.85f);
            verticalLayout.setExpandRatio((Component)closeButtonLayout, 0.15f);
            verticalLayout.setSizeFull();
            this.setContent((Component)verticalLayout);
            return;
        }
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing");
        cancel.addClickListener((Button.ClickListener & Serializable)e -> this.close());
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener((Button.ClickListener & Serializable)e -> {
            this.m_dashletSpec.getParameters().put("uri", grafanaDashboards.get(dashboardSelect.getValue().toString()));
            this.m_dashletSpec.getParameters().put("title", dashboardSelect.getValue().toString());
            this.m_dashletSpec.getParameters().put("from", timeRangeFrom.getValue());
            this.m_dashletSpec.getParameters().put("to", timeRangeTo.getValue());
            WallboardProvider.getInstance().save();
            ((WallboardConfigUI)this.getUI()).notifyMessage("Data saved", "Properties");
            this.close();
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setMargin(true);
        verticalLayout.addComponent((Component)topLayout);
        verticalLayout.addComponent((Component)buttonLayout);
        verticalLayout.setExpandRatio((Component)topLayout, 0.85f);
        verticalLayout.setExpandRatio((Component)buttonLayout, 0.15f);
        verticalLayout.setSizeFull();
        this.setContent((Component)verticalLayout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getGrafanaDashboards() throws GrafanaDashletException {
        String grafanaApiKey = System.getProperty("org.opennms.grafanaBox.apiKey", "");
        String grafanaProtocol = System.getProperty("org.opennms.grafanaBox.protocol", "http");
        String grafanaHostname = System.getProperty("org.opennms.grafanaBox.hostname", "localhost");
        int grafanaPort = Integer.parseInt(System.getProperty("org.opennms.grafanaBox.port", "3000"));
        int grafanaConnectionTimeout = Integer.parseInt(System.getProperty("org.opennms.grafanaBox.connectionTimeout", "500"));
        int grafanaSoTimeout = Integer.parseInt(System.getProperty("org.opennms.grafanaBox.soTimeout", "500"));
        if ("".equals(grafanaApiKey)) throw new GrafanaDashletException("Invalid configuration");
        if ("".equals(grafanaHostname)) throw new GrafanaDashletException("Invalid configuration");
        if ("".equals(grafanaProtocol)) throw new GrafanaDashletException("Invalid configuration");
        if (!"http".equals(grafanaProtocol)) {
            if (!"https".equals(grafanaProtocol)) throw new GrafanaDashletException("Invalid configuration");
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            TreeMap<String, String> resultSet;
            block30: {
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(grafanaConnectionTimeout).setSocketTimeout(grafanaSoTimeout).build();
                URI uri = new URIBuilder().setScheme(grafanaProtocol).setHost(grafanaHostname).setPort(grafanaPort).setPath("/api/search/").build();
                HttpGet httpGet = new HttpGet(uri);
                httpGet.setConfig(requestConfig);
                httpGet.setHeader("Authorization", "Bearer " + grafanaApiKey);
                resultSet = new TreeMap<String, String>();
                try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                    String responseString;
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity == null || Strings.isNullOrEmpty((String)(responseString = IOUtils.toString((InputStream)httpEntity.getContent(), (String)StandardCharsets.UTF_8.name())))) break block30;
                    try {
                        JSONArray arr = new JSONObject("{dashboards:" + responseString + "}").getJSONArray("dashboards");
                        for (int i = 0; i < arr.length(); ++i) {
                            resultSet.put(arr.getJSONObject(i).getString("title"), arr.getJSONObject(i).getString("uri"));
                        }
                    }
                    catch (JSONException e) {
                        throw new GrafanaDashletException(e.getMessage());
                    }
                }
            }
            TreeMap<String, String> treeMap = resultSet;
            return treeMap;
        }
        catch (Exception e) {
            throw new GrafanaDashletException(e.getMessage());
        }
    }

    public static class GrafanaDashletException
    extends Exception {
        public GrafanaDashletException(String message) {
            super(message);
        }
    }
}

