/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.data.Property;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.Iterator;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.config.charts.BarChart;
import org.opennms.web.charts.ChartUtils;

public class ChartsConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;
    private CheckBox m_maximizeWidth;
    private CheckBox m_maximizeHeight;
    private NativeSelect m_chartSelect;

    public ChartsConfigurationWindow(DashletSpec dashletSpec) {
        this.m_dashletSpec = dashletSpec;
        this.setHeight(410.0f, Sizeable.Unit.PIXELS);
        this.setWidth(40.0f, Sizeable.Unit.PERCENTAGE);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setMargin(true);
        FormLayout formLayout = new FormLayout();
        formLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        formLayout.setSpacing(true);
        formLayout.setMargin(true);
        this.m_maximizeWidth = new CheckBox();
        this.m_maximizeWidth.setCaption("Maximize width");
        this.m_maximizeWidth.setDescription("Maximize width");
        this.m_maximizeHeight = new CheckBox();
        this.m_maximizeHeight.setCaption("Maximize height");
        this.m_maximizeHeight.setDescription("Maximize height");
        String maximizeWidthString = (String)this.m_dashletSpec.getParameters().get("maximizeWidth");
        String maximizeHeightString = (String)this.m_dashletSpec.getParameters().get("maximizeHeight");
        boolean maximizeHeight = "true".equals(maximizeHeightString) || "yes".equals(maximizeHeightString) || "1".equals(maximizeHeightString);
        boolean maximizeWidth = "true".equals(maximizeWidthString) || "yes".equals(maximizeWidthString) || "1".equals(maximizeWidthString);
        this.m_maximizeWidth.setValue((Object)maximizeWidth);
        this.m_maximizeHeight.setValue((Object)maximizeHeight);
        this.m_chartSelect = new NativeSelect();
        this.m_chartSelect.setDescription("Select chart to be displayed");
        this.m_chartSelect.setCaption("Chart");
        this.m_chartSelect.setNullSelectionAllowed(false);
        this.m_chartSelect.setInvalidAllowed(false);
        this.m_chartSelect.setNewItemsAllowed(false);
        String firstChartName = null;
        try {
            Iterator it = ChartUtils.getChartCollectionIterator();
            while (it.hasNext()) {
                BarChart chartConfig = (BarChart)it.next();
                if (firstChartName == null) {
                    firstChartName = chartConfig.getName();
                }
                this.m_chartSelect.addItem((Object)chartConfig.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String chartName = (String)this.m_dashletSpec.getParameters().get("chart");
        if (chartName == null || "".equals(chartName)) {
            chartName = firstChartName;
        }
        final Panel panel = new Panel();
        panel.setWidth(230.0f, Sizeable.Unit.PIXELS);
        panel.setCaption("Preview");
        formLayout.addComponent((Component)this.m_chartSelect);
        Page.getCurrent().getStyles().add(".preview { width:225px; }");
        this.m_chartSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                String newImage = "/opennms/charts?chart-name=" + valueChangeEvent.getProperty().getValue();
                Image image = new Image(null, (Resource)new ExternalResource(newImage));
                image.setStyleName("preview");
                panel.setContent((Component)image);
            }
        });
        this.m_chartSelect.setValue((Object)chartName);
        this.m_chartSelect.setImmediate(true);
        formLayout.addComponent((Component)this.m_maximizeWidth);
        formLayout.addComponent((Component)this.m_maximizeHeight);
        horizontalLayout.addComponent((Component)formLayout);
        horizontalLayout.addComponent((Component)panel);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ChartsConfigurationWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ChartsConfigurationWindow.this.m_dashletSpec.getParameters().put("maximizeWidth", (Boolean)ChartsConfigurationWindow.this.m_maximizeWidth.getValue() != false ? "true" : "false");
                ChartsConfigurationWindow.this.m_dashletSpec.getParameters().put("maximizeHeight", (Boolean)ChartsConfigurationWindow.this.m_maximizeHeight.getValue() != false ? "true" : "false");
                ChartsConfigurationWindow.this.m_dashletSpec.getParameters().put("chart", String.valueOf(ChartsConfigurationWindow.this.m_chartSelect.getValue()));
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)ChartsConfigurationWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                ChartsConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)buttonLayout);
        this.setContent((Component)verticalLayout);
    }
}

