/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.TextField;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.dashlets.BSMConfigHelper;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteriaBuilder;
import org.opennms.netmgt.bsm.service.model.Status;

public class BSMConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;
    private CheckBox m_filterByNameCheckBox;
    private CheckBox m_filterByAttributeCheckBox;
    private CheckBox m_filterBySeverityCheckBox;
    private TextField m_nameTextField;
    private TextField m_attributeKeyTextField;
    private TextField m_attributeValueTextField;
    private TextField m_limitTextField;
    private TextField m_columnCountBoardTextField;
    private TextField m_columnCountPanelTextField;
    private NativeSelect m_severitySelect;
    private NativeSelect m_compareOperatorSelect;
    private NativeSelect m_orderBy;
    private NativeSelect m_orderSequence;

    public BSMConfigurationWindow(DashletSpec dashletSpec) {
        this.m_dashletSpec = dashletSpec;
        this.setHeight(91.0f, Sizeable.Unit.PERCENTAGE);
        this.setWidth(60.0f, Sizeable.Unit.PERCENTAGE);
        boolean filterByName = BSMConfigHelper.getBooleanForKey(this.getDashletSpec().getParameters(), "filterByName");
        String nameValue = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "nameValue", "");
        boolean filterByAttribute = BSMConfigHelper.getBooleanForKey(this.getDashletSpec().getParameters(), "filterByAttribute");
        String attributeKey = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "attributeKey", "");
        String attributeValue = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "attributeValue", "");
        boolean filterBySeverity = BSMConfigHelper.getBooleanForKey(this.getDashletSpec().getParameters(), "filterBySeverity");
        String severityValue = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "severityValue", Status.WARNING.name());
        String severityCompareOperator = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "severityCompareOperator", BusinessServiceSearchCriteriaBuilder.CompareOperator.GreaterOrEqual.name());
        String orderBy = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "orderBy", BusinessServiceSearchCriteriaBuilder.Order.Name.name());
        String orderSequence = BSMConfigHelper.getStringForKey(this.getDashletSpec().getParameters(), "orderSequence", BusinessServiceSearchCriteriaBuilder.Sequence.Ascending.name());
        int resultsLimit = BSMConfigHelper.getIntForKey(this.getDashletSpec().getParameters(), "resultsLimit", 10);
        int columnCountBoard = BSMConfigHelper.getIntForKey(this.getDashletSpec().getParameters(), "columnCountBoard", 10);
        int columnCountPanel = BSMConfigHelper.getIntForKey(this.getDashletSpec().getParameters(), "columnCountPanel", 5);
        this.m_filterByNameCheckBox = new CheckBox();
        this.m_filterByNameCheckBox.setCaption("Enable");
        this.m_filterByNameCheckBox.setDescription("Filter by Business Service name");
        VerticalLayout nameLayout = new VerticalLayout();
        nameLayout.setSpacing(true);
        nameLayout.setMargin(true);
        nameLayout.setSizeFull();
        this.m_nameTextField = new TextField("Name (REGEXP)");
        this.m_nameTextField.setEnabled(false);
        this.addToComponent(nameLayout, (Component)this.m_filterByNameCheckBox);
        this.addToComponent(nameLayout, (Component)this.m_nameTextField);
        Panel namePanel = new Panel();
        namePanel.setCaption("Filter by Name");
        namePanel.setContent((Component)nameLayout);
        this.m_filterByNameCheckBox.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                BSMConfigurationWindow.this.m_nameTextField.setEnabled(((Boolean)BSMConfigurationWindow.this.m_filterByNameCheckBox.getValue()).booleanValue());
            }
        });
        this.m_nameTextField.setValue(nameValue);
        this.m_filterByNameCheckBox.setValue((Object)filterByName);
        this.m_filterByAttributeCheckBox = new CheckBox();
        this.m_filterByAttributeCheckBox.setCaption("Enable");
        this.m_filterByAttributeCheckBox.setDescription("Filter by Business Service attribute");
        VerticalLayout attributeLayout = new VerticalLayout();
        attributeLayout.setSpacing(true);
        attributeLayout.setMargin(true);
        attributeLayout.setSizeFull();
        this.m_attributeKeyTextField = new TextField("Key");
        this.m_attributeKeyTextField.setEnabled(false);
        this.m_attributeValueTextField = new TextField("Value (REGEXP)");
        this.m_attributeValueTextField.setEnabled(false);
        this.addToComponent(attributeLayout, (Component)this.m_filterByAttributeCheckBox);
        this.addToComponent(attributeLayout, (Component)this.m_attributeKeyTextField);
        this.addToComponent(attributeLayout, (Component)this.m_attributeValueTextField);
        Panel attributePanel = new Panel();
        attributePanel.setCaption("Filter by Attribute");
        attributePanel.setContent((Component)attributeLayout);
        this.m_filterByAttributeCheckBox.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                BSMConfigurationWindow.this.m_attributeKeyTextField.setEnabled(((Boolean)BSMConfigurationWindow.this.m_filterByAttributeCheckBox.getValue()).booleanValue());
                BSMConfigurationWindow.this.m_attributeValueTextField.setEnabled(((Boolean)BSMConfigurationWindow.this.m_filterByAttributeCheckBox.getValue()).booleanValue());
            }
        });
        this.m_attributeKeyTextField.setValue(attributeKey);
        this.m_attributeValueTextField.setValue(attributeValue);
        this.m_filterByAttributeCheckBox.setValue((Object)filterByAttribute);
        this.m_filterBySeverityCheckBox = new CheckBox();
        this.m_filterBySeverityCheckBox.setCaption("Enable");
        this.m_filterBySeverityCheckBox.setDescription("Filter by Business Service severity");
        VerticalLayout severityLayout = new VerticalLayout();
        severityLayout.setSpacing(true);
        severityLayout.setMargin(true);
        severityLayout.setSizeFull();
        this.m_severitySelect = new NativeSelect("Severity");
        this.m_severitySelect.setEnabled(false);
        this.m_severitySelect.setNullSelectionAllowed(false);
        this.m_severitySelect.setMultiSelect(false);
        for (Status eachStatus : Status.values()) {
            this.m_severitySelect.addItem((Object)eachStatus.name());
        }
        this.m_compareOperatorSelect = new NativeSelect("Comparator");
        this.m_compareOperatorSelect.setEnabled(false);
        this.m_compareOperatorSelect.setNullSelectionAllowed(false);
        this.m_compareOperatorSelect.setMultiSelect(false);
        this.m_compareOperatorSelect.addItem((Object)BusinessServiceSearchCriteriaBuilder.CompareOperator.Lower.name());
        this.m_compareOperatorSelect.addItem((Object)BusinessServiceSearchCriteriaBuilder.CompareOperator.LowerOrEqual.name());
        this.m_compareOperatorSelect.addItem((Object)BusinessServiceSearchCriteriaBuilder.CompareOperator.Equal.name());
        this.m_compareOperatorSelect.addItem((Object)BusinessServiceSearchCriteriaBuilder.CompareOperator.GreaterOrEqual.name());
        this.m_compareOperatorSelect.addItem((Object)BusinessServiceSearchCriteriaBuilder.CompareOperator.Greater.name());
        this.addToComponent(severityLayout, (Component)this.m_filterBySeverityCheckBox);
        this.addToComponent(severityLayout, (Component)this.m_severitySelect);
        this.addToComponent(severityLayout, (Component)this.m_compareOperatorSelect);
        Panel severityPanel = new Panel();
        severityPanel.setCaption("Filter by Severity");
        severityPanel.setContent((Component)severityLayout);
        this.m_filterBySeverityCheckBox.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                BSMConfigurationWindow.this.m_severitySelect.setEnabled(((Boolean)BSMConfigurationWindow.this.m_filterBySeverityCheckBox.getValue()).booleanValue());
                BSMConfigurationWindow.this.m_compareOperatorSelect.setEnabled(((Boolean)BSMConfigurationWindow.this.m_filterBySeverityCheckBox.getValue()).booleanValue());
            }
        });
        this.m_severitySelect.setValue((Object)severityValue);
        this.m_compareOperatorSelect.setValue((Object)severityCompareOperator);
        this.m_filterBySeverityCheckBox.setValue((Object)filterBySeverity);
        VerticalLayout limitLayout = new VerticalLayout();
        limitLayout.setSpacing(true);
        limitLayout.setMargin(true);
        limitLayout.setSizeFull();
        this.m_limitTextField = new TextField("Limit");
        this.m_orderBy = new NativeSelect("Order by");
        this.m_orderBy.setNullSelectionAllowed(false);
        this.m_orderBy.setMultiSelect(false);
        this.m_orderBy.addItem((Object)BusinessServiceSearchCriteriaBuilder.Order.Name.name());
        this.m_orderBy.addItem((Object)BusinessServiceSearchCriteriaBuilder.Order.Severity.name());
        this.m_orderBy.addItem((Object)BusinessServiceSearchCriteriaBuilder.Order.Level.name());
        this.m_orderSequence = new NativeSelect("Asc/Desc ");
        this.m_orderSequence.setNullSelectionAllowed(false);
        this.m_orderSequence.setMultiSelect(false);
        this.m_orderSequence.addItem((Object)"Ascending");
        this.m_orderSequence.addItem((Object)"Descending");
        this.m_columnCountBoardTextField = new TextField("Ops Board Column Count");
        this.m_columnCountBoardTextField.addValidator((Validator)new AbstractStringValidator("Number greater zero expected"){

            protected boolean isValidValue(String value) {
                try {
                    int i = Integer.parseInt(value);
                    return i > 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        this.m_columnCountPanelTextField = new TextField("Ops Panel Column Count");
        this.m_columnCountPanelTextField.addValidator((Validator)new AbstractStringValidator("Number greater zero expected"){

            protected boolean isValidValue(String value) {
                try {
                    int i = Integer.parseInt(value);
                    return i > 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        this.addToComponent(limitLayout, (Component)this.m_limitTextField);
        this.addToComponent(limitLayout, (Component)this.m_orderBy);
        this.addToComponent(limitLayout, (Component)this.m_orderSequence);
        this.addToComponent(limitLayout, (Component)this.m_columnCountBoardTextField);
        this.addToComponent(limitLayout, (Component)this.m_columnCountPanelTextField);
        Panel limitPanel = new Panel();
        limitPanel.setSizeFull();
        limitPanel.setCaption("Results");
        limitPanel.setContent((Component)limitLayout);
        this.m_limitTextField.setValue(String.valueOf(resultsLimit));
        this.m_orderBy.setValue((Object)orderBy);
        this.m_orderSequence.setValue((Object)orderSequence);
        this.m_columnCountBoardTextField.setValue(String.valueOf(columnCountBoard));
        this.m_columnCountPanelTextField.setValue(String.valueOf(columnCountPanel));
        this.m_limitTextField.addValidator((Validator)new AbstractStringValidator("Number greater or equal zero expected"){

            protected boolean isValidValue(String value) {
                try {
                    int i = Integer.parseInt(value);
                    return i >= 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        verticalLayout.setSpacing(true);
        verticalLayout.setMargin(true);
        verticalLayout.addComponent((Component)namePanel);
        verticalLayout.addComponent((Component)attributePanel);
        HorizontalLayout bottomLayout = new HorizontalLayout(new Component[]{severityPanel, limitPanel});
        bottomLayout.setSpacing(true);
        bottomLayout.setSizeFull();
        bottomLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        verticalLayout.addComponent((Component)bottomLayout);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Label label = new Label("Note: Multiple enabled filter constraints will be combined by a logical AND.");
        buttonLayout.addComponent((Component)label);
        buttonLayout.setExpandRatio((Component)label, 1.0f);
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                BSMConfigurationWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (!(BSMConfigurationWindow.this.m_limitTextField.isValid() && BSMConfigurationWindow.this.m_columnCountPanelTextField.isValid() && BSMConfigurationWindow.this.m_columnCountBoardTextField.isValid())) {
                    return;
                }
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("filterByName", (Boolean)BSMConfigurationWindow.this.m_filterByNameCheckBox.getValue() != false ? "true" : "false");
                if (((Boolean)BSMConfigurationWindow.this.m_filterByNameCheckBox.getValue()).booleanValue()) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("nameValue", BSMConfigurationWindow.this.m_nameTextField.getValue());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("nameValue", "");
                }
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("filterByAttribute", (Boolean)BSMConfigurationWindow.this.m_filterByAttributeCheckBox.getValue() != false ? "true" : "false");
                if (((Boolean)BSMConfigurationWindow.this.m_filterByAttributeCheckBox.getValue()).booleanValue()) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("attributeKey", BSMConfigurationWindow.this.m_attributeKeyTextField.getValue());
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("attributeValue", BSMConfigurationWindow.this.m_attributeValueTextField.getValue());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("attributeKey", "");
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("attributeValue", "");
                }
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("filterBySeverity", (Boolean)BSMConfigurationWindow.this.m_filterBySeverityCheckBox.getValue() != false ? "true" : "false");
                if (((Boolean)BSMConfigurationWindow.this.m_filterBySeverityCheckBox.getValue()).booleanValue() && BSMConfigurationWindow.this.m_severitySelect.getValue() != null) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("severityValue", BSMConfigurationWindow.this.m_severitySelect.getValue().toString());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("severityValue", Status.WARNING.getLabel());
                }
                if (((Boolean)BSMConfigurationWindow.this.m_filterBySeverityCheckBox.getValue()).booleanValue() && BSMConfigurationWindow.this.m_compareOperatorSelect.getValue() != null) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("severityCompareOperator", BSMConfigurationWindow.this.m_compareOperatorSelect.getValue().toString());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("severityCompareOperator", BusinessServiceSearchCriteriaBuilder.CompareOperator.GreaterOrEqual.name());
                }
                if (BSMConfigurationWindow.this.m_orderBy.getValue() != null) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("orderBy", BSMConfigurationWindow.this.m_orderBy.getValue().toString());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("orderBy", BusinessServiceSearchCriteriaBuilder.Order.Name.name());
                }
                if (BSMConfigurationWindow.this.m_orderSequence.getValue() != null) {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("orderSequence", BSMConfigurationWindow.this.m_orderSequence.getValue().toString());
                } else {
                    BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("orderSequence", "Ascending");
                }
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("resultsLimit", ((String)BSMConfigurationWindow.this.m_limitTextField.getValue()).toString());
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("columnCountBoard", ((String)BSMConfigurationWindow.this.m_columnCountBoardTextField.getValue()).toString());
                BSMConfigurationWindow.this.m_dashletSpec.getParameters().put("columnCountPanel", ((String)BSMConfigurationWindow.this.m_columnCountPanelTextField.getValue()).toString());
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)BSMConfigurationWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                BSMConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        verticalLayout.addComponent((Component)buttonLayout);
        this.setContent((Component)verticalLayout);
    }

    private void addToComponent(VerticalLayout verticalLayout, Component component) {
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Label label = new Label(component.getCaption());
        label.setWidth(200.0f, Sizeable.Unit.PIXELS);
        component.setSizeFull();
        component.setCaption(null);
        horizontalLayout.addComponent((Component)label);
        horizontalLayout.addComponent(component);
        horizontalLayout.setExpandRatio(component, 1.0f);
        verticalLayout.addComponent((Component)horizontalLayout);
    }

    private DashletSpec getDashletSpec() {
        return this.m_dashletSpec;
    }
}

