/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.List;
import org.opennms.features.vaadin.dashboard.dashlets.BSMConfigHelper;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.bsm.service.BusinessServiceManager;
import org.opennms.netmgt.bsm.service.BusinessServiceSearchCriteria;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;

public class BSMDashlet
extends AbstractDashlet {
    private BusinessServiceManager m_businessServiceManager;
    private boolean boosted = false;
    private DashletComponent m_wallboardComponent = null;
    private DashletComponent m_dashboardComponent = null;
    private BusinessServiceSearchCriteria m_businessServiceSearchCriteria;
    private int m_columnCountBoard;
    private int m_columnCountPanel;

    public BSMDashlet(String name, DashletSpec dashletSpec, BusinessServiceManager businessServiceManager, TransactionAwareBeanProxyFactory transactionAwareBeanProxyFactory) {
        super(name, dashletSpec);
        this.m_businessServiceManager = (BusinessServiceManager)transactionAwareBeanProxyFactory.createProxy((Object)businessServiceManager);
        this.m_businessServiceSearchCriteria = BSMConfigHelper.fromMap(this.getDashletSpec().getParameters());
        this.m_columnCountBoard = BSMConfigHelper.getIntForKey(this.getDashletSpec().getParameters(), "columnCountBoard", 10);
        this.m_columnCountPanel = BSMConfigHelper.getIntForKey(this.getDashletSpec().getParameters(), "columnCountPanel", 5);
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new BSMDashletComponent(1, this.m_columnCountBoard);
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent() {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new BSMDashletComponent(1, this.m_columnCountPanel);
        }
        return this.m_dashboardComponent;
    }

    private HorizontalLayout createRow(BusinessService service) {
        HorizontalLayout rowLayout = new HorizontalLayout();
        rowLayout.setSizeFull();
        rowLayout.setSpacing(true);
        Status severity = this.m_businessServiceManager.getOperationalStatus(service);
        Label nameLabel = new Label(service.getName());
        nameLabel.setSizeFull();
        nameLabel.setStyleName("h3");
        nameLabel.addStyleName("bright");
        nameLabel.addStyleName("severity");
        nameLabel.addStyleName(severity.getLabel());
        rowLayout.addComponent((Component)nameLabel);
        return rowLayout;
    }

    public boolean isBoosted() {
        return this.boosted;
    }

    private class BSMDashletComponent
    extends AbstractDashletComponent {
        private final GridLayout m_gridLayout;

        private BSMDashletComponent(int rowCount, int columnCount) {
            this.m_gridLayout = new GridLayout(columnCount, rowCount);
            this.m_gridLayout.setCaption(BSMDashlet.this.getName());
            this.m_gridLayout.setWidth("100%");
            this.refresh();
        }

        public void refresh() {
            this.m_gridLayout.removeAllComponents();
            List services = BSMDashlet.this.m_businessServiceManager.search(BSMDashlet.this.m_businessServiceSearchCriteria);
            if (services.isEmpty()) {
                this.m_gridLayout.addComponent((Component)new Label("There are no Business Services with matching criterias found."));
            } else {
                for (BusinessService eachService : services) {
                    this.m_gridLayout.addComponent((Component)BSMDashlet.this.createRow(eachService));
                }
            }
            BSMDashlet.this.boosted = false;
        }

        public Component getComponent() {
            return this.m_gridLayout;
        }
    }
}

