/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.google.common.collect.Lists;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.Label;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmsDashlet
extends AbstractDashlet {
    private AlarmDao m_alarmDao;
    private NodeDao m_nodeDao;
    private boolean boosted = false;
    private CriteriaBuilderHelper m_criteriaBuilderHelper = new CriteriaBuilderHelper(OnmsAlarm.class, new Class[]{OnmsNode.class, OnmsCategory.class, OnmsEvent.class});
    private DashletComponent m_wallboardComponent = null;
    private DashletComponent m_dashboardComponent = null;

    public AlarmsDashlet(String name, DashletSpec dashletSpec, AlarmDao alarmDao, NodeDao nodeDao) {
        super(name, dashletSpec);
        this.m_alarmDao = alarmDao;
        this.m_nodeDao = nodeDao;
    }

    public DashletComponent getWallboardComponent(final UI ui) {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(AlarmsDashlet.this.getName());
                    this.m_verticalLayout.setWidth("100%");
                    this.injectWallboardStyles();
                    this.refresh();
                }

                private void injectWallboardStyles() {
                    ui.getPage().getStyles().add(".alerts.cleared { background: #000000; border-left: 15px solid #858585; }");
                    ui.getPage().getStyles().add(".alerts.normal { background: #000000; border-left: 15px solid #336600; }");
                    ui.getPage().getStyles().add(".alerts.indeterminate {  background: #000000; border-left: 15px solid #999; }");
                    ui.getPage().getStyles().add(".alerts.warning { background: #000000; border-left: 15px solid #FFCC00; }");
                    ui.getPage().getStyles().add(".alerts.minor { background: #000000;  border-left: 15px solid #FF9900; }");
                    ui.getPage().getStyles().add(".alerts.major { background: #000000; border-left: 15px solid #FF3300; }");
                    ui.getPage().getStyles().add(".alerts.critical { background: #000000; border-left: 15px solid #CC0000; }");
                    ui.getPage().getStyles().add(".alerts-font {color: #3ba300; font-size: 18px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alerts-noalarms-font { font-size: 18px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alerts { padding: 5px 5px; margin: 1px; }");
                    ui.getPage().getStyles().add(".v-slot-alerts-font { overflow: hidden; }");
                }

                public void refresh() {
                    List alarms = AlarmsDashlet.this.getAlarms();
                    OnmsSeverity boostSeverity = OnmsSeverity.valueOf((String)((String)AlarmsDashlet.this.getDashletSpec().getParameters().get("boostSeverity")));
                    this.m_verticalLayout.removeAllComponents();
                    AlarmsDashlet.this.boosted = false;
                    AlarmsDashlet.this.addComponents((AbstractOrderedLayout)this.m_verticalLayout, alarms);
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent(final UI ui) {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(AlarmsDashlet.this.getName());
                    this.m_verticalLayout.setWidth("100%");
                    this.injectDashboardStyles();
                    this.refresh();
                }

                private void injectDashboardStyles() {
                    ui.getPage().getStyles().add(".alerts.cleared { background: #000000; border-left: 8px solid #858585; }");
                    ui.getPage().getStyles().add(".alerts.normal { background: #000000; border-left: 8px solid #336600; }");
                    ui.getPage().getStyles().add(".alerts.indeterminate {  background: #000000; border-left: 8px solid #999; }");
                    ui.getPage().getStyles().add(".alerts.warning { background: #000000; border-left: 8px solid #FFCC00; }");
                    ui.getPage().getStyles().add(".alerts.minor { background: #000000;  border-left: 8px solid #FF9900; }");
                    ui.getPage().getStyles().add(".alerts.major { background: #000000; border-left: 8px solid #FF3300; }");
                    ui.getPage().getStyles().add(".alerts.critical { background: #000000; border-left: 8px solid #CC0000; }");
                    ui.getPage().getStyles().add(".alerts-font {color: #3ba300; font-size: 11px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alerts-noalarms-font { font-size: 11px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alerts { padding: 5px 5px; margin: 1px; }");
                    ui.getPage().getStyles().add(".v-slot-alerts-font { overflow: hidden; }");
                }

                public void refresh() {
                    List alarms = AlarmsDashlet.this.getAlarms();
                    this.m_verticalLayout.removeAllComponents();
                    AlarmsDashlet.this.boosted = false;
                    AlarmsDashlet.this.addComponents((AbstractOrderedLayout)this.m_verticalLayout, alarms);
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashboardComponent;
    }

    private List<OnmsAlarm> getAlarms() {
        CriteriaBuilder alarmCb = new CriteriaBuilder(OnmsAlarm.class);
        alarmCb.alias("node", "node");
        alarmCb.alias("node.categories", "category");
        alarmCb.alias("lastEvent", "event");
        String criteria = (String)this.getDashletSpec().getParameters().get("criteria");
        this.m_criteriaBuilderHelper.parseConfiguration(alarmCb, criteria);
        alarmCb.fetch("firstEvent", Fetch.FetchType.EAGER);
        alarmCb.fetch("lastEvent", Fetch.FetchType.EAGER);
        List onmsAlarmList = this.m_alarmDao.findMatching(alarmCb.toCriteria());
        LinkedHashMap<Integer, OnmsAlarm> onmsAlarmMap = new LinkedHashMap<Integer, OnmsAlarm>();
        for (OnmsAlarm onmsAlarm : onmsAlarmList) {
            if (onmsAlarmMap.containsKey(onmsAlarm.getId())) continue;
            onmsAlarmMap.put(onmsAlarm.getId(), onmsAlarm);
        }
        return Lists.newArrayList(onmsAlarmMap.values());
    }

    private void addComponents(AbstractOrderedLayout component, List<OnmsAlarm> alarms) {
        if (alarms.size() == 0) {
            Label label = new Label("No alarms found!");
            label.addStyleName("alerts-noalarms-font");
            component.addComponent((Component)label);
        } else {
            for (OnmsAlarm onmsAlarm : alarms) {
                OnmsNode onmsNode = null;
                if (onmsAlarm.getNodeId() != null) {
                    CriteriaBuilder nodeCb = new CriteriaBuilder(OnmsNode.class);
                    nodeCb.eq("id", (Object)onmsAlarm.getNodeId());
                    List nodes = this.m_nodeDao.findMatching(nodeCb.toCriteria());
                    if (nodes.size() == 1) {
                        onmsNode = (OnmsNode)nodes.get(0);
                    }
                }
                component.addComponent(this.createAlarmComponent(onmsAlarm, onmsNode));
                OnmsSeverity boostSeverity = OnmsSeverity.valueOf((String)((String)this.getDashletSpec().getParameters().get("boostSeverity")));
                if (!onmsAlarm.getSeverity().isGreaterThanOrEqual(boostSeverity)) continue;
                this.boosted = true;
            }
        }
    }

    public String getHumanReadableFormat(long secondsAll) {
        long rest;
        long seconds = secondsAll;
        long minutes = 0L;
        long hours = 0L;
        if (seconds / 60L > 0L) {
            rest = seconds % 60L;
            minutes = seconds / 60L;
            seconds = rest;
        }
        if (minutes / 60L > 0L) {
            rest = minutes % 60L;
            hours = minutes / 60L;
            minutes = rest;
        }
        String output = "";
        output = hours > 0L ? hours + "h, " + minutes + "m, " + seconds + "s" : (minutes > 0L ? minutes + "m, " + seconds + "s" : seconds + "s");
        return output + " ago";
    }

    private Component createAlarmComponent(OnmsAlarm onmsAlarm, OnmsNode onmsNode) {
        Calendar calendar = Calendar.getInstance();
        String ago = this.getHumanReadableFormat(calendar.getTimeInMillis() / 1000L - onmsAlarm.getLastEventTime().getTime() / 1000L);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth("100%");
        horizontalLayout.addStyleName("alerts");
        horizontalLayout.addStyleName(onmsAlarm.getSeverity().name().toLowerCase());
        Label labelAgo = new Label();
        labelAgo.setSizeUndefined();
        labelAgo.addStyleName("alerts-font");
        labelAgo.setValue(ago);
        Label labelId = new Label();
        labelId.setSizeUndefined();
        labelId.addStyleName("alerts-font");
        if (onmsNode != null) {
            labelId.setValue(onmsNode.getLabel() + " (" + onmsNode.getNodeId() + ")");
        } else {
            labelId.setValue("-");
        }
        Label labelUei = new Label();
        labelUei.setSizeUndefined();
        labelUei.addStyleName("alerts-font");
        labelUei.setValue(onmsAlarm.getUei());
        horizontalLayout.addComponent((Component)labelAgo);
        horizontalLayout.addComponent((Component)labelId);
        horizontalLayout.addComponent((Component)labelUei);
        horizontalLayout.setExpandRatio((Component)labelAgo, 1.0f);
        horizontalLayout.setExpandRatio((Component)labelId, 3.0f);
        horizontalLayout.setExpandRatio((Component)labelUei, 3.0f);
        return horizontalLayout;
    }

    public boolean isBoosted() {
        return this.boosted;
    }
}

