/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.google.common.collect.Lists;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.features.timeformat.api.TimeformatService;
import org.opennms.features.topology.api.browsers.OnmsVaadinContainer;
import org.opennms.features.topology.plugins.browsers.AlarmDaoContainer;
import org.opennms.features.topology.plugins.browsers.AlarmIdColumnLinkGenerator;
import org.opennms.features.topology.plugins.browsers.AlarmTable;
import org.opennms.features.topology.plugins.browsers.AlarmTableCellStyleGenerator;
import org.opennms.features.topology.plugins.browsers.SeverityGenerator;
import org.opennms.features.topology.plugins.browsers.TimeColumnGenerator;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextImpl;
import org.opennms.vaadin.user.UserTimeZoneExtractor;
import org.springframework.transaction.support.TransactionOperations;

public class AlarmDetailsDashlet
extends AbstractDashlet {
    private final AlarmDao m_alarmDao;
    private final NodeDao m_nodeDao;
    private CriteriaBuilderHelper m_criteriaBuilderHelper = new CriteriaBuilderHelper(OnmsAlarm.class, new Class[]{OnmsNode.class, OnmsCategory.class, OnmsEvent.class});
    DashletComponent m_wallboardComponent;
    DashletComponent m_dashboardComponent;
    private final AlarmRepository m_alarmRepository;
    private final TransactionOperations m_transactionTemplate;
    private final TimeformatService m_timeformatService;

    public AlarmDetailsDashlet(String name, DashletSpec dashletSpec, AlarmDao alarmDao, NodeDao nodeDao, AlarmRepository alarmRepository, TransactionOperations transactionTemplate, TimeformatService timeformatService) {
        super(name, dashletSpec);
        this.m_alarmDao = alarmDao;
        this.m_nodeDao = nodeDao;
        this.m_alarmRepository = alarmRepository;
        this.m_transactionTemplate = transactionTemplate;
        this.m_timeformatService = timeformatService;
    }

    public DashletComponent getWallboardComponent(final UI ui) {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(AlarmDetailsDashlet.this.getName());
                    this.m_verticalLayout.setWidth("100%");
                    this.injectWallboardStyles();
                    this.refresh();
                }

                private void injectWallboardStyles() {
                    ui.getPage().getStyles().add(".alert-details.cleared { background: #AAAAAA; border-left: 14px solid #858585; }");
                    ui.getPage().getStyles().add(".alert-details.normal { background: #AAAAAA; border-left: 14px solid #336600; }");
                    ui.getPage().getStyles().add(".alert-details.indeterminate { background: #AAAAAA; border-left: 14px solid #999; }");
                    ui.getPage().getStyles().add(".alert-details.warning { background: #AAAAAA; border-left: 14px solid #FFCC00; }");
                    ui.getPage().getStyles().add(".alert-details.minor { background: #AAAAAA; border-left: 14px solid #FF9900; }");
                    ui.getPage().getStyles().add(".alert-details.major { background: #AAAAAA; border-left: 14px solid #FF3300; }");
                    ui.getPage().getStyles().add(".alert-details.critical { background: #AAAAAA; border-left: 14px solid #CC0000; }");
                    ui.getPage().getStyles().add(".alert-details-font {color: #000000; font-size: 17px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alert-details-noalarms-font { font-size: 17px; line-height: normal; }");
                    ui.getPage().getStyles().add(".alert-details { padding: 5px 5px; margin: 1px; }");
                }

                public void refresh() {
                    List alarms = AlarmDetailsDashlet.this.getAlarms();
                    this.m_verticalLayout.removeAllComponents();
                    this.setBoosted(false);
                    AlarmDetailsDashlet.this.addComponents(UserTimeZoneExtractor.extractUserTimeZoneIdOrNull((UI)ui), (AbstractOrderedLayout)this.m_verticalLayout, alarms);
                    this.setBoosted(AlarmDetailsDashlet.this.checkBoosted(alarms));
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent(UI ui) {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private AlarmTable m_alarmTable;
                {
                    this.m_alarmTable = new AlarmTable("Alarms", (OnmsVaadinContainer)new AlarmDaoContainer(AlarmDetailsDashlet.this.m_alarmDao, AlarmDetailsDashlet.this.m_transactionTemplate), AlarmDetailsDashlet.this.m_alarmRepository);
                    this.m_alarmTable.setSizeFull();
                    this.m_alarmTable.setSortEnabled(false);
                    this.m_alarmTable.addHeaderClickListener(new Table.HeaderClickListener(){

                        public void headerClick(Table.HeaderClickEvent headerClickEvent) {
                            m_alarmTable.setSortContainerPropertyId(headerClickEvent.getPropertyId());
                            m_alarmTable.setSortEnabled(true);
                        }
                    });
                    VaadinApplicationContextImpl context = new VaadinApplicationContextImpl();
                    UI currentUI = UI.getCurrent();
                    context.setSessionId(currentUI.getSession().getSession().getId());
                    context.setUiId(currentUI.getUIId());
                    this.m_alarmTable.setVaadinApplicationContext((VaadinApplicationContext)context);
                    EventProxy eventProxy = new EventProxy(){

                        public <T> void fireEvent(T eventObject) {
                            System.out.println("got event: {}" + eventObject);
                        }

                        public <T> void addPossibleEventConsumer(T possibleEventConsumer) {
                            System.out.println("(ignoring) add consumer: {}" + possibleEventConsumer);
                        }
                    };
                    this.m_alarmTable.setEventProxy(eventProxy);
                    this.m_alarmTable.setColumnReorderingAllowed(true);
                    this.m_alarmTable.setColumnCollapsingAllowed(true);
                    this.m_alarmTable.setSortContainerPropertyId((Object)"id");
                    this.m_alarmTable.setSortAscending(false);
                    this.m_alarmTable.setCellStyleGenerator((Table.CellStyleGenerator)new AlarmTableCellStyleGenerator());
                    this.m_alarmTable.addGeneratedColumn((Object)"severity", (Table.ColumnGenerator)new SeverityGenerator());
                    this.m_alarmTable.addGeneratedColumn((Object)"id", (Table.ColumnGenerator)new AlarmIdColumnLinkGenerator(AlarmDetailsDashlet.this.m_alarmDao, "id"));
                    this.m_alarmTable.addGeneratedColumn((Object)"lastEventTime", (Table.ColumnGenerator)new TimeColumnGenerator(AlarmDetailsDashlet.this.m_timeformatService));
                    this.m_alarmTable.setVisibleColumns(new Object[]{"id", "severity", "nodeLabel", "counter", "lastEventTime", "logMsg"});
                    this.m_alarmTable.setColumnHeaders(new String[]{"ID", "Severity", "Node", "Count", "Last Event Time", "Log Message"});
                    this.refresh();
                }

                public void refresh() {
                    List alarms = AlarmDetailsDashlet.this.getAlarms();
                    LinkedList<Integer> alarmIds = new LinkedList<Integer>();
                    if (alarms.size() > 0) {
                        for (OnmsAlarm onmsAlarm : alarms) {
                            alarmIds.add(onmsAlarm.getId());
                        }
                    } else {
                        alarmIds.add(0);
                    }
                    LinkedList<InRestriction> restrictions = new LinkedList<InRestriction>();
                    restrictions.add(new InRestriction("id", alarmIds));
                    ((OnmsVaadinContainer)this.m_alarmTable.getContainerDataSource()).setRestrictions(restrictions);
                    this.setBoosted(AlarmDetailsDashlet.this.checkBoosted(alarms));
                    this.m_alarmTable.markAsDirtyRecursive();
                }

                public Component getComponent() {
                    return this.m_alarmTable;
                }
            };
        }
        return this.m_dashboardComponent;
    }

    private boolean checkBoosted(List<OnmsAlarm> alarms) {
        for (OnmsAlarm onmsAlarm : alarms) {
            OnmsSeverity boostSeverity = OnmsSeverity.valueOf((String)((String)this.getDashletSpec().getParameters().get("boostSeverity")));
            if (!onmsAlarm.getSeverity().isGreaterThanOrEqual(boostSeverity)) continue;
            return true;
        }
        return false;
    }

    private List<OnmsAlarm> getAlarms() {
        CriteriaBuilder alarmCb = new CriteriaBuilder(OnmsAlarm.class);
        alarmCb.alias("node", "node");
        alarmCb.alias("node.categories", "category");
        alarmCb.alias("lastEvent", "event");
        String criteria = (String)this.getDashletSpec().getParameters().get("criteria");
        this.m_criteriaBuilderHelper.parseConfiguration(alarmCb, criteria);
        alarmCb.fetch("firstEvent", Fetch.FetchType.EAGER);
        alarmCb.fetch("lastEvent", Fetch.FetchType.EAGER);
        List onmsAlarmList = this.m_alarmDao.findMatching(alarmCb.toCriteria());
        LinkedHashMap<Integer, OnmsAlarm> onmsAlarmMap = new LinkedHashMap<Integer, OnmsAlarm>();
        for (OnmsAlarm onmsAlarm : onmsAlarmList) {
            if (onmsAlarmMap.containsKey(onmsAlarm.getId())) continue;
            onmsAlarmMap.put(onmsAlarm.getId(), onmsAlarm);
        }
        return Lists.newArrayList(onmsAlarmMap.values());
    }

    private void addComponents(ZoneId userTimeZone, AbstractOrderedLayout component, List<OnmsAlarm> alarms) {
        if (alarms.size() == 0) {
            Label label = new Label("No alarms found!");
            label.addStyleName("alert-details-noalarms-font");
            component.addComponent((Component)label);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<table class='alert-details-dashlet onms-table'>");
            sb.append("<thead>");
            sb.append("<th class='alert-details-dashlet onms-header-cell'>ID</th><th class='alert-details-dashlet onms-header-cell'>Severity</th><th class='alert-details-dashlet onms-header-cell'>Node</th><th class='alert-details-dashlet onms-header-cell'>Count</th><th class='alert-details-dashlet onms-header-cell'>Last Event Time</th><th class='alert-details-dashlet onms-header-cell'>Log Msg</th>");
            sb.append("</thead>");
            for (OnmsAlarm onmsAlarm : alarms) {
                OnmsNode onmsNode = null;
                if (onmsAlarm.getNodeId() != null) {
                    CriteriaBuilder nodeCb = new CriteriaBuilder(OnmsNode.class);
                    nodeCb.eq("id", (Object)onmsAlarm.getNodeId());
                    List nodes = this.m_nodeDao.findMatching(nodeCb.toCriteria());
                    if (nodes.size() == 1) {
                        onmsNode = (OnmsNode)nodes.get(0);
                    }
                }
                sb.append("<tr class='alert-details-dashlet " + onmsAlarm.getSeverity().getLabel() + "'>");
                sb.append("<td class='alert-details-dashlet onms-cell divider bright onms' valign='middle' rowspan='1'><nobr>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + onmsAlarm.getId() + "</nobr></td>");
                sb.append("<td class='alert-details-dashlet onms-cell divider onms' valign='middle' rowspan='1'><nobr>" + onmsAlarm.getSeverity().getLabel() + "</nobr></td>");
                sb.append("<td class='alert-details-dashlet onms-cell divider onms' valign='middle' rowspan='1'><nobr>" + (onmsNode != null ? onmsNode.getLabel() : "-") + "</nobr></td>");
                sb.append("<td class='alert-details-dashlet onms-cell divider onms' valign='middle' rowspan='1'><nobr>" + onmsAlarm.getCounter() + "</nobr></td>");
                sb.append("<td class='alert-details-dashlet onms-cell divider onms' valign='middle' rowspan='1'><nobr>" + this.m_timeformatService.format(onmsAlarm.getLastEventTime(), userTimeZone) + "</nobr></td>");
                sb.append("<td class='alert-details-dashlet onms-cell divider onms' valign='middle' rowspan='1'>" + onmsAlarm.getLogMsg().replaceAll("\\<.*?>", "") + "</td>");
                sb.append("</td></tr>");
            }
            sb.append("</table>");
            Label label = new Label(sb.toString());
            label.setSizeFull();
            label.setContentMode(ContentMode.HTML);
            component.addComponent((Component)label);
        }
    }
}

