/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Page;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.features.topology.plugins.browsers.AlarmDaoContainer;
import org.opennms.features.topology.plugins.browsers.AlarmIdColumnLinkGenerator;
import org.opennms.features.topology.plugins.browsers.AlarmTable;
import org.opennms.features.topology.plugins.browsers.AlarmTableCellStyleGenerator;
import org.opennms.features.topology.plugins.browsers.OnmsDaoContainer;
import org.opennms.features.topology.plugins.browsers.SeverityGenerator;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextImpl;

public class AlarmDetailsDashlet
extends AbstractDashlet {
    private AlarmDao m_alarmDao;
    private NodeDao m_nodeDao;
    private CriteriaBuilderHelper m_criteriaBuilderHelper = new CriteriaBuilderHelper(OnmsAlarm.class, new Class[]{OnmsNode.class, OnmsCategory.class, OnmsEvent.class});
    DashletComponent m_wallboardComponent;
    DashletComponent m_dashboardComponent;
    AlarmRepository m_alarmRepository;

    public AlarmDetailsDashlet(String name, DashletSpec dashletSpec, AlarmDao alarmDao, NodeDao nodeDao, AlarmRepository alarmRepository) {
        super(name, dashletSpec);
        this.m_alarmDao = alarmDao;
        this.m_nodeDao = nodeDao;
        this.m_alarmRepository = alarmRepository;
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(AlarmDetailsDashlet.this.getName());
                    this.m_verticalLayout.setWidth("100%");
                    this.refresh();
                }

                private void injectWallboardStyles() {
                    Page.getCurrent().getStyles().add(".alert-details.cleared { background: #AAAAAA; border-left: 14px solid #858585; }");
                    Page.getCurrent().getStyles().add(".alert-details.normal { background: #AAAAAA; border-left: 14px solid #336600; }");
                    Page.getCurrent().getStyles().add(".alert-details.indeterminate { background: #AAAAAA; border-left: 14px solid #999; }");
                    Page.getCurrent().getStyles().add(".alert-details.warning { background: #AAAAAA; border-left: 14px solid #FFCC00; }");
                    Page.getCurrent().getStyles().add(".alert-details.minor { background: #AAAAAA; border-left: 14px solid #FF9900; }");
                    Page.getCurrent().getStyles().add(".alert-details.major { background: #AAAAAA; border-left: 14px solid #FF3300; }");
                    Page.getCurrent().getStyles().add(".alert-details.critical { background: #AAAAAA; border-left: 14px solid #CC0000; }");
                    Page.getCurrent().getStyles().add(".alert-details-font {color: #000000; font-size: 17px; line-height: normal; }");
                    Page.getCurrent().getStyles().add(".alert-details-noalarms-font { font-size: 17px; line-height: normal; }");
                    Page.getCurrent().getStyles().add(".alert-details { padding: 5px 5px; margin: 1px; }");
                }

                public void refresh() {
                    List alarms = AlarmDetailsDashlet.this.getAlarms();
                    this.m_verticalLayout.removeAllComponents();
                    this.injectWallboardStyles();
                    this.setBoosted(false);
                    AlarmDetailsDashlet.this.addComponents((AbstractOrderedLayout)this.m_verticalLayout, alarms);
                    this.setBoosted(AlarmDetailsDashlet.this.checkBoosted(alarms));
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent() {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private AlarmTable m_alarmTable;
                {
                    this.m_alarmTable = new AlarmTable("Alarms", (OnmsDaoContainer)new AlarmDaoContainer(AlarmDetailsDashlet.this.m_alarmDao), AlarmDetailsDashlet.this.m_alarmRepository);
                    this.m_alarmTable.setSizeFull();
                    this.m_alarmTable.setSortEnabled(false);
                    this.m_alarmTable.addHeaderClickListener(new Table.HeaderClickListener(){

                        public void headerClick(Table.HeaderClickEvent headerClickEvent) {
                            m_alarmTable.setSortContainerPropertyId(headerClickEvent.getPropertyId());
                            m_alarmTable.setSortEnabled(true);
                        }
                    });
                    VaadinApplicationContextImpl context = new VaadinApplicationContextImpl();
                    UI currentUI = UI.getCurrent();
                    context.setSessionId(currentUI.getSession().getSession().getId());
                    context.setUiId(currentUI.getUIId());
                    this.m_alarmTable.setVaadinApplicationContext((VaadinApplicationContext)context);
                    EventProxy eventProxy = new EventProxy(){

                        public <T> void fireEvent(T eventObject) {
                            System.out.println("got event: {}" + eventObject);
                        }

                        public <T> void addPossibleEventConsumer(T possibleEventConsumer) {
                            System.out.println("(ignoring) add consumer: {}" + possibleEventConsumer);
                        }
                    };
                    this.m_alarmTable.setEventProxy(eventProxy);
                    this.m_alarmTable.setColumnReorderingAllowed(true);
                    this.m_alarmTable.setColumnCollapsingAllowed(true);
                    this.m_alarmTable.setSortContainerPropertyId((Object)"id");
                    this.m_alarmTable.setSortAscending(false);
                    this.m_alarmTable.setCellStyleGenerator((Table.CellStyleGenerator)new AlarmTableCellStyleGenerator());
                    this.m_alarmTable.addGeneratedColumn((Object)"severity", (Table.ColumnGenerator)new SeverityGenerator());
                    this.m_alarmTable.addGeneratedColumn((Object)"id", (Table.ColumnGenerator)new AlarmIdColumnLinkGenerator(AlarmDetailsDashlet.this.m_alarmDao, "id"));
                    this.m_alarmTable.setVisibleColumns(new Object[]{"id", "severity", "nodeLabel", "counter", "lastEventTime", "logMsg"});
                    this.m_alarmTable.setColumnHeaders(new String[]{"ID", "Severity", "Node", "Count", "Last Event Time", "Log Message"});
                    this.refresh();
                }

                public void refresh() {
                    List alarms = AlarmDetailsDashlet.this.getAlarms();
                    LinkedList<Integer> alarmIds = new LinkedList<Integer>();
                    if (alarms.size() > 0) {
                        for (OnmsAlarm onmsAlarm : alarms) {
                            alarmIds.add(onmsAlarm.getId());
                        }
                    } else {
                        alarmIds.add(0);
                    }
                    LinkedList<InRestriction> restrictions = new LinkedList<InRestriction>();
                    restrictions.add(new InRestriction("id", alarmIds));
                    ((OnmsDaoContainer)this.m_alarmTable.getContainerDataSource()).setRestrictions(restrictions);
                    this.setBoosted(AlarmDetailsDashlet.this.checkBoosted(alarms));
                    this.m_alarmTable.markAsDirtyRecursive();
                }

                public Component getComponent() {
                    return this.m_alarmTable;
                }
            };
        }
        return this.m_dashboardComponent;
    }

    private boolean checkBoosted(List<OnmsAlarm> alarms) {
        for (OnmsAlarm onmsAlarm : alarms) {
            OnmsSeverity boostSeverity = OnmsSeverity.valueOf((String)((String)this.getDashletSpec().getParameters().get("boostSeverity")));
            if (!onmsAlarm.getSeverity().isGreaterThanOrEqual(boostSeverity)) continue;
            return true;
        }
        return false;
    }

    private List<OnmsAlarm> getAlarms() {
        CriteriaBuilder alarmCb = new CriteriaBuilder(OnmsAlarm.class);
        alarmCb.alias("node", "node");
        alarmCb.alias("node.categories", "category");
        alarmCb.alias("lastEvent", "event");
        String criteria = (String)this.getDashletSpec().getParameters().get("criteria");
        this.m_criteriaBuilderHelper.parseConfiguration(alarmCb, criteria);
        alarmCb.fetch("firstEvent", Fetch.FetchType.EAGER);
        alarmCb.fetch("lastEvent", Fetch.FetchType.EAGER);
        alarmCb.distinct();
        return this.m_alarmDao.findMatching(alarmCb.toCriteria());
    }

    private void addComponents(AbstractOrderedLayout component, List<OnmsAlarm> alarms) {
        if (alarms.size() == 0) {
            Label label = new Label("No alarms found!");
            label.addStyleName("alert-details-noalarms-font");
            component.addComponent((Component)label);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<table class='onms'>");
            sb.append("<thead>");
            sb.append("<th class='onms'>ID</th><th class='onms'>Severity</th><th class='onms'>Node</th><th class='onms'>Count</th><th class='onms'>Last Event Time</th><th class='onms'>Log Msg</th>");
            sb.append("</thead>");
            for (OnmsAlarm onmsAlarm : alarms) {
                OnmsNode onmsNode = null;
                if (onmsAlarm.getNodeId() != null) {
                    CriteriaBuilder nodeCb = new CriteriaBuilder(OnmsNode.class);
                    nodeCb.eq("id", (Object)onmsAlarm.getNodeId());
                    List nodes = this.m_nodeDao.findMatching(nodeCb.toCriteria());
                    if (nodes.size() == 1) {
                        onmsNode = (OnmsNode)nodes.get(0);
                    }
                }
                String s = "";
                sb.append("<tr class='" + onmsAlarm.getSeverity().getLabel() + " onms'>");
                sb.append("<td class='divider bright onms' valign='middle' rowspan='1'><nobr>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + onmsAlarm.getId() + "</nobr></td>");
                sb.append("<td class='divider onms' valign='middle' rowspan='1'><nobr>" + onmsAlarm.getSeverity().getLabel() + "</nobr></td>");
                sb.append("<td class='divider onms' valign='middle' rowspan='1'><nobr>" + (onmsNode != null ? onmsNode.getLabel() : "-") + "</nobr></td>");
                sb.append("<td class='divider onms' valign='middle' rowspan='1'><nobr>" + onmsAlarm.getCounter() + "</nobr></td>");
                sb.append("<td class='divider onms' valign='middle' rowspan='1'><nobr>" + onmsAlarm.getLastEventTime().toString() + "</nobr></td>");
                sb.append("<td class='divider onms' valign='middle' rowspan='1'>" + onmsAlarm.getLogMsg().replaceAll("\\<.*?>", "") + "</td>");
                sb.append("</td></tr>");
            }
            sb.append("</table>");
            Label label = new Label(sb.toString());
            label.setSizeFull();
            label.setContentMode(ContentMode.HTML);
            component.addComponent((Component)label);
        }
    }

    @Deprecated
    public Component createAlarmComponent(OnmsAlarm onmsAlarm, OnmsNode onmsNode) {
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setSizeFull();
        horizontalLayout.addStyleName("alert-details");
        horizontalLayout.addStyleName("alert-details-font");
        horizontalLayout.addStyleName(onmsAlarm.getSeverity().name().toLowerCase());
        VerticalLayout verticalLayout1 = new VerticalLayout();
        VerticalLayout verticalLayout2 = new VerticalLayout();
        horizontalLayout.addComponent((Component)verticalLayout1);
        horizontalLayout.addComponent((Component)verticalLayout2);
        Label lastEvent = new Label();
        lastEvent.setSizeUndefined();
        lastEvent.addStyleName("alert-details-font");
        lastEvent.setCaption("Last event");
        lastEvent.setValue(onmsAlarm.getLastEventTime().toString());
        Label firstEvent = new Label();
        firstEvent.setSizeUndefined();
        firstEvent.addStyleName("alert-details-font");
        firstEvent.setCaption("First event");
        firstEvent.setValue(onmsAlarm.getFirstEventTime().toString());
        verticalLayout1.addComponent((Component)firstEvent);
        verticalLayout1.addComponent((Component)lastEvent);
        Label nodeId = new Label();
        nodeId.setSizeUndefined();
        nodeId.addStyleName("alert-details-font");
        nodeId.setCaption("Node Id");
        if (onmsNode != null) {
            nodeId.setValue(onmsNode.getNodeId());
        } else {
            nodeId.setValue("-");
        }
        Label nodeLabel = new Label();
        nodeLabel.setSizeUndefined();
        nodeLabel.addStyleName("alert-details-font");
        nodeLabel.setCaption("Node Label");
        if (onmsNode != null) {
            nodeLabel.setValue(onmsNode.getLabel());
        } else {
            nodeLabel.setValue("-");
        }
        Label logMessage = new Label();
        logMessage.addStyleName("alert-details-font");
        logMessage.setSizeFull();
        logMessage.setCaption("Log message");
        logMessage.setValue(onmsAlarm.getLogMsg().replaceAll("<[^>]*>", ""));
        HorizontalLayout horizontalLayout2 = new HorizontalLayout();
        horizontalLayout2.setSizeFull();
        horizontalLayout2.setSpacing(true);
        horizontalLayout2.addComponent((Component)nodeId);
        horizontalLayout2.addComponent((Component)nodeLabel);
        verticalLayout2.addComponent((Component)horizontalLayout2);
        verticalLayout2.addComponent((Component)logMessage);
        horizontalLayout.setExpandRatio((Component)verticalLayout1, 1.0f);
        horizontalLayout.setExpandRatio((Component)verticalLayout2, 4.0f);
        return horizontalLayout;
    }
}

