/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.ui;

import com.vaadin.data.Property;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.UI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.opennms.features.vaadin.dashboard.ui.dashboard.DashboardView;
import org.opennms.features.vaadin.dashboard.ui.wallboard.WallboardView;

public class HeaderLayout
extends HorizontalLayout
implements ViewChangeListener {
    private View m_wallboardView = null;
    private Button m_pauseButton;
    private Button m_wallboardButton;
    private Button m_dashboardButton;
    private NativeSelect m_nativeSelect;

    public HeaderLayout() {
        this.addStyleName("header");
        this.setMargin(new MarginInfo(false, true, false, false));
        this.setSpacing(true);
        this.setWidth("100%");
        this.setHeight(64.0f, Sizeable.Unit.PIXELS);
        Label link = new Label();
        link.setContentMode(ContentMode.HTML);
        link.setValue("<a href=\"/opennms/index.jsp\" id=\"onmslogo\"></a>");
        this.addComponent((Component)link);
        this.setExpandRatio((Component)link, 1.0f);
        this.m_nativeSelect = new NativeSelect();
        this.m_nativeSelect.setDescription("Select Ops Board configuration");
        this.m_nativeSelect.setContainerDataSource(WallboardProvider.getInstance().getBeanContainer());
        this.m_nativeSelect.setItemCaptionPropertyId((Object)"title");
        this.m_nativeSelect.setNullSelectionAllowed(false);
        this.m_nativeSelect.setImmediate(true);
        this.m_nativeSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                HeaderLayout.this.m_wallboardButton.setEnabled(true);
                HeaderLayout.this.m_dashboardButton.setEnabled(true);
            }
        });
        this.m_dashboardButton = new Button("Ops Panel", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                UI.getCurrent().getNavigator().addViewChangeListener((ViewChangeListener)HeaderLayout.this);
                UI.getCurrent().getNavigator().navigateTo("dashboard/" + HeaderLayout.this.m_nativeSelect.getContainerProperty(HeaderLayout.this.m_nativeSelect.getValue(), (Object)"title"));
            }
        });
        this.m_dashboardButton.setDescription("Ops Panel view");
        this.m_pauseButton = new Button("Pause", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (HeaderLayout.this.m_wallboardView instanceof WallboardView) {
                    if (((WallboardView)HeaderLayout.this.m_wallboardView).isPaused()) {
                        ((WallboardView)HeaderLayout.this.m_wallboardView).resume();
                    } else {
                        ((WallboardView)HeaderLayout.this.m_wallboardView).pause();
                    }
                } else if (HeaderLayout.this.m_wallboardView instanceof DashboardView) {
                    ((DashboardView)HeaderLayout.this.m_wallboardView).updateAll();
                }
                HeaderLayout.this.updatePauseButton();
            }
        });
        this.m_wallboardButton = new Button("Ops Board", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                UI.getCurrent().getNavigator().addViewChangeListener((ViewChangeListener)HeaderLayout.this);
                UI.getCurrent().getNavigator().navigateTo("wallboard/" + HeaderLayout.this.m_nativeSelect.getContainerProperty(HeaderLayout.this.m_nativeSelect.getValue(), (Object)"title"));
            }
        });
        this.m_wallboardButton.setDescription("Ops Board view");
        this.m_pauseButton.setEnabled(false);
        this.m_wallboardButton.setEnabled(false);
        this.m_dashboardButton.setEnabled(false);
        this.addComponents(new Component[]{this.m_nativeSelect, this.m_dashboardButton, this.m_wallboardButton, this.m_pauseButton});
        this.setComponentAlignment((Component)this.m_nativeSelect, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.m_dashboardButton, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.m_wallboardButton, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.m_pauseButton, Alignment.MIDDLE_CENTER);
    }

    public void gotoWallboard(Wallboard wallboard) {
        this.m_nativeSelect.setValue((Object)wallboard);
        UI.getCurrent().getNavigator().navigateTo("wallboard/" + wallboard.getTitle());
    }

    private void updatePauseButton() {
        if (this.m_wallboardView instanceof WallboardView) {
            if (((WallboardView)this.m_wallboardView).isPausable()) {
                this.m_pauseButton.setEnabled(true);
                if (((WallboardView)this.m_wallboardView).isPaused()) {
                    this.m_pauseButton.setCaption("Resume");
                    this.m_pauseButton.setDescription("Resume the execution of the Ops Board");
                } else {
                    this.m_pauseButton.setCaption("Pause");
                    this.m_pauseButton.setDescription("Pause the execution of the Ops Board");
                }
            } else {
                this.m_pauseButton.setEnabled(false);
                this.m_pauseButton.setCaption("Pause");
                this.m_pauseButton.setDescription("Pause the execution of the Ops Board");
            }
        } else if (this.m_wallboardView instanceof DashboardView) {
            this.m_pauseButton.setCaption("Refresh");
            this.m_pauseButton.setDescription("Refresh");
            this.m_pauseButton.setEnabled(true);
        } else {
            this.m_pauseButton.setCaption("Pause");
            this.m_pauseButton.setDescription("Pause the execution of the Ops Board");
            this.m_pauseButton.setEnabled(false);
        }
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
        return true;
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
        this.m_wallboardView = viewChangeEvent.getNewView();
        this.updatePauseButton();
    }
}

