/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.AbstractStringValidator;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.Window;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.config.ui.PreviewClickListener;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardEditor;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.slf4j.LoggerFactory;

public class DashletSpecEditor
extends Panel {
    private DashletSpec m_dashletSpec;
    private WallboardEditor m_wallboardEditor;
    private NativeSelect m_dashletSelect;
    private TextField m_titleField;
    private boolean m_savingDisabled = false;
    private DashletSelector m_dashletSelector;
    private Button m_propertiesButton;

    public DashletSpecEditor(WallboardEditor wallboardEditor, DashletSelector dashletSelector, DashletSpec dashletSpec) {
        this.m_wallboardEditor = wallboardEditor;
        this.m_dashletSpec = dashletSpec;
        this.m_dashletSelector = dashletSelector;
        DashletFactory dashletFactory = dashletSelector.getDashletFactoryForName(dashletSpec.getDashletName());
        Map<String, String> requiredParameters = dashletFactory.getRequiredParameters();
        for (Map.Entry<String, String> entry : requiredParameters.entrySet()) {
            if (dashletSpec.getParameters().containsKey(entry.getKey())) continue;
            dashletSpec.getParameters().put(entry.getKey(), requiredParameters.get(entry.getKey()));
        }
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(6);
        gridLayout.setRows(1);
        gridLayout.setMargin(true);
        final TextField priorityField = new TextField();
        priorityField.setValue(String.valueOf(dashletSpec.getPriority()));
        priorityField.setImmediate(true);
        priorityField.setCaption("Priority");
        priorityField.setDescription("Priority of this dashlet");
        priorityField.addValidator((Validator)new AbstractStringValidator("Only numbers allowed here"){

            protected boolean isValidValue(String s) {
                try {
                    Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
        });
        priorityField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (priorityField.isValid()) {
                    DashletSpecEditor.this.m_dashletSpec.setPriority(Integer.valueOf((String)valueChangeEvent.getProperty().getValue()));
                    WallboardProvider.getInstance().save();
                    ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Priority");
                }
            }
        });
        final TextField boostPriorityField = new TextField();
        boostPriorityField.setValue(String.valueOf(dashletSpec.getBoostPriority()));
        boostPriorityField.setImmediate(true);
        boostPriorityField.setCaption("Boost-Priority");
        boostPriorityField.setDescription("Boost priority of this dashlet");
        boostPriorityField.addValidator((Validator)new AbstractStringValidator("Only numbers allowed here"){

            protected boolean isValidValue(String s) {
                try {
                    Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
        });
        boostPriorityField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (boostPriorityField.isValid()) {
                    DashletSpecEditor.this.m_dashletSpec.setBoostPriority(Integer.valueOf((String)valueChangeEvent.getProperty().getValue()));
                    WallboardProvider.getInstance().save();
                    ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Priority");
                }
            }
        });
        final TextField durationField = new TextField();
        durationField.setValue(String.valueOf(dashletSpec.getDuration()));
        durationField.setImmediate(true);
        durationField.setCaption("Duration");
        durationField.setDescription("Duration for this dashlet");
        durationField.addValidator((Validator)new AbstractStringValidator("Only numbers allowed here"){

            protected boolean isValidValue(String s) {
                try {
                    Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
        });
        durationField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (durationField.isValid()) {
                    DashletSpecEditor.this.m_dashletSpec.setDuration(Integer.valueOf((String)valueChangeEvent.getProperty().getValue()));
                    WallboardProvider.getInstance().save();
                    ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Duration");
                }
            }
        });
        final TextField boostDurationField = new TextField();
        boostDurationField.setValue(String.valueOf(dashletSpec.getBoostDuration()));
        boostDurationField.setImmediate(true);
        boostDurationField.setCaption("Boost-Duration");
        boostDurationField.setDescription("Boost duration for this dashlet");
        boostDurationField.addValidator((Validator)new AbstractStringValidator("Only numbers allowed here"){

            protected boolean isValidValue(String s) {
                try {
                    Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
        });
        boostDurationField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (boostDurationField.isValid()) {
                    DashletSpecEditor.this.m_dashletSpec.setBoostDuration(Integer.valueOf((String)valueChangeEvent.getProperty().getValue()));
                    WallboardProvider.getInstance().save();
                    ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Duration");
                }
            }
        });
        boolean boostable = this.m_dashletSelector.getDashletFactoryForName(this.m_dashletSpec.getDashletName()).isBoostable();
        boostPriorityField.setEnabled(boostable);
        boostDurationField.setEnabled(boostable);
        this.m_dashletSelect = new NativeSelect();
        this.m_dashletSelect.setCaption("Dashlet");
        this.updateDashletSelection(dashletSelector.getDashletFactoryList());
        this.m_dashletSelect.setImmediate(true);
        this.m_dashletSelect.setNewItemsAllowed(false);
        this.m_dashletSelect.setNullSelectionItemId((Object)"Undefined");
        this.m_dashletSelect.setNullSelectionAllowed(false);
        this.m_dashletSelect.select((Object)dashletSpec.getDashletName());
        this.m_dashletSelect.setDescription("Dashlet selection");
        this.m_dashletSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (DashletSpecEditor.this.m_savingDisabled) {
                    return;
                }
                if (valueChangeEvent.getProperty().getValue() == null) {
                    DashletSpecEditor.this.m_dashletSpec.setDashletName("Undefined");
                } else {
                    DashletSpecEditor.this.m_dashletSpec.setDashletName(valueChangeEvent.getProperty().getValue().toString());
                    DashletSpecEditor.this.m_dashletSelect.removeItem((Object)"Undefined");
                }
                DashletSpecEditor.this.m_dashletSpec.getParameters().clear();
                Map<String, String> requiredParameters = DashletSpecEditor.this.m_dashletSelector.getDashletFactoryForName(DashletSpecEditor.this.m_dashletSpec.getDashletName()).getRequiredParameters();
                for (Map.Entry<String, String> entry : requiredParameters.entrySet()) {
                    DashletSpecEditor.this.m_dashletSpec.getParameters().put(entry.getKey(), entry.getValue());
                }
                DashletSpecEditor.this.m_propertiesButton.setEnabled(requiredParameters.size() > 0);
                boolean boostable = DashletSpecEditor.this.m_dashletSelector.getDashletFactoryForName(DashletSpecEditor.this.m_dashletSpec.getDashletName()).isBoostable();
                boostPriorityField.setEnabled(boostable);
                boostDurationField.setEnabled(boostable);
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Dashlet");
            }
        });
        this.m_titleField = new TextField();
        this.m_titleField.setValue(dashletSpec.getTitle());
        this.m_titleField.setImmediate(true);
        this.m_titleField.setCaption("Title");
        this.m_titleField.setDescription("Title for this dashlet instance");
        this.m_titleField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                DashletSpecEditor.this.m_dashletSpec.setTitle((String)valueChangeEvent.getProperty().getValue());
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)DashletSpecEditor.this.getUI()).notifyMessage("Data saved", "Title");
            }
        });
        FormLayout f1 = new FormLayout();
        f1.addComponent((Component)this.m_dashletSelect);
        f1.addComponent((Component)this.m_titleField);
        FormLayout f2 = new FormLayout();
        f2.addComponent((Component)priorityField);
        f2.addComponent((Component)durationField);
        FormLayout f3 = new FormLayout();
        f3.addComponent((Component)boostPriorityField);
        f3.addComponent((Component)boostDurationField);
        this.m_propertiesButton = new Button("Properties");
        this.m_propertiesButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                DashletConfigurationWindow configurationWindow = DashletSpecEditor.this.m_dashletSelector.getDashletFactoryForName(DashletSpecEditor.this.m_dashletSpec.getDashletName()).configurationWindow(DashletSpecEditor.this.m_dashletSpec);
                DashletSpecEditor.this.getUI().addWindow((Window)configurationWindow);
            }
        });
        this.m_propertiesButton.setEnabled(this.m_dashletSelector.getDashletFactoryForName(this.m_dashletSpec.getDashletName()).getRequiredParameters().size() > 0);
        this.m_propertiesButton.setStyleName("small");
        this.m_propertiesButton.setDescription("Open properties dialog for this dashlet");
        Button removeButton = new Button("Remove");
        removeButton.setDescription("Remove this dashlet entry");
        FormLayout f4 = new FormLayout();
        f4.addComponent((Component)this.m_propertiesButton);
        f4.addComponent((Component)removeButton);
        removeButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                DashletSpecEditor.this.m_wallboardEditor.removeDashletSpecEditor(DashletSpecEditor.this);
            }
        });
        removeButton.setStyleName("small");
        Button upButton = new Button();
        upButton.setStyleName("small");
        upButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-up.png"));
        upButton.setDescription("Move this a dashlet entry one position up");
        Button downButton = new Button();
        downButton.setStyleName("small");
        downButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-down.png"));
        downButton.setDescription("Move this a dashlet entry one position down");
        FormLayout f5 = new FormLayout();
        f5.addComponent((Component)upButton);
        f5.addComponent((Component)downButton);
        Button previewButton = new Button("Preview");
        previewButton.setStyleName("small");
        previewButton.setDescription("Preview this single dashlet entry");
        Wallboard wallboard = new Wallboard();
        wallboard.getDashletSpecs().add(this.m_dashletSpec);
        previewButton.addClickListener((Button.ClickListener)new PreviewClickListener((Component)this, wallboard));
        FormLayout f6 = new FormLayout();
        f6.addComponent((Component)previewButton);
        upButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                DashletSpecEditor.this.m_wallboardEditor.swapDashletSpec(DashletSpecEditor.this.m_dashletSpec, -1);
            }
        });
        downButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                DashletSpecEditor.this.m_wallboardEditor.swapDashletSpec(DashletSpecEditor.this.m_dashletSpec, 1);
            }
        });
        f1.setMargin(true);
        f2.setMargin(true);
        f3.setMargin(true);
        f4.setMargin(true);
        f5.setMargin(true);
        f6.setMargin(true);
        gridLayout.addComponent((Component)f1);
        gridLayout.addComponent((Component)f2);
        gridLayout.addComponent((Component)f3);
        gridLayout.addComponent((Component)f4);
        gridLayout.addComponent((Component)f5);
        gridLayout.addComponent((Component)f6);
        this.setContent((Component)gridLayout);
    }

    public void updateDashletSelection(List<DashletFactory> factoryList) {
        String savedSelection;
        this.m_savingDisabled = true;
        String string = savedSelection = this.m_dashletSelect.getValue() == null ? "Undefined" : this.m_dashletSelect.getValue().toString();
        if (!this.m_dashletSelect.removeAllItems()) {
            LoggerFactory.getLogger(DashletSpecEditor.class).warn("problem removing items");
        }
        for (DashletFactory dashletFactory : factoryList) {
            if ("Undefined".equals(dashletFactory.getName())) continue;
            this.m_dashletSelect.addItem((Object)dashletFactory.getName());
        }
        this.m_dashletSelect.select((Object)savedSelection);
        this.m_savingDisabled = false;
    }

    public DashletSpec getDashletSpec() {
        return this.m_dashletSpec;
    }
}

