/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.ui.wallboard;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressIndicator;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.model.Dashlet;
import org.opennms.features.vaadin.dashboard.model.DashletSelectorAccess;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class WallboardBody
extends VerticalLayout {
    private final CssLayout contentLayout;
    private List<DashletSpec> dashletSpecs = new LinkedList<DashletSpec>();
    private Map<Integer, Dashlet> dashlets = new HashMap<Integer, Dashlet>();
    private Map<Integer, Integer> priorityMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> durationMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> oldDurationMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> oldPriorityMap = new HashMap<Integer, Integer>();
    private Timer timer;
    private int waitFor = 0;
    private int iteration = 1;
    private int index = -1;
    private static final int PRIORITY_DECREASE = 1;
    private static final int DURATION_DECREASE = 1;
    private ProgressIndicator progressIndicator;
    private Label debugLabel = new Label("debug");
    private boolean debugEnabled = false;
    private boolean paused = false;

    public WallboardBody() {
        this.addStyleName("wallboard-board");
        this.setSizeFull();
        this.contentLayout = new CssLayout();
        this.contentLayout.setSizeFull();
        this.contentLayout.addComponent((Component)new Label("Nothing to display"));
        if (this.debugEnabled) {
            this.addComponent((Component)this.debugLabel);
        }
        this.addComponent((Component)this.contentLayout);
        this.setExpandRatio((Component)this.contentLayout, 1.0f);
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setWidth("100%");
        this.progressIndicator.setPollingInterval(250);
        this.progressIndicator.setVisible(false);
        this.addComponent((Component)this.progressIndicator);
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                UI ui = WallboardBody.this.getUI();
                if (ui != null) {
                    ui.accessSynchronously(new Runnable(){

                        @Override
                        public void run() {
                            WallboardBody.this.advanceTimer();
                        }
                    });
                }
            }
        }, 250L, 250L);
        this.addDetachListener(new ClientConnector.DetachListener(){

            public void detach(ClientConnector.DetachEvent detachEvent) {
                WallboardBody.this.timer.cancel();
            }
        });
    }

    public void setDashletSpecs(List<DashletSpec> dashletSpecs) {
        this.dashletSpecs = dashletSpecs;
        this.dashlets = new HashMap<Integer, Dashlet>();
        this.priorityMap = new HashMap<Integer, Integer>();
        this.durationMap = new HashMap<Integer, Integer>();
        this.oldDurationMap = new HashMap<Integer, Integer>();
        this.oldPriorityMap = new HashMap<Integer, Integer>();
        this.waitFor = 0;
        this.iteration = 1;
        this.index = -1;
        VaadinSession.getCurrent().lock();
        try {
            this.progressIndicator.setVisible(true);
        }
        finally {
            VaadinSession.getCurrent().unlock();
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPausable() {
        return this.dashletSpecs.size() > 0;
    }

    public Dashlet getDashletInstance(DashletSpec dashletSpec) {
        DashletSelector dashletSelector = ((DashletSelectorAccess)this.getUI()).getDashletSelector();
        Dashlet dashlet = dashletSelector.getDashletFactoryForName(dashletSpec.getDashletName()).newDashletInstance(dashletSpec);
        dashlet.getWallboardComponent().getComponent().setCaption(null);
        return dashlet;
    }

    private void debug() {
        if (!this.debugEnabled) {
            return;
        }
        String debug = "#" + this.iteration + ", i=" + this.index + ", w=" + this.waitFor;
        this.debugLabel.setValue(debug);
    }

    private int next() {
        if (this.dashletSpecs.size() == 0) {
            return -1;
        }
        int oldIndex = this.index;
        while (true) {
            ++this.index;
            if (this.index >= this.dashletSpecs.size()) {
                ++this.iteration;
                this.index = 0;
            }
            if (this.index == oldIndex && this.dashletSpecs.size() > 1) {
                int minValue = Integer.MAX_VALUE;
                int maxIndex = -1;
                for (Map.Entry<Integer, Integer> entry : this.priorityMap.entrySet()) {
                    if (entry.getKey() == oldIndex || entry.getValue() >= minValue) continue;
                    minValue = entry.getValue();
                    maxIndex = entry.getKey();
                }
                if (maxIndex != -1) {
                    this.index = maxIndex;
                    this.priorityMap.put(this.index, 0);
                }
            }
            if (!this.priorityMap.containsKey(this.index)) {
                Dashlet dashlet = this.getDashletInstance(this.dashletSpecs.get(this.index));
                dashlet.getWallboardComponent().getComponent().addStyleName("wallboard");
                this.dashlets.put(this.index, dashlet);
                this.dashlets.get(this.index).getWallboardComponent().refresh();
                if (this.dashlets.get(this.index).isBoosted()) {
                    this.priorityMap.put(this.index, Math.max(0, this.dashletSpecs.get(this.index).getPriority() - this.dashletSpecs.get(this.index).getBoostPriority()));
                    this.durationMap.put(this.index, this.dashletSpecs.get(this.index).getDuration() + this.dashletSpecs.get(this.index).getBoostDuration());
                } else {
                    this.priorityMap.put(this.index, this.dashletSpecs.get(this.index).getPriority());
                    this.durationMap.put(this.index, this.dashletSpecs.get(this.index).getDuration());
                }
                this.oldPriorityMap.put(this.index, this.priorityMap.get(this.index));
                this.oldDurationMap.put(this.index, this.durationMap.get(this.index));
            }
            if (this.priorityMap.get(this.index) <= 0) {
                this.dashlets.get(this.index).getWallboardComponent().refresh();
                if (this.dashlets.get(this.index).isBoosted()) {
                    this.priorityMap.put(this.index, Math.max(0, this.dashletSpecs.get(this.index).getPriority() - this.dashletSpecs.get(this.index).getBoostPriority()));
                    this.durationMap.put(this.index, this.dashletSpecs.get(this.index).getDuration() + this.dashletSpecs.get(this.index).getBoostDuration());
                } else {
                    this.priorityMap.put(this.index, Math.min(this.oldPriorityMap.get(this.index) + 1, this.dashletSpecs.get(this.index).getPriority()));
                    this.durationMap.put(this.index, Math.max(this.oldDurationMap.get(this.index) - 1, this.dashletSpecs.get(this.index).getDuration()));
                }
                this.oldPriorityMap.put(this.index, this.priorityMap.get(this.index));
                this.oldDurationMap.put(this.index, this.durationMap.get(this.index));
                return this.index;
            }
            this.priorityMap.put(this.index, this.priorityMap.get(this.index) - 1);
        }
    }

    private void advanceTimer() {
        if (this.paused) {
            return;
        }
        int n = this.waitFor = this.waitFor > 250 ? this.waitFor - 250 : 0;
        if (this.dashletSpecs.size() > 0) {
            if (this.waitFor <= 0) {
                int next = this.next();
                this.contentLayout.removeAllComponents();
                if (next != -1) {
                    this.waitFor = this.oldDurationMap.get(next) * 1000;
                    if (!this.dashlets.get(next).getName().equals(this.dashletSpecs.get(next).getDashletName())) {
                        this.dashlets.put(next, this.getDashletInstance(this.dashletSpecs.get(next)));
                    }
                    Panel panel = new Panel();
                    panel.setSizeFull();
                    String caption = this.dashlets.get(next).getName();
                    if (this.dashlets.get(next).getDashletSpec().getTitle() != null && !"".equals(this.dashlets.get(next).getDashletSpec().getTitle())) {
                        caption = caption + ": " + this.dashlets.get(next).getDashletSpec().getTitle();
                    }
                    panel.setCaption(caption);
                    Component component = this.dashlets.get(next).getWallboardComponent().getComponent();
                    VerticalLayout verticalLayout = new VerticalLayout(new Component[]{component});
                    verticalLayout.setSizeFull();
                    verticalLayout.setMargin(true);
                    panel.setContent((Component)verticalLayout);
                    this.contentLayout.addComponent((Component)panel);
                    if (!this.progressIndicator.isVisible()) {
                        this.progressIndicator.setVisible(true);
                    }
                } else {
                    this.contentLayout.addComponent((Component)new Label("Nothing to display"));
                    this.progressIndicator.setVisible(false);
                }
            }
        } else {
            this.contentLayout.removeAllComponents();
            this.contentLayout.addComponent((Component)new Label("Nothing to display"));
            this.progressIndicator.setVisible(false);
        }
        if (this.durationMap.containsKey(this.index)) {
            float x = 1.0f - (float)this.waitFor / (float)(this.durationMap.get(this.index) * 1000);
            this.progressIndicator.setValue(Float.valueOf(x));
        }
        this.debug();
    }
}

