/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui.editors;

import com.vaadin.data.Property;
import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.NativeSelect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaEntry;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaRestriction;

public class CriteriaRestrictionComponent
extends HorizontalLayout {
    private final NativeSelect m_restrictionSelect;
    private final List<AbstractField<?>> m_componentList = new ArrayList();
    private HorizontalLayout m_leftLayout;
    private HorizontalLayout m_rightLayout;
    private CriteriaBuilderHelper m_criteriaBuilderHelper;

    public CriteriaRestrictionComponent(CriteriaBuilderHelper criteriaBuilderHelper, String restriction) {
        this.m_criteriaBuilderHelper = criteriaBuilderHelper;
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.m_rightLayout = new HorizontalLayout();
        this.m_leftLayout = new HorizontalLayout();
        this.setSpacing(true);
        this.setMargin(true);
        Page.getCurrent().getStyles().add(".criteriaBackground { background:#dddddd; }");
        this.addStyleName("criteriaBackground");
        this.m_restrictionSelect = new NativeSelect();
        this.m_restrictionSelect.setCaption("Restriction");
        this.m_restrictionSelect.setNullSelectionAllowed(false);
        this.m_restrictionSelect.setMultiSelect(false);
        this.m_restrictionSelect.setNewItemsAllowed(false);
        this.m_restrictionSelect.setImmediate(true);
        this.m_restrictionSelect.setDescription("Restriction selection");
        for (CriteriaRestriction criteriaRestriction : CriteriaRestriction.values()) {
            this.m_restrictionSelect.addItem((Object)criteriaRestriction.name());
        }
        String[] arr = restriction.split("[(),]+");
        CriteriaRestriction criteriaRestriction = CriteriaRestriction.valueOf(arr[0]);
        this.m_restrictionSelect.select((Object)criteriaRestriction.toString());
        this.m_restrictionSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                CriteriaRestriction newCriteriaRestriction = CriteriaRestriction.valueOf(String.valueOf(valueChangeEvent.getProperty().getValue()));
                CriteriaRestrictionComponent.this.refreshComponents(newCriteriaRestriction);
            }
        });
        this.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        this.m_leftLayout.addComponent((Component)this.m_restrictionSelect);
        this.m_leftLayout.setSpacing(true);
        this.refreshComponents(criteriaRestriction, Arrays.copyOfRange(arr, 1, arr.length));
        this.addComponent((Component)this.m_leftLayout);
        this.addComponent((Component)this.m_rightLayout);
        this.setExpandRatio((Component)this.m_leftLayout, 3.0f);
        this.setExpandRatio((Component)this.m_rightLayout, 1.0f);
        this.setComponentAlignment((Component)this.m_leftLayout, Alignment.MIDDLE_LEFT);
        this.setComponentAlignment((Component)this.m_rightLayout, Alignment.MIDDLE_RIGHT);
    }

    public HorizontalLayout getRightLayout() {
        return this.m_rightLayout;
    }

    private void refreshComponents(CriteriaRestriction criteriaRestriction) {
        this.refreshComponents(criteriaRestriction, null);
    }

    private void refreshComponents(CriteriaRestriction criteriaRestriction, String[] arr) {
        for (AbstractComponent abstractComponent : this.m_componentList) {
            this.m_leftLayout.removeComponent((Component)abstractComponent);
        }
        this.m_componentList.clear();
        int i = 0;
        for (CriteriaEntry criteriaEntry : criteriaRestriction.getEntries()) {
            AbstractField<?> abstractField = criteriaEntry.getComponent(this.m_criteriaBuilderHelper);
            if (arr != null && arr.length > i) {
                abstractField.setValue((Object)CriteriaBuilderHelper.decode(arr[i]));
            }
            this.m_leftLayout.addComponent(abstractField);
            this.m_componentList.add(abstractField);
            ++i;
        }
    }

    public String getRestriction() {
        CriteriaRestriction criteriaRestriction = CriteriaRestriction.valueOf(String.valueOf(this.m_restrictionSelect.getValue()));
        String criteria = criteriaRestriction.name() + "(";
        boolean first = true;
        for (AbstractField<?> abstractField : this.m_componentList) {
            if (!first) {
                criteria = criteria + ",";
            }
            criteria = criteria + CriteriaBuilderHelper.encode(abstractField.getValue().toString());
            first = false;
        }
        criteria = criteria + ")";
        return criteria;
    }
}

