/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.data.Container;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.VerticalLayout;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class PropertiesWindow
extends DashletConfigurationWindow {
    public PropertiesWindow(final DashletSpec dashletSpec, DashletFactory dashletFactory) {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setMargin(true);
        verticalLayout.setSizeFull();
        verticalLayout.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        final Table table = new Table();
        table.setTableFieldFactory((TableFieldFactory)new DefaultFieldFactory(){

            public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
                Field field = super.createField(container, itemId, propertyId, uiContext);
                if (propertyId.equals("Key")) {
                    field.setReadOnly(true);
                } else {
                    field.setSizeFull();
                }
                return field;
            }
        });
        table.setEditable(true);
        table.setSizeFull();
        table.setImmediate(true);
        table.addContainerProperty((Object)"Key", String.class, (Object)"");
        table.addContainerProperty((Object)"Value", String.class, (Object)"");
        final Map<String, String> requiredParameters = dashletFactory.getRequiredParameters();
        for (Map.Entry<String, String> entry : requiredParameters.entrySet()) {
            table.addItem(new Object[]{entry.getKey(), dashletSpec.getParameters().get(entry.getKey())}, (Object)entry.getKey());
        }
        table.setColumnWidth((Object)"Key", 100);
        table.setColumnWidth((Object)"Value", -1);
        table.setSizeFull();
        verticalLayout.addComponent((Component)table);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing properties");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                PropertiesWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        horizontalLayout.addComponent((Component)cancel);
        horizontalLayout.setExpandRatio((Component)cancel, 1.0f);
        horizontalLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                for (Map.Entry entry : requiredParameters.entrySet()) {
                    String newValue = table.getItem(entry.getKey()).getItemProperty((Object)"Value").getValue().toString();
                    dashletSpec.getParameters().put((String)entry.getKey(), newValue);
                }
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)PropertiesWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                PropertiesWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        horizontalLayout.addComponent((Component)ok);
        verticalLayout.addComponent((Component)horizontalLayout);
        verticalLayout.setExpandRatio((Component)table, 1.0f);
        this.setContent((Component)verticalLayout);
    }
}

