/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui.editors;

import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaRestrictionComponent;

public class CriteriaBuilderComponent
extends Panel {
    private List<CriteriaRestrictionComponent> m_criteriaRestrictionComponents = new ArrayList<CriteriaRestrictionComponent>();
    private CriteriaBuilderHelper m_criteriaBuilderHelper;
    private final VerticalLayout m_criteriaLayout = new VerticalLayout();

    public CriteriaBuilderComponent(CriteriaBuilderHelper criteriaBuilderHelper, String criteriaString) {
        this.m_criteriaBuilderHelper = criteriaBuilderHelper;
        this.setCaption("Criteria");
        if (!"".equals(criteriaString) && criteriaString != null) {
            String[] arr;
            for (String criteria : arr = criteriaString.split("\\)\\.")) {
                this.m_criteriaRestrictionComponents.add(new CriteriaRestrictionComponent(criteriaBuilderHelper, criteria));
            }
        }
        this.renderComponents();
        this.m_criteriaLayout.setSpacing(true);
        this.setSizeFull();
        this.setContent((Component)this.m_criteriaLayout);
    }

    private void renderComponents() {
        this.m_criteriaLayout.removeAllComponents();
        boolean isFirst = true;
        for (int i = 0; i < this.m_criteriaRestrictionComponents.size(); ++i) {
            final CriteriaRestrictionComponent criteriaRestrictionComponent = this.m_criteriaRestrictionComponents.get(i);
            final int index = i;
            boolean isLast = i == this.m_criteriaRestrictionComponents.size() - 1;
            criteriaRestrictionComponent.getRightLayout().removeAllComponents();
            Button plusButton = new Button();
            plusButton.setStyleName("small");
            plusButton.setIcon((Resource)new ThemeResource("../runo/icons/16/document-add.png"));
            plusButton.setDescription("Add a new criteria entry");
            Button minusButton = new Button();
            minusButton.setStyleName("small");
            minusButton.setIcon((Resource)new ThemeResource("../runo/icons/16/document-delete.png"));
            minusButton.setDescription("Remove this criteria entry");
            Button upButton = new Button();
            upButton.setStyleName("small");
            upButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-up.png"));
            upButton.setDescription("Move this a criteria entry one position up");
            Button downButton = new Button();
            downButton.setStyleName("small");
            downButton.setIcon((Resource)new ThemeResource("../runo/icons/16/arrow-down.png"));
            downButton.setDescription("Move this a criteria entry one position down");
            criteriaRestrictionComponent.getRightLayout().addComponent((Component)upButton);
            criteriaRestrictionComponent.getRightLayout().addComponent((Component)downButton);
            criteriaRestrictionComponent.getRightLayout().addComponent((Component)plusButton);
            criteriaRestrictionComponent.getRightLayout().addComponent((Component)minusButton);
            if (this.m_criteriaRestrictionComponents.size() == 1) {
                minusButton.setEnabled(false);
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            } else {
                if (isFirst) {
                    upButton.setEnabled(false);
                }
                if (isLast) {
                    downButton.setEnabled(false);
                }
            }
            upButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent clickEvent) {
                    Collections.swap(CriteriaBuilderComponent.this.m_criteriaRestrictionComponents, index, index - 1);
                    CriteriaBuilderComponent.this.renderComponents();
                }
            });
            downButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent clickEvent) {
                    Collections.swap(CriteriaBuilderComponent.this.m_criteriaRestrictionComponents, index, index + 1);
                    CriteriaBuilderComponent.this.renderComponents();
                }
            });
            minusButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent clickEvent) {
                    CriteriaBuilderComponent.this.m_criteriaRestrictionComponents.remove((Object)criteriaRestrictionComponent);
                    CriteriaBuilderComponent.this.renderComponents();
                }
            });
            plusButton.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent clickEvent) {
                    CriteriaBuilderComponent.this.m_criteriaRestrictionComponents.add(index + 1, new CriteriaRestrictionComponent(CriteriaBuilderComponent.this.m_criteriaBuilderHelper, "Limit(10)"));
                    CriteriaBuilderComponent.this.renderComponents();
                }
            });
            isFirst = false;
            this.m_criteriaLayout.addComponent((Component)criteriaRestrictionComponent);
        }
    }

    public String getCriteria() {
        String criterias = "";
        boolean first = true;
        for (CriteriaRestrictionComponent criteriaRestrictionComponent : this.m_criteriaRestrictionComponents) {
            if (!first) {
                criterias = criterias + ".";
            }
            criterias = criterias + criteriaRestrictionComponent.getRestriction();
            first = false;
        }
        return criterias;
    }
}

