/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.data.util.BeanItemContainer;
import java.io.File;
import javax.xml.bind.JAXB;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.opennms.features.vaadin.dashboard.model.Wallboards;

public class WallboardProvider {
    private static WallboardProvider m_wallboardProvider = new WallboardProvider();
    private Wallboards m_wallboards = null;
    private File m_cfgFile = new File("etc/dashboard-config.xml");

    private WallboardProvider() {
        this.load();
    }

    public BeanItemContainer<Wallboard> getBeanContainer() {
        return new BeanItemContainer(Wallboard.class, this.m_wallboards.getWallboards());
    }

    public static WallboardProvider getInstance() {
        return m_wallboardProvider;
    }

    public synchronized void save() {
        if (this.m_wallboards == null) {
            this.load();
        }
        JAXB.marshal((Object)this.m_wallboards, (File)this.m_cfgFile);
    }

    public synchronized void load() {
        this.m_wallboards = !this.m_cfgFile.exists() ? new Wallboards() : (Wallboards)JAXB.unmarshal((File)this.m_cfgFile, Wallboards.class);
    }

    public synchronized boolean containsWallboard(String title) {
        for (Wallboard wallboard : this.m_wallboards.getWallboards()) {
            if (!wallboard.getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    public synchronized Wallboard getWallboard(String title) {
        for (Wallboard wallboard : this.m_wallboards.getWallboards()) {
            if (!wallboard.getTitle().equals(title)) continue;
            return wallboard;
        }
        return null;
    }

    public synchronized boolean containsWallboard(Wallboard wallboard) {
        return this.m_wallboards.getWallboards().contains(wallboard);
    }

    public synchronized void addWallboard(Wallboard wallboard) {
        if (this.m_wallboards == null) {
            this.load();
        }
        this.m_wallboards.getWallboards().add(wallboard);
        this.save();
    }

    public synchronized void removeWallboard(Wallboard wallboard) {
        if (this.m_wallboards == null) {
            this.load();
        }
        this.m_wallboards.getWallboards().remove(wallboard);
        this.save();
    }
}

