/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class DashletSelector
implements BundleActivator {
    List<ServiceListChangedListener> m_serviceListChangedListeners = new ArrayList<ServiceListChangedListener>();
    Map<String, DashletFactory> m_serviceInterfaceMap = new TreeMap<String, DashletFactory>();

    public void start(BundleContext context) throws Exception {
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void bind(DashletFactory dashletFactory) {
        if (dashletFactory != null) {
            LoggerFactory.getLogger(DashletSelector.class).warn("bind service " + dashletFactory.getClass().getName());
            this.m_serviceInterfaceMap.put(dashletFactory.getName(), dashletFactory);
            this.fireServiceListChangedListeners();
        } else {
            LoggerFactory.getLogger(DashletSelector.class).warn("service is null");
        }
    }

    public void unbind(DashletFactory dashletFactory) {
        if (dashletFactory != null) {
            LoggerFactory.getLogger(DashletSelector.class).warn("unbind service " + dashletFactory.getClass().getName());
            this.m_serviceInterfaceMap.remove(dashletFactory.getName());
            this.fireServiceListChangedListeners();
        } else {
            LoggerFactory.getLogger(DashletSelector.class).warn("service is null");
        }
    }

    public void addServiceListChangedListener(ServiceListChangedListener serviceListChangedListener) {
        this.m_serviceListChangedListeners.add(serviceListChangedListener);
    }

    public void removeServiceListChangedListener(ServiceListChangedListener serviceListChangedListener) {
        this.m_serviceListChangedListeners.remove(serviceListChangedListener);
    }

    private void fireServiceListChangedListeners() {
        ArrayList<DashletFactory> factoryList = new ArrayList<DashletFactory>();
        factoryList.addAll(this.m_serviceInterfaceMap.values());
        for (ServiceListChangedListener serviceListChangedListener : this.m_serviceListChangedListeners) {
            serviceListChangedListener.serviceListChanged(factoryList);
        }
    }

    public List<DashletFactory> getDashletFactoryList() {
        ArrayList<DashletFactory> factoryList = new ArrayList<DashletFactory>();
        factoryList.addAll(this.m_serviceInterfaceMap.values());
        return factoryList;
    }

    public DashletFactory getDashletFactoryForName(String name) {
        if (this.m_serviceInterfaceMap.containsKey(name)) {
            return this.m_serviceInterfaceMap.get(name);
        }
        return this.m_serviceInterfaceMap.get("Undefined");
    }

    public static interface ServiceListChangedListener {
        public void serviceListChanged(List<DashletFactory> var1);
    }
}

