/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.navigator.Navigator;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletSelectorAccess;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.opennms.features.vaadin.dashboard.ui.HeaderLayout;
import org.opennms.features.vaadin.dashboard.ui.dashboard.DashboardView;
import org.opennms.features.vaadin.dashboard.ui.wallboard.WallboardView;

@Theme(value="dashboard")
@Title(value="OpenNMS Ops Board")
public class WallboardUI
extends UI
implements DashletSelectorAccess {
    DashletSelector m_dashletSelector;

    public void setDashletSelector(DashletSelector dashletSelector) {
        this.m_dashletSelector = dashletSelector;
    }

    @Override
    public DashletSelector getDashletSelector() {
        return this.m_dashletSelector;
    }

    protected void init(VaadinRequest request) {
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSizeFull();
        rootLayout.setSpacing(true);
        HeaderLayout headerLayout = new HeaderLayout();
        rootLayout.addComponent((Component)headerLayout);
        VerticalLayout portalWrapper = new VerticalLayout();
        portalWrapper.setSizeFull();
        portalWrapper.setMargin(true);
        rootLayout.addComponent((Component)portalWrapper);
        rootLayout.setExpandRatio((Component)portalWrapper, 1.0f);
        this.setContent((Component)rootLayout);
        Navigator navigator = new Navigator((UI)this, (ComponentContainer)portalWrapper);
        navigator.addView("dashboard", DashboardView.class);
        navigator.addView("wallboard", WallboardView.class);
        navigator.navigateTo("wallboard");
        BeanItemContainer<Wallboard> beanItemContainer = WallboardProvider.getInstance().getBeanContainer();
        for (Wallboard wallboard : beanItemContainer.getItemIds()) {
            if (!wallboard.isDefault()) continue;
            headerLayout.gotoWallboard(wallboard);
            break;
        }
    }
}

