/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.dashboard.config.ui.HelpClickListener;
import org.opennms.features.vaadin.dashboard.config.ui.PreviewClickListener;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigView;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.Wallboard;

public class WallboardOverview
extends VerticalLayout {
    private Table m_table;
    private WallboardConfigView m_wallboardConfigView;
    BeanItemContainer<Wallboard> m_beanItemContainer;

    public WallboardOverview(WallboardConfigView wallboardConfigView) {
        this.m_wallboardConfigView = wallboardConfigView;
        this.m_beanItemContainer = WallboardProvider.getInstance().getBeanContainer();
        this.setSizeFull();
        this.setMargin(true);
        this.setSpacing(true);
        Label label = new Label("Overview");
        label.addStyleName("configuration-title");
        Button button = new Button("Help");
        button.setStyleName("small");
        button.setDescription("Display help and usage");
        button.addClickListener((Button.ClickListener)new HelpClickListener((Component)this, this.m_wallboardConfigView.getDashletSelector()));
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.addComponent((Component)label);
        horizontalLayout.addComponent((Component)button);
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        horizontalLayout.setComponentAlignment((Component)label, Alignment.MIDDLE_LEFT);
        horizontalLayout.setComponentAlignment((Component)button, Alignment.MIDDLE_RIGHT);
        this.addComponent((Component)horizontalLayout);
        this.m_table = new Table();
        this.m_table.setContainerDataSource(this.m_beanItemContainer);
        this.m_table.setSizeFull();
        this.m_table.addGeneratedColumn((Object)"Edit", new Table.ColumnGenerator(){

            public Object generateCell(Table source, final Object itemId, Object columnId) {
                Button button = new Button("Edit");
                button.setDescription("Edit this Ops Board configuration");
                button.setStyleName("small");
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        WallboardOverview.this.m_wallboardConfigView.openWallboardEditor((Wallboard)itemId);
                    }
                });
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Remove", new Table.ColumnGenerator(){

            public Object generateCell(Table source, final Object itemId, Object columnId) {
                Button button = new Button("Remove");
                button.setDescription("Delete this Ops Board configuration");
                button.setStyleName("small");
                button.addClickListener(new Button.ClickListener(){

                    public void buttonClick(Button.ClickEvent clickEvent) {
                        WallboardProvider.getInstance().removeWallboard((Wallboard)itemId);
                    }
                });
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Preview", new Table.ColumnGenerator(){

            public Object generateCell(Table source, Object itemId, Object columnId) {
                Button button = new Button("Preview");
                button.setDescription("Preview this Ops Board configuration");
                button.setStyleName("small");
                button.addClickListener((Button.ClickListener)new PreviewClickListener((Component)WallboardOverview.this, (Wallboard)itemId));
                return button;
            }
        });
        this.m_table.addGeneratedColumn((Object)"Default", new Table.ColumnGenerator(){

            public Object generateCell(Table source, Object itemId, Object columnId) {
                CheckBox checkBox = new CheckBox();
                checkBox.setImmediate(true);
                checkBox.setDescription("Make this Ops Board configuration the default");
                final Wallboard wallboard = (Wallboard)WallboardOverview.this.m_beanItemContainer.getItem(itemId).getBean();
                checkBox.setValue((Object)wallboard.isDefault());
                checkBox.addValueChangeListener(new Property.ValueChangeListener(){

                    public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                        boolean newValue = (Boolean)valueChangeEvent.getProperty().getValue();
                        if (newValue) {
                            for (Wallboard wallboard1 : WallboardOverview.this.m_beanItemContainer.getItemIds()) {
                                wallboard1.setDefault(false);
                            }
                        }
                        wallboard.setDefault(newValue);
                        WallboardOverview.this.m_table.refreshRowCache();
                        WallboardProvider.getInstance().save();
                    }
                });
                return checkBox;
            }
        });
        this.m_table.setVisibleColumns(new Object[]{"title", "Edit", "Remove", "Preview", "Default"});
        this.m_table.setColumnHeader((Object)"title", "Title");
        this.addComponent((Component)this.m_table);
        this.setExpandRatio((Component)this.m_table, 1.0f);
    }
}

