/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.vaadin.extender.VaadinResourceService;
import org.osgi.framework.Bundle;

public class VaadinResourceServlet
extends HttpServlet
implements VaadinResourceService {
    private static final long serialVersionUID = 1L;
    public static final String VAADIN = "/VAADIN";
    private final Bundle vaadin;
    private final List<Bundle> resourceBundles = new ArrayList<Bundle>();

    public VaadinResourceServlet(Bundle vaadin) {
        this.vaadin = vaadin;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL resourceUrl;
        String path = req.getPathInfo();
        String resourcePath = VAADIN + path;
        String contentType = this.getServletContext().getMimeType(resourcePath);
        if (contentType != null) {
            resp.setContentType(contentType);
        }
        if (null == (resourceUrl = this.vaadin.getResource(resourcePath))) {
            resourceUrl = this.loadFromResources(resourcePath);
        }
        if (null == resourceUrl) {
            resp.sendError(404);
            return;
        }
        InputStream in = resourceUrl.openStream();
        ServletOutputStream out = resp.getOutputStream();
        byte[] buffer = new byte[1024];
        int read = 0;
        while (-1 != (read = in.read(buffer))) {
            out.write(buffer, 0, read);
        }
    }

    private URL loadFromResources(String resourcePath) {
        for (Bundle resourceBundle : this.resourceBundles) {
            URL resourceUrl = resourceBundle.getResource(resourcePath);
            if (null == resourceUrl) continue;
            return resourceUrl;
        }
        return null;
    }

    @Override
    public void addResources(Bundle bundle) {
        this.resourceBundles.add(bundle);
    }

    @Override
    public void removeResources(Bundle bundle) {
        this.resourceBundles.remove(bundle);
    }
}

