/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.extender;

import com.vaadin.ui.UI;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.opennms.vaadin.extender.AbstractApplicationFactory;
import org.opennms.vaadin.extender.VaadinResourceService;
import org.opennms.vaadin.extender.internal.servlet.VaadinOSGiServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxVaadinBundleTracker
extends BundleTracker<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(PaxVaadinBundleTracker.class);
    private final Logger logger = LoggerFactory.getLogger((String)PaxVaadinBundleTracker.class.getName());
    private final Map<Bundle, ServiceRegistration<?>> registeredServlets = new HashMap();

    public PaxVaadinBundleTracker(BundleContext context) {
        super(context, 32, null);
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (this.isApplicationBundle(bundle)) {
            this.logger.debug("found a vaadin-app bundle: {}", (Object)bundle);
            String applicationClass = (String)bundle.getHeaders().get("Vaadin-Application");
            String alias = (String)bundle.getHeaders().get("Vaadin-Alias");
            UI application = null;
            try {
                Class appClazz = bundle.loadClass(applicationClass);
                Constructor<?>[] ctors = appClazz.getDeclaredConstructors();
                Constructor<?> ctor = null;
                for (int i = 0; i < ctors.length && (ctor = ctors[i]).getGenericParameterTypes().length != 0; ++i) {
                }
                ctor.setAccessible(true);
                application = (UI)ctor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("Could not add bundle: ", (Throwable)e);
            }
            String widgetset = this.findWidgetset(bundle);
            if (application != null) {
                VaadinOSGiServlet servlet = new VaadinOSGiServlet(new ApplicationFactoryWrapper(application), bundle.getBundleContext());
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("alias", alias);
                if (widgetset != null) {
                    props.put("widgetset", widgetset);
                }
                ServiceRegistration registeredServlet = bundle.getBundleContext().registerService(HttpServlet.class.getName(), (Object)servlet, (Dictionary)props);
                this.registeredServlets.put(bundle, registeredServlet);
            }
        }
        if (this.isThemeBundle(bundle)) {
            this.logger.debug("found a vaadin-resource bundle: {}", (Object)bundle);
            ServiceReference serviceReference = bundle.getBundleContext().getServiceReference(VaadinResourceService.class.getName());
            VaadinResourceService service = (VaadinResourceService)bundle.getBundleContext().getService(serviceReference);
            service.addResources(bundle);
        }
        return super.addingBundle(bundle, event);
    }

    protected String findWidgetset(Bundle bundle) {
        Enumeration widgetEntries = bundle.findEntries("", "*.gwt.xml", true);
        if (widgetEntries == null || !widgetEntries.hasMoreElements()) {
            return null;
        }
        URL widgetUrl = (URL)widgetEntries.nextElement();
        String path = widgetUrl.getPath();
        path = path.substring(1, path.length() - 8);
        path = path.replace("/", ".");
        return path;
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        ServiceRegistration<?> registeredServlet = this.registeredServlets.get(bundle);
        if (registeredServlet != null) {
            registeredServlet.unregister();
        }
        super.removedBundle(bundle, event, object);
    }

    private boolean isApplicationBundle(Bundle bundle) {
        if (!this.isVaadinBundle(bundle)) {
            return false;
        }
        String applicationClass = (String)bundle.getHeaders().get("Vaadin-Application");
        return applicationClass != null && !applicationClass.isEmpty();
    }

    private boolean isThemeBundle(Bundle bundle) {
        if ("com.vaadin".equals(bundle.getSymbolicName())) {
            return false;
        }
        Enumeration vaadinPaths = bundle.getEntryPaths("/VAADIN");
        return vaadinPaths != null && vaadinPaths.hasMoreElements();
    }

    private boolean isVaadinBundle(Bundle bundle) {
        String importedPackages = (String)bundle.getHeaders().get("Import-Package");
        if (importedPackages == null) {
            return false;
        }
        return importedPackages.contains("com.vaadin");
    }

    private static class ApplicationFactoryWrapper
    extends AbstractApplicationFactory {
        private UI m_application;

        public ApplicationFactoryWrapper(UI application) {
            this.m_application = application;
        }

        @Override
        public Class<? extends UI> getUIClass() {
            return this.m_application.getClass();
        }

        @Override
        public UI createUI() {
            return this.m_application;
        }
    }
}

