/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender;

import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.VaadinSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.vaadin.extender.SessionListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListenerRepository
implements SessionInitListener,
SessionDestroyListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionListenerRepository.class);
    private final BundleContext context;
    private Map<VaadinSession, String> vaadinSessionIdMap = new HashMap<VaadinSession, String>();

    public static SessionListenerRepository getRepository(BundleContext context) {
        ServiceReference reference = context.getServiceReference(SessionListenerRepository.class.getName());
        return (SessionListenerRepository)context.getService(reference);
    }

    public SessionListenerRepository(BundleContext context) {
        this.context = context;
    }

    public void sessionDestroy(SessionDestroyEvent event) {
        String sessionId = this.vaadinSessionIdMap.get(event.getSession());
        if (sessionId == null) {
            throw new IllegalArgumentException("Unknown session : " + event.getSession());
        }
        for (SessionListener eachListener : this.getSessionListeners()) {
            eachListener.sessionDestroyed(sessionId);
        }
        this.vaadinSessionIdMap.remove(event.getSession());
    }

    public void sessionInit(SessionInitEvent event) throws ServiceException {
        this.vaadinSessionIdMap.put(event.getSession(), event.getSession().getSession().getId());
        for (SessionListener eachListener : this.getSessionListeners()) {
            eachListener.sessionInitialized(this.vaadinSessionIdMap.get(event.getSession()));
        }
    }

    private List<SessionListener> getSessionListeners() {
        ArrayList<SessionListener> sessionListeners = new ArrayList<SessionListener>();
        ServiceReference[] references = new ServiceReference[]{};
        try {
            references = this.context.getAllServiceReferences(SessionListener.class.getName(), null);
            if (references != null) {
                for (ServiceReference eachReference : references) {
                    Object service = this.context.getService(eachReference);
                    if (service == null) continue;
                    sessionListeners.add((SessionListener)service);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Error retrieving SessionListeners", (Throwable)e);
        }
        return sessionListeners;
    }
}

