/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.servlet;

import com.vaadin.server.BootstrapFragmentResponse;
import com.vaadin.server.BootstrapListener;
import com.vaadin.server.BootstrapPageResponse;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.opennms.vaadin.extender.ApplicationFactory;
import org.opennms.vaadin.extender.SessionListenerRepository;
import org.opennms.vaadin.extender.internal.servlet.OSGiUIProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinOSGiServlet
extends VaadinServlet {
    private final OSGiUIProvider m_provider;
    private final Set<VaadinSession> m_sessions = Collections.synchronizedSet(new HashSet());
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BundleContext m_context;

    public VaadinOSGiServlet(ApplicationFactory factory, BundleContext bundleContext) {
        this.m_provider = new OSGiUIProvider(factory);
        this.m_context = bundleContext;
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinServletService service = super.createServletService(deploymentConfiguration);
        service.addSessionInitListener(new SessionInitListener(){

            public void sessionInit(SessionInitEvent event) throws ServiceException {
                VaadinSession session = event.getSession();
                VaadinOSGiServlet.this.m_sessions.add(session);
                if (session.getUIProviders().isEmpty() || !session.getUIProviders().contains((Object)VaadinOSGiServlet.this.m_provider)) {
                    session.addUIProvider((UIProvider)VaadinOSGiServlet.this.m_provider);
                }
            }
        });
        service.addSessionDestroyListener(new SessionDestroyListener(){

            public void sessionDestroy(SessionDestroyEvent event) {
                VaadinSession session = event.getSession();
                VaadinOSGiServlet.this.m_sessions.remove(session);
                if (session.getUIProviders().contains((Object)VaadinOSGiServlet.this.m_provider)) {
                    session.removeUIProvider((UIProvider)VaadinOSGiServlet.this.m_provider);
                }
            }
        });
        SessionListenerRepository sessionListenerRepository = SessionListenerRepository.getRepository(this.m_context);
        if (sessionListenerRepository != null) {
            service.addSessionInitListener((SessionInitListener)sessionListenerRepository);
            service.addSessionDestroyListener((SessionDestroyListener)sessionListenerRepository);
        }
        service.addSessionInitListener(new SessionInitListener(){

            public void sessionInit(SessionInitEvent event) throws ServiceException {
                event.getSession().addBootstrapListener(new BootstrapListener(){

                    public void modifyBootstrapPage(BootstrapPageResponse response) {
                        response.getDocument().head().getElementsByAttributeValue("rel", "shortcut icon").attr("href", "/opennms/favicon.ico");
                        response.getDocument().head().getElementsByAttributeValue("rel", "icon").attr("href", "/opennms/favicon.ico");
                    }

                    public void modifyBootstrapFragment(BootstrapFragmentResponse response) {
                    }
                });
            }
        });
        return service;
    }

    protected void servletInitialized() throws ServletException {
        this.LOG.info("Servlet Initialized");
    }

    public void destroy() {
        for (VaadinSession vaadinSession : this.m_sessions) {
            vaadinSession.removeFromSession(vaadinSession.getService());
        }
        super.destroy();
    }
}

