/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.opennms.vaadin.extender.SessionListenerRepository;
import org.opennms.vaadin.extender.VaadinResourceService;
import org.opennms.vaadin.extender.internal.extender.ApplicationFactoryServiceTracker;
import org.opennms.vaadin.extender.internal.extender.PaxVaadinBundleTracker;
import org.opennms.vaadin.extender.internal.servlet.VaadinResourceServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleContext bundleContext;
    private PaxVaadinBundleTracker bundleTracker;
    private ServiceRegistration resourceService;
    private ApplicationFactoryServiceTracker applicationFactoryServiceTracker;
    private ServiceRegistration sessionListenerRepositoryService;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.createAndRegisterVaadinResourceServlet();
        this.sessionListenerRepositoryService = this.bundleContext.registerService(SessionListenerRepository.class.getName(), (Object)new SessionListenerRepository(this.bundleContext), null);
        this.bundleTracker = new PaxVaadinBundleTracker(this.bundleContext);
        this.applicationFactoryServiceTracker = new ApplicationFactoryServiceTracker(this.bundleContext);
        this.bundleTracker.open();
        this.applicationFactoryServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        if (this.applicationFactoryServiceTracker != null) {
            this.applicationFactoryServiceTracker.close();
        }
        if (this.resourceService != null) {
            this.resourceService.unregister();
        }
        if (this.sessionListenerRepositoryService != null) {
            this.sessionListenerRepositoryService.unregister();
        }
    }

    private void createAndRegisterVaadinResourceServlet() {
        Bundle vaadin = null;
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!"com.vaadin.client-compiled".equals(bundle.getSymbolicName())) continue;
            vaadin = bundle;
            break;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("alias", "/VAADIN");
        VaadinResourceServlet vaadinResourceServlet = new VaadinResourceServlet(vaadin);
        this.resourceService = this.bundleContext.registerService(Servlet.class.getName(), (Object)vaadinResourceServlet, props);
        this.bundleContext.registerService(VaadinResourceService.class.getName(), (Object)vaadinResourceServlet, null);
    }
}

