/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.vaadin.extender.internal.extender;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.vaadin.extender.ApplicationFactory;
import org.opennms.vaadin.extender.internal.servlet.VaadinOSGiServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationFactoryServiceTracker
extends ServiceTracker {
    private Map<ApplicationFactory, ServiceRegistration> m_serviceRegistration = new HashMap<ApplicationFactory, ServiceRegistration>();
    private final Logger logger = LoggerFactory.getLogger((String)ApplicationFactoryServiceTracker.class.getName());

    public ApplicationFactoryServiceTracker(BundleContext context) {
        super(context, ApplicationFactory.class.getName(), null);
    }

    public Object addingService(ServiceReference reference) {
        ApplicationFactory factory = (ApplicationFactory)super.addingService(reference);
        if (factory == null) {
            return null;
        }
        FactoryServlet servlet = new FactoryServlet(factory, reference.getBundle().getBundleContext());
        Properties props = new Properties();
        for (String key : reference.getPropertyKeys()) {
            ((Dictionary)props).put(key, reference.getProperty(key));
        }
        if (((Dictionary)props).get("alias") == null) {
            this.logger.warn("You have not set the alias property for ApplicationFactory: " + factory);
        }
        this.m_serviceRegistration.put(factory, this.context.registerService(Servlet.class.getName(), (Object)servlet, (Dictionary)props));
        return factory;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        super.modifiedService(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        ApplicationFactory factory = (ApplicationFactory)this.context.getService(reference);
        ServiceRegistration servletRegistration = this.m_serviceRegistration.remove(factory);
        if (servletRegistration != null) {
            servletRegistration.unregister();
        }
        super.removedService(reference, service);
    }

    private class FactoryServlet
    extends VaadinOSGiServlet {
        private static final long serialVersionUID = 7458986273769030388L;
        private ApplicationFactory m_factory;

        public FactoryServlet(ApplicationFactory factory, BundleContext context) {
            super(factory, context);
            this.m_factory = factory;
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Map<String, String> headers = this.m_factory.getAdditionalHeaders();
            if (headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    response.addHeader(entry.getKey(), entry.getValue());
                }
            }
            super.service(request, response);
        }
    }
}

