/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import com.vaadin.ui.UI;
import java.util.Objects;
import org.opennms.netmgt.vaadin.core.TransactionAwareBeanProxyFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public abstract class TransactionAwareUI
extends UI {
    private final TransactionOperations transactionOperations;

    public TransactionAwareUI(TransactionOperations transactionOperations) {
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
    }

    public <T> T runInTransaction(TransactionCallback<T> callback) throws TransactionException {
        return (T)this.transactionOperations.execute(callback);
    }

    public void runInTransaction(final Runnable callback) throws TransactionException {
        this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                callback.run();
            }
        });
    }

    public <T> T wrapInTransactionProxy(T t) {
        return new TransactionAwareBeanProxyFactory(this.transactionOperations).createProxy(t);
    }
}

