/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import com.vaadin.data.Validator;
import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public class KeyValueInputDialogWindow
extends Window
implements Window.CloseListener,
Button.ClickListener {
    private Action m_okAction;
    private Action m_cancelAction;
    private final Button m_cancelButton;
    private final Button m_okButton;
    private final TextField m_keyInputField;
    private final TextField m_valueInputField;
    private boolean m_focusKey = true;
    private boolean m_okPressed;

    public KeyValueInputDialogWindow() {
        this("Input required", "Key", "Value");
    }

    public KeyValueInputDialogWindow(String caption, String keyName, String valueName) {
        super(caption);
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        VerticalLayout verticalLayout = new VerticalLayout();
        this.m_keyInputField = new TextField(keyName);
        this.m_keyInputField.setValue("");
        this.m_keyInputField.setId("keyField");
        this.m_keyInputField.selectAll();
        this.m_keyInputField.setImmediate(true);
        this.m_keyInputField.focus();
        this.m_valueInputField = new TextField(valueName);
        this.m_valueInputField.setValue("");
        this.m_valueInputField.setId("valueField");
        this.m_valueInputField.selectAll();
        this.m_valueInputField.setImmediate(true);
        FormLayout formLayout = new FormLayout();
        formLayout.setSizeUndefined();
        formLayout.setMargin(true);
        formLayout.addComponent((Component)this.m_keyInputField);
        formLayout.addComponent((Component)this.m_valueInputField);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setWidth("100%");
        this.m_cancelButton = new Button("Cancel");
        this.m_cancelButton.setId("cancelBtn");
        this.m_cancelButton.setClickShortcut(27, null);
        this.m_cancelButton.addClickListener((Button.ClickListener)this);
        horizontalLayout.addComponent((Component)this.m_cancelButton);
        horizontalLayout.setExpandRatio((Component)this.m_cancelButton, 1.0f);
        horizontalLayout.setComponentAlignment((Component)this.m_cancelButton, Alignment.TOP_RIGHT);
        this.m_okButton = new Button("OK");
        this.m_okButton.setId("okBtn");
        this.m_okButton.setClickShortcut(13, null);
        this.m_okButton.addClickListener((Button.ClickListener)this);
        horizontalLayout.addComponent((Component)this.m_okButton);
        formLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)formLayout);
        this.addFocusListener(new FieldEvents.FocusListener(){

            public void focus(FieldEvents.FocusEvent event) {
                if (KeyValueInputDialogWindow.this.m_focusKey) {
                    KeyValueInputDialogWindow.this.m_keyInputField.focus();
                } else {
                    KeyValueInputDialogWindow.this.m_valueInputField.focus();
                }
            }
        });
        this.addCloseListener(this);
        this.setContent((Component)verticalLayout);
    }

    public KeyValueInputDialogWindow withKeyValidator(Validator validator) {
        this.m_keyInputField.addValidator(validator);
        return this;
    }

    public KeyValueInputDialogWindow withValueValidator(Validator validator) {
        this.m_valueInputField.addValidator(validator);
        return this;
    }

    public String getValue() {
        return (String)this.m_valueInputField.getValue();
    }

    public String getKey() {
        return (String)this.m_keyInputField.getValue();
    }

    public KeyValueInputDialogWindow withValue(String value) {
        this.m_valueInputField.setValue(value);
        return this;
    }

    public KeyValueInputDialogWindow withKey(String key) {
        this.m_keyInputField.setValue(key);
        return this;
    }

    public KeyValueInputDialogWindow withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public KeyValueInputDialogWindow withKeyFieldName(String fieldName) {
        this.m_keyInputField.setCaption(fieldName);
        return this;
    }

    public KeyValueInputDialogWindow withValueFieldName(String fieldName) {
        this.m_valueInputField.setCaption(fieldName);
        return this;
    }

    public KeyValueInputDialogWindow withOkAction(Action okAction) {
        this.m_okAction = okAction;
        return this;
    }

    public KeyValueInputDialogWindow withCancelAction(Action cancelAction) {
        this.m_cancelAction = cancelAction;
        return this;
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }

    public KeyValueInputDialogWindow withOkLabel(String okLabel) {
        this.m_okButton.setCaption(okLabel);
        return this;
    }

    public KeyValueInputDialogWindow withCancelLabel(String cancelLabel) {
        this.m_cancelButton.setCaption(cancelLabel);
        return this;
    }

    public void windowClose(Window.CloseEvent e) {
        if (this.m_okPressed) {
            if (this.m_okAction != null) {
                this.m_okAction.execute(this);
            }
        } else if (this.m_cancelAction != null) {
            this.m_cancelAction.execute(this);
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        boolean bl = this.m_okPressed = event.getSource() == this.m_okButton;
        if (this.m_okPressed && this.m_keyInputField.isValid() && this.m_valueInputField.isValid() || !this.m_okPressed) {
            this.close();
        }
    }

    public KeyValueInputDialogWindow focusKey() {
        this.m_focusKey = true;
        return this;
    }

    public KeyValueInputDialogWindow focusValue() {
        this.m_focusKey = false;
        return this;
    }

    public KeyValueInputDialogWindow enableKey() {
        this.m_keyInputField.setEnabled(true);
        return this;
    }

    public KeyValueInputDialogWindow disableKey() {
        this.m_keyInputField.setEnabled(false);
        return this;
    }

    public KeyValueInputDialogWindow enableValue() {
        this.m_valueInputField.setEnabled(true);
        return this;
    }

    public KeyValueInputDialogWindow disableValue() {
        this.m_valueInputField.setEnabled(false);
        return this;
    }

    public static interface Action {
        public void execute(KeyValueInputDialogWindow var1);
    }
}

