/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class TransactionAwareBeanProxyFactory {
    private final TransactionOperations transactionOperations;

    public TransactionAwareBeanProxyFactory(TransactionOperations transactionOperations) {
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
    }

    public <T> T createProxy(final T createProxyFor) {
        Objects.requireNonNull(createProxyFor);
        if (createProxyFor.getClass().getInterfaces().length == 0) {
            throw new IllegalArgumentException("No interface defined for class " + createProxyFor.getClass());
        }
        InvocationHandler transactionInvocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxyObject, final Method method, final Object[] objects) throws Throwable {
                try {
                    Object result = TransactionAwareBeanProxyFactory.this.transactionOperations.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction(TransactionStatus status) {
                            try {
                                return method.invoke(createProxyFor, objects);
                            }
                            catch (InvocationTargetException e) {
                                throw new TransactionInvocationHandlerException("Error while invoking transaction aware method", e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return result;
                }
                catch (TransactionInvocationHandlerException ex) {
                    if (ex.getCause() instanceof InvocationTargetException) {
                        throw ((InvocationTargetException)ex.getCause()).getTargetException();
                    }
                    throw ex.getCause();
                }
            }
        };
        Object transactionAwareProxy = Proxy.newProxyInstance(createProxyFor.getClass().getClassLoader(), createProxyFor.getClass().getInterfaces(), transactionInvocationHandler);
        return (T)transactionAwareProxy;
    }

    private static class TransactionInvocationHandlerException
    extends RuntimeException {
        public TransactionInvocationHandlerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

