/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import com.vaadin.data.Validator;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public class StringInputDialogWindow
extends Window
implements Window.CloseListener,
Button.ClickListener {
    private Action m_okAction;
    private Action m_cancelAction;
    private final Button m_cancelButton;
    private final Button m_okButton;
    private final TextField m_inputField;
    private boolean m_okPressed;

    public StringInputDialogWindow() {
        this("Input required", "Input");
    }

    public StringInputDialogWindow(String caption, String fieldName) {
        super(caption);
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        VerticalLayout verticalLayout = new VerticalLayout();
        this.m_inputField = new TextField(fieldName);
        this.m_inputField.setValue("");
        this.m_inputField.focus();
        this.m_inputField.selectAll();
        this.m_inputField.setImmediate(true);
        FormLayout formLayout = new FormLayout();
        formLayout.setSizeUndefined();
        formLayout.setMargin(true);
        formLayout.addComponent((Component)this.m_inputField);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.setSpacing(true);
        horizontalLayout.setWidth("100%");
        this.m_cancelButton = new Button("Cancel");
        this.m_cancelButton.setClickShortcut(27, null);
        this.m_cancelButton.addClickListener((Button.ClickListener)this);
        horizontalLayout.addComponent((Component)this.m_cancelButton);
        horizontalLayout.setExpandRatio((Component)this.m_cancelButton, 1.0f);
        horizontalLayout.setComponentAlignment((Component)this.m_cancelButton, Alignment.TOP_RIGHT);
        this.m_okButton = new Button("OK");
        this.m_okButton.setClickShortcut(13, null);
        this.m_okButton.addClickListener((Button.ClickListener)this);
        horizontalLayout.addComponent((Component)this.m_okButton);
        formLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)formLayout);
        this.addCloseListener(this);
        this.setContent((Component)verticalLayout);
    }

    public StringInputDialogWindow withValidator(Validator validator) {
        this.m_inputField.addValidator(validator);
        return this;
    }

    public String getValue() {
        return (String)this.m_inputField.getValue();
    }

    public StringInputDialogWindow withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public StringInputDialogWindow withFieldName(String fieldName) {
        this.m_inputField.setCaption(fieldName);
        return this;
    }

    public StringInputDialogWindow withOkAction(Action okAction) {
        this.m_okAction = okAction;
        return this;
    }

    public StringInputDialogWindow withCancelAction(Action cancelAction) {
        this.m_cancelAction = cancelAction;
        return this;
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }

    public StringInputDialogWindow withOkLabel(String okLabel) {
        this.m_okButton.setCaption(okLabel);
        return this;
    }

    public StringInputDialogWindow withCancelLabel(String cancelLabel) {
        this.m_cancelButton.setCaption(cancelLabel);
        return this;
    }

    public void windowClose(Window.CloseEvent e) {
        if (this.m_okPressed) {
            if (this.m_okAction != null) {
                this.m_okAction.execute(this);
            }
        } else if (this.m_cancelAction != null) {
            this.m_cancelAction.execute(this);
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        boolean bl = this.m_okPressed = event.getSource() == this.m_okButton;
        if (this.m_okPressed && this.m_inputField.isValid() || !this.m_okPressed) {
            this.close();
        }
    }

    public static interface Action {
        public void execute(StringInputDialogWindow var1);
    }
}

