/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.function.Supplier;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class ConfirmationDialog
extends Window
implements Window.CloseListener,
Button.ClickListener {
    private Action okAction;
    private Action cancelAction;
    private final VerticalLayout layout = new VerticalLayout();
    private final Label label = new Label("", ContentMode.HTML);
    private final Button cancelButton;
    private final Button okButton;
    private boolean okPressed;

    public ConfirmationDialog() {
        this("Continue?", "Do you really want to continue?");
    }

    public ConfirmationDialog(String caption, String description) {
        this.setCaption(caption);
        this.setModal(true);
        this.setResizable(false);
        this.setClosable(false);
        this.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.setHeight(200.0f, Sizeable.Unit.PIXELS);
        this.addCloseListener(this);
        this.okButton = UIHelper.createButton("ok", null, null, this);
        this.okButton.setId("confirmationDialog.button.ok");
        this.cancelButton = UIHelper.createButton("cancel", "cancels the current action.", null, this);
        this.cancelButton.setId("confirmationDialog.button.cancel");
        this.label.setDescription(description);
        HorizontalLayout buttonLayout = new HorizontalLayout(new Component[]{this.okButton, this.cancelButton});
        buttonLayout.setSpacing(true);
        this.layout.setSpacing(true);
        this.layout.setMargin(true);
        this.layout.setSizeFull();
        this.layout.addComponent((Component)this.label);
        this.layout.addComponent((Component)buttonLayout);
        this.layout.setComponentAlignment((Component)buttonLayout, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)this.layout);
        this.center();
    }

    public ConfirmationDialog withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public ConfirmationDialog withDescription(String description) {
        this.label.setValue(description);
        return this;
    }

    public ConfirmationDialog withDescription(Supplier<String> descriptionSupplier) {
        this.withDescription(descriptionSupplier.get());
        return this;
    }

    public ConfirmationDialog withOkAction(Action okAction) {
        this.okAction = okAction;
        return this;
    }

    public ConfirmationDialog withCancelButton(boolean cancelButtonVisible) {
        this.cancelButton.setVisible(cancelButtonVisible);
        return this;
    }

    public ConfirmationDialog withCancelAction(Action cancelAction) {
        this.cancelAction = cancelAction;
        return this;
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }

    public ConfirmationDialog withOkLabel(String okLabel) {
        this.okButton.setCaption(okLabel);
        return this;
    }

    public ConfirmationDialog withCancelLabel(String cancelLabel) {
        this.cancelButton.setCaption(cancelLabel);
        return this;
    }

    public void windowClose(Window.CloseEvent e) {
        if (this.okPressed) {
            if (this.okAction != null) {
                this.okAction.execute(this);
            }
        } else if (this.cancelAction != null) {
            this.cancelAction.execute(this);
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        this.okPressed = event.getSource() == this.okButton;
        this.close();
    }

    public static interface Action {
        public void execute(ConfirmationDialog var1);
    }
}

