/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class TransactionAwareBeanProxyFactory {
    private final TransactionOperations transactionOperations;

    public TransactionAwareBeanProxyFactory(TransactionOperations transactionOperations) {
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
    }

    public <T> T createProxy(final T createProxyFor) {
        Objects.requireNonNull(createProxyFor);
        if (createProxyFor.getClass().getInterfaces().length == 0) {
            throw new IllegalArgumentException("No interface defined for class " + createProxyFor.getClass());
        }
        InvocationHandler transactionInvocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxyObject, final Method method, final Object[] objects) throws Throwable {
                Object result = TransactionAwareBeanProxyFactory.this.transactionOperations.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus status) {
                        try {
                            return method.invoke(createProxyFor, objects);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return result;
            }
        };
        Object transactionAwareProxy = Proxy.newProxyInstance(createProxyFor.getClass().getClassLoader(), createProxyFor.getClass().getInterfaces(), transactionInvocationHandler);
        return (T)transactionAwareProxy;
    }
}

