/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;

@Command(scope="onms", name="listcommands", description="Lists the available shell commands and their providers.")
public class CommandProviderShellCommand
extends OsgiCommandSupport {
    protected Object doExecute() throws Exception {
        Collection services = this.bundleContext.getServiceReferences(BlueprintContainer.class, null);
        for (ServiceReference sr : services) {
            ArrayList<String> commands = new ArrayList<String>();
            BlueprintContainer container = (BlueprintContainer)this.bundleContext.getService(sr);
            Collection metadata = container.getMetadata(ServiceMetadata.class);
            for (ServiceMetadata data : metadata) {
                String scope = null;
                String function = null;
                List properties = data.getServiceProperties();
                for (Object o : properties) {
                    String value;
                    String key;
                    MapEntry entry = (MapEntry)o;
                    if (entry.getKey() instanceof ValueMetadata) {
                        ValueMetadata vmKey = (ValueMetadata)entry.getKey();
                        key = vmKey.getStringValue();
                    } else {
                        key = entry.getKey().toString();
                    }
                    if (entry.getValue() instanceof ValueMetadata) {
                        ValueMetadata vmValue = (ValueMetadata)entry.getValue();
                        value = vmValue.getStringValue();
                    } else {
                        value = entry.getValue().toString();
                    }
                    if (key.equals("osgi.command.scope")) {
                        scope = value;
                        continue;
                    }
                    if (!key.equals("osgi.command.function")) continue;
                    function = value;
                }
                if (scope == null || function == null) continue;
                commands.add(scope + ":" + function);
            }
            if (commands.size() <= 0) continue;
            System.out.println(sr.getBundle());
            for (String command : commands) {
                System.out.println("    " + command);
            }
            System.out.println();
        }
        return null;
    }
}

