/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.shell;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.features.topology.api.Operation;
import org.osgi.framework.ServiceReference;

@Command(scope="topo", name="listoperations", description="Lists the available OpenNMS topology operations.")
public class OperationListShellCommand
extends OsgiCommandSupport {
    protected Object doExecute() throws Exception {
        Map props;
        TreeSet<Operation> operations = new TreeSet<Operation>();
        HashMap properties = new HashMap();
        Collection services = this.bundleContext.getServiceReferences(Operation.class, null);
        if (services == null) {
            return null;
        }
        for (ServiceReference sr : services) {
            Operation operation = (Operation)this.bundleContext.getService(sr);
            if (operation == null) continue;
            operations.add(operation);
            props = new TreeMap<String, Object>();
            for (String key : sr.getPropertyKeys()) {
                props.put(key, sr.getProperty(key));
            }
            properties.put(operation, props);
        }
        for (Operation operation : operations) {
            String operationClass = operation.getClass().getName();
            System.out.println("    " + operationClass);
            System.out.println("    " + this.makeLine(operationClass));
            System.out.println();
            System.out.println("    ID:    " + operation.getId());
            System.out.println();
            props = (Map)properties.get(operation);
            if (props.size() <= 0) continue;
            System.out.println("    Service Properties:");
            System.out.println("    " + this.makeLine("Service Properties:"));
            System.out.println();
            for (String key : props.keySet()) {
                Object object = props.get(key);
                String value = object instanceof Object[] ? Arrays.toString((Object[])object) : object.toString();
                System.out.println("        " + key + "=" + value);
            }
            System.out.println();
        }
        return null;
    }

    private String makeLine(String s) {
        return new String(new char[s.length()]).replace("\u0000", "-");
    }
}

