/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.simple.internal.operations;

import java.util.List;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.LoggerFactory;

public class AddVertexOperation
implements Operation {
    private String m_iconKey;

    public AddVertexOperation(String iconKey) {
        this.m_iconKey = iconKey;
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return true;
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        return targets.size() <= 1;
    }

    public String getId() {
        return "AddVertex";
    }

    void connectNewVertex(String vertexId, String iconKey, GraphContainer graphContainer) {
        Vertex vertId1 = graphContainer.getBaseTopology().addVertex(0, 0);
        vertId1.setParent(null);
        graphContainer.getBaseTopology().connectVertices((VertexRef)graphContainer.getBaseTopology().getVertex(graphContainer.getBaseTopology().getVertexNamespace(), vertexId), (VertexRef)vertId1);
    }

    public String getIconKey() {
        return this.m_iconKey;
    }

    public Operation.Undoer execute(List<VertexRef> targets, OperationContext operationContext) {
        LoggerFactory.getLogger(this.getClass()).debug("execute()");
        String vertexId = targets.isEmpty() ? null : targets.get(0).getId();
        String icon = this.getIconKey();
        if (vertexId == null) {
            if (operationContext.getGraphContainer().getBaseTopology().containsVertexId("center")) {
                this.connectNewVertex("center", "server", operationContext.getGraphContainer());
            } else {
                Vertex vertId = operationContext.getGraphContainer().getBaseTopology().addVertex(250, 250);
                vertId.setParent(null);
            }
        } else {
            this.connectNewVertex(vertexId.toString(), icon, operationContext.getGraphContainer());
        }
        operationContext.getGraphContainer().redoLayout();
        return null;
    }
}

