/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.simple;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleEdgeProvider;
import org.opennms.features.topology.api.topo.SimpleGroup;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.SimpleVertexProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.WrappedEdge;
import org.opennms.features.topology.api.topo.WrappedGraph;
import org.opennms.features.topology.api.topo.WrappedGroup;
import org.opennms.features.topology.api.topo.WrappedLeafVertex;
import org.opennms.features.topology.api.topo.WrappedVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGraphProvider
extends AbstractTopologyProvider
implements GraphProvider {
    protected static final String TOPOLOGY_NAMESPACE_SIMPLE = "simple";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleGraphProvider.class);
    private URI m_topologyLocation = null;

    public SimpleGraphProvider() {
        this(TOPOLOGY_NAMESPACE_SIMPLE);
    }

    public SimpleGraphProvider(String namespace) {
        super(namespace);
        LOG.debug("Creating a new SimpleTopologyProvider with namespace {}", (Object)namespace);
    }

    public URI getTopologyLocation() {
        return this.m_topologyLocation;
    }

    public void setTopologyLocation(URI topologyLocation) throws MalformedURLException, JAXBException {
        this.m_topologyLocation = topologyLocation;
        if (this.m_topologyLocation != null && new File(this.m_topologyLocation).exists()) {
            LOG.debug("Loading topology from " + this.m_topologyLocation);
            this.load(this.m_topologyLocation);
        } else {
            LOG.debug("Setting topology location to null");
            this.clearVertices();
            this.clearEdges();
        }
    }

    public void save(String filename) throws MalformedURLException, JAXBException {
        this.m_topologyLocation = new File(filename).toURI();
        this.save();
    }

    public void save() {
        ArrayList<Object> vertices = new ArrayList<Object>();
        for (Vertex vertex : this.getVertices(new Criteria[0])) {
            if (vertex.isGroup()) {
                vertices.add(new WrappedGroup(vertex));
                continue;
            }
            vertices.add(new WrappedLeafVertex(vertex));
        }
        ArrayList<WrappedEdge> edges = new ArrayList<WrappedEdge>();
        for (Edge edge : this.getEdges(new Criteria[0])) {
            WrappedEdge newEdge = new WrappedEdge(edge, (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getSource().getVertex(), new Criteria[0])), (WrappedVertex)new WrappedLeafVertex(this.m_vertexProvider.getVertex(edge.getTarget().getVertex(), new Criteria[0])));
            edges.add(newEdge);
        }
        WrappedGraph graph = new WrappedGraph(this.getVertexNamespace(), vertices, edges);
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WrappedGraph.class, WrappedLeafVertex.class, WrappedGroup.class, WrappedEdge.class});
            Marshaller u = jc.createMarshaller();
            u.marshal((Object)graph, new File(this.getTopologyLocation()));
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void load(URI source, WrappedGraph graph) {
        String namespace;
        String string = namespace = graph.m_namespace == null ? TOPOLOGY_NAMESPACE_SIMPLE : graph.m_namespace;
        if (this.getVertexNamespace() != namespace) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Creating new vertex provider with namespace {}", (Object)namespace);
            this.m_vertexProvider = new SimpleVertexProvider(namespace);
        }
        if (this.getEdgeNamespace() != namespace) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Creating new edge provider with namespace {}", (Object)namespace);
            this.m_edgeProvider = new SimpleEdgeProvider(namespace);
        }
        this.resetContainer();
        for (WrappedVertex vertex : graph.m_vertices) {
            SimpleGroup newVertex;
            if (vertex.namespace == null) {
                vertex.namespace = this.getVertexNamespace();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on vertex to default: {}", (Object)vertex);
            }
            if (vertex.id == null) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid vertex unmarshalled from {}: {}", (Object)source.toString(), (Object)vertex);
            }
            if (vertex.group) {
                newVertex = new SimpleGroup(vertex.namespace, vertex.id);
                if (vertex.x != null) {
                    newVertex.setX(vertex.x);
                }
                if (vertex.y != null) {
                    newVertex.setY(vertex.y);
                }
            } else {
                newVertex = new SimpleLeafVertex(vertex.namespace, vertex.id, vertex.x, vertex.y);
            }
            newVertex.setIconKey(vertex.iconKey);
            newVertex.setIpAddress(vertex.ipAddr);
            newVertex.setLabel(vertex.label);
            newVertex.setLocked(vertex.locked);
            if (vertex.nodeID != null) {
                newVertex.setNodeID(vertex.nodeID);
            }
            if (!newVertex.equals((Object)vertex.parent)) {
                newVertex.setParent((VertexRef)vertex.parent);
            }
            newVertex.setSelected(vertex.selected);
            newVertex.setStyleName(vertex.styleName);
            newVertex.setTooltipText(vertex.tooltipText);
            this.addVertices(new Vertex[]{newVertex});
        }
        for (WrappedEdge edge : graph.m_edges) {
            if (edge.namespace == null) {
                edge.namespace = this.getEdgeNamespace();
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Setting namespace on edge to default: {}", (Object)edge);
            }
            if (edge.id == null) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Invalid edge unmarshalled from {}: {}", (Object)source.toString(), (Object)edge);
            } else if (edge.id.startsWith("e")) {
                // empty if block
            }
            AbstractEdge newEdge = this.connectVertices(edge.id, (VertexRef)edge.source, (VertexRef)edge.target, edge.namespace);
            newEdge.setLabel(edge.label);
            newEdge.setTooltipText(edge.tooltipText);
        }
        for (WrappedVertex vertex : graph.m_vertices) {
            if (vertex.parent == null || vertex.equals((Object)vertex.parent)) continue;
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Setting parent of " + vertex + " to " + vertex.parent);
            this.setParent((VertexRef)vertex, (VertexRef)vertex.parent);
        }
    }

    public void refresh() {
        try {
            this.load(this.getTopologyLocation());
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public Criteria getDefaultCriteria() {
        return null;
    }

    void load(URI url) throws JAXBException, MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("URI for SimpleGraphProvider configuration must not be null");
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{WrappedGraph.class});
        Unmarshaller u = jc.createUnmarshaller();
        WrappedGraph graph = (WrappedGraph)u.unmarshal(url.toURL());
        this.load(url, graph);
    }

    public void load(String filename) throws MalformedURLException, JAXBException {
        if (filename != null) {
            this.setTopologyLocation(new File(filename).toURI());
        } else {
            this.load(this.getTopologyLocation());
        }
    }
}

