/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareTopologyProvider
extends AbstractTopologyProvider {
    public static final String TOPOLOGY_NAMESPACE_VMWARE = "vmware";
    private static final Logger LOG = LoggerFactory.getLogger(VmwareTopologyProvider.class);
    private static final String SPLIT_REGEXP = " *, *";
    private final NodeDao m_nodeDao;
    private final IpInterfaceDao m_ipInterfaceDao;

    public VmwareTopologyProvider(NodeDao nodeDao, IpInterfaceDao ipInterfaceDao) {
        super(TOPOLOGY_NAMESPACE_VMWARE);
        this.m_nodeDao = Objects.requireNonNull(nodeDao);
        this.m_ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
    }

    public void refresh() {
        this.resetContainer();
        this.getEntities("HostSystem").stream().forEach(e -> this.addHostSystem((OnmsNode)e));
        this.getEntities("VirtualMachine").stream().forEach(e -> this.addVirtualMachine((OnmsNode)e));
    }

    private List<OnmsNode> getEntities(String entityType) {
        List entities = this.m_nodeDao.findAllByVarCharAssetColumn("vmwareManagedEntityType", entityType);
        if (entities.isEmpty()) {
            LOG.info("No entities of type '{}' with defined VMware assets fields found!", (Object)entityType);
        }
        return entities;
    }

    public Defaults getDefaults() {
        return new Defaults().withCriteria(() -> {
            if (this.getVertices(new Criteria[0]).isEmpty()) {
                return Lists.newArrayList();
            }
            return this.getVertices(new Criteria[0]).stream().filter(e -> "vmware.DATACENTER_ICON".equals(e.getIconKey())).map(VertexHopGraphProvider.DefaultVertexHopCriteria::new).collect(Collectors.toList());
        });
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return VmwareTopologyProvider.getSelection((String)TOPOLOGY_NAMESPACE_VMWARE, selectedVertices, (ContentType)type);
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }

    private AbstractVertex createEntityVertex(String vertexId, String vertexName, String iconKey) {
        if (this.containsVertexId(vertexId)) {
            return (AbstractVertex)this.getVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId);
        }
        AbstractVertex vertex = new AbstractVertex(TOPOLOGY_NAMESPACE_VMWARE, vertexId, vertexName);
        vertex.setIconKey(iconKey);
        return vertex;
    }

    private AbstractVertex createDatacenterVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.DATACENTER_ICON");
    }

    private AbstractVertex createNetworkVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.NETWORK_ICON");
    }

    private AbstractVertex createDatastoreVertex(String vertexId, String vertexName) {
        return this.createEntityVertex(vertexId, vertexName, "vmware.DATASTORE_ICON");
    }

    private AbstractVertex createVirtualMachineVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        AbstractVertex vertex = "poweredOn".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_ON") : ("poweredOff".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_OFF") : ("suspended".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_SUSPENDED") : this.createEntityVertex(vertexId, vertexName, "vmware.VIRTUALMACHINE_ICON_UNKNOWN")));
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private AbstractVertex createHostSystemVertex(String vertexId, String vertexName, String primaryInterface, int id, String powerState) {
        AbstractVertex vertex = "poweredOn".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_ON") : ("poweredOff".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_OFF") : ("standBy".equals(powerState) ? this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_STANDBY") : this.createEntityVertex(vertexId, vertexName, "vmware.HOSTSYSTEM_ICON_UNKNOWN")));
        vertex.setIpAddress(primaryInterface);
        vertex.setNodeID(Integer.valueOf(id));
        return vertex;
    }

    private Map<String, ParsedEntity> parseNodeAssets(OnmsNode onmsNode) {
        String vmwareTopologyInfo = onmsNode.getAssetRecord().getVmwareTopologyInfo().trim();
        return Arrays.stream(vmwareTopologyInfo.split(SPLIT_REGEXP)).map(x$0 -> new ParsedEntity((String)x$0)).collect(Collectors.toMap(ParsedEntity::getEntityId, Function.identity()));
    }

    private void addHostSystem(OnmsNode hostSystem) {
        String vmwareManagementServer = hostSystem.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = hostSystem.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareState = hostSystem.getAssetRecord().getVmwareState().trim();
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(hostSystem.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        AbstractVertex hostSystemVertex = this.createHostSystemVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, hostSystem.getLabel(), primaryInterface, hostSystem.getId(), vmwareState);
        this.addVertices(new Vertex[]{hostSystemVertex});
        Map<String, ParsedEntity> parsedEntities = this.parseNodeAssets(hostSystem);
        String datacenterName = parsedEntities.values().stream().filter(e -> "datacenter".equals(e.getEntityType())).findFirst().map(e -> ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName() + " (" + vmwareManagementServer + ")").orElse("Datacenter (" + vmwareManagementServer + ")");
        AbstractVertex datacenterVertex = this.createDatacenterVertex(vmwareManagementServer, datacenterName);
        this.addVertices(new Vertex[]{datacenterVertex});
        if (!hostSystemVertex.equals((Object)datacenterVertex)) {
            this.connectVertices((VertexRef)hostSystemVertex, (VertexRef)datacenterVertex);
        }
        parsedEntities.values().stream().filter(e -> "network".equals(e.getEntityType())).forEach(e -> {
            AbstractVertex networkVertex = this.createNetworkVertex(vmwareManagementServer + "/" + e.getEntityId(), ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName());
            this.addVertices(new Vertex[]{networkVertex});
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + e.getEntityId(), (VertexRef)hostSystemVertex, (VertexRef)networkVertex, this.getNamespace());
        });
        parsedEntities.values().stream().filter(e -> "datastore".equals(e.getEntityType())).forEach(e -> {
            AbstractVertex datastoreVertex = this.createDatastoreVertex(vmwareManagementServer + "/" + e.getEntityId(), ((ParsedEntity)parsedEntities.get(e.getEntityId())).getEntityName());
            this.addVertices(new Vertex[]{datastoreVertex});
            this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + e.getEntityId(), (VertexRef)hostSystemVertex, (VertexRef)datastoreVertex, this.getNamespace());
        });
    }

    private void addVirtualMachine(OnmsNode virtualMachine) {
        Map<String, ParsedEntity> parsedEntities;
        String vmwareHostSystemId;
        String vmwareManagementServer = virtualMachine.getAssetRecord().getVmwareManagementServer().trim();
        String vmwareManagedObjectId = virtualMachine.getAssetRecord().getVmwareManagedObjectId().trim();
        String vmwareState = virtualMachine.getAssetRecord().getVmwareState().trim();
        String primaryInterface = "unknown";
        OnmsIpInterface ipInterface = this.m_ipInterfaceDao.findPrimaryInterfaceByNodeId(virtualMachine.getId());
        if (ipInterface != null) {
            primaryInterface = ipInterface.getIpHostName();
        }
        if ((vmwareHostSystemId = (String)(parsedEntities = this.parseNodeAssets(virtualMachine)).values().stream().filter(e -> "host".equals(e.getEntityType())).findFirst().map(e -> e.getEntityId()).orElse(null)) == null) {
            LOG.warn("Cannot find host system id for virtual machine {}/{}", (Object)vmwareManagementServer, (Object)vmwareManagedObjectId);
        }
        AbstractVertex virtualMachineVertex = this.createVirtualMachineVertex(vmwareManagementServer + "/" + vmwareManagedObjectId, virtualMachine.getLabel(), primaryInterface, virtualMachine.getId(), vmwareState);
        this.addVertices(new Vertex[]{virtualMachineVertex});
        if (!this.containsVertexId(vmwareManagementServer + "/" + vmwareHostSystemId)) {
            LOG.warn("Cannot find associated vertex for host system {}/{}", (Object)vmwareManagementServer, (Object)vmwareHostSystemId);
        }
        this.connectVertices(vmwareManagementServer + "/" + vmwareManagedObjectId + "->" + vmwareManagementServer + "/" + vmwareHostSystemId, (VertexRef)virtualMachineVertex, (VertexRef)this.getVertex(this.getNamespace(), vmwareManagementServer + "/" + vmwareHostSystemId), this.getNamespace());
    }

    private class ParsedEntity {
        private String entityId;
        private String entityName;
        private String entityType;

        public ParsedEntity(String string) {
            String[] splitBySlash = string.split("/");
            this.entityId = splitBySlash[0];
            this.entityType = this.entityId.split("-")[0];
            this.entityName = "unknown";
            if (splitBySlash.length > 1) {
                try {
                    this.entityName = new String(URLDecoder.decode(splitBySlash[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public void setEntityType(String entityType) {
            this.entityType = entityType;
        }
    }

    private static interface Icons {
        public static final String DATACENTER = "vmware.DATACENTER_ICON";
        public static final String DATASTORE = "vmware.DATASTORE_ICON";
        public static final String NETWORK = "vmware.NETWORK_ICON";
        public static final String VIRTUAL_MACHINE_UNKNOWN = "vmware.VIRTUALMACHINE_ICON_UNKNOWN";
        public static final String VIRTUAL_MACHINE_ON = "vmware.VIRTUALMACHINE_ICON_ON";
        public static final String VIRTUAL_MACHINE_OFF = "vmware.VIRTUALMACHINE_ICON_OFF";
        public static final String VIRTUAL_MACHINE_SUSPENDED = "vmware.VIRTUALMACHINE_ICON_SUSPENDED";
        public static final String HOSTSYSTEM_UNKNOWN = "vmware.HOSTSYSTEM_ICON_UNKNOWN";
        public static final String HOSTSYSTEM_ON = "vmware.HOSTSYSTEM_ICON_ON";
        public static final String HOSTSYSTEM_OFF = "vmware.HOSTSYSTEM_ICON_OFF";
        public static final String HOSTSYSTEM_STANDBY = "vmware.HOSTSYSTEM_ICON_STANDBY";
    }
}

