/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.simple.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.opennms.features.topology.api.topo.DefaultMetaInfo;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaInfo;
import org.opennms.features.topology.plugins.topo.simple.SimpleGraphProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class SimpleTopologyFactory
implements ManagedServiceFactory {
    private static final String TOPOLOGY_LOCATION = "topologyLocation";
    private static final String LABEL = "label";
    private BundleContext m_bundleContext;
    private MetaInfo metaInfo = new DefaultMetaInfo();
    private Map<String, SimpleGraphProvider> m_providers = new HashMap<String, SimpleGraphProvider>();
    private Map<String, ServiceRegistration<GraphProvider>> m_registrations = new HashMap<String, ServiceRegistration<GraphProvider>>();

    public void setBundleContext(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
    }

    public String getName() {
        return "This Factory creates Simple Topology Providers";
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            String location = (String)properties.get(TOPOLOGY_LOCATION);
            URI url = new URI(location);
            if (!this.m_providers.containsKey(pid)) {
                SimpleGraphProvider topoProvider = new SimpleGraphProvider();
                topoProvider.setTopologyLocation(url);
                topoProvider.setMetaInfo(this.getMetaInfo());
                this.m_providers.put(pid, topoProvider);
                Hashtable<String, String> metaData = new Hashtable<String, String>();
                ((Dictionary)metaData).put("service.pid", pid);
                if (properties.get(LABEL) != null) {
                    ((Dictionary)metaData).put(LABEL, (String)properties.get(LABEL));
                }
                ServiceRegistration registration = this.m_bundleContext.registerService(GraphProvider.class, (Object)topoProvider, metaData);
                this.m_registrations.put(pid, (ServiceRegistration<GraphProvider>)registration);
            } else {
                this.m_providers.get(pid).setTopologyLocation(url);
                ServiceRegistration<GraphProvider> registration = this.m_registrations.get(pid);
                Hashtable<String, String> metaData = new Hashtable<String, String>();
                ((Dictionary)metaData).put("service.pid", pid);
                if (properties.get(LABEL) != null) {
                    ((Dictionary)metaData).put(LABEL, (String)properties.get(LABEL));
                }
                registration.setProperties(metaData);
            }
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(TOPOLOGY_LOCATION, "Topology location must be a valid URI", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(TOPOLOGY_LOCATION, "Topology location must be a valid URL", (Throwable)e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(TOPOLOGY_LOCATION, "Topology location could not be deserialized", (Throwable)e);
        }
    }

    public void deleted(String pid) {
        ServiceRegistration<GraphProvider> registration = this.m_registrations.remove(pid);
        if (registration != null) {
            registration.unregister();
        }
        this.m_providers.remove(pid);
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }
}

