/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.sfree.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFreeTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SFreeTopologyProvider.class);
    private static final String TOPOLOGY_NAMESPACE_SFREE = "sfree";
    private int m_nodeCount = 200;
    private double m_connectedness = 4.0;
    private Type type = Type.BarabasiAlbert;

    public SFreeTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_SFREE);
    }

    public int getNodeCount() {
        return this.m_nodeCount;
    }

    public void setNodeCount(int nodeCount) {
        this.m_nodeCount = nodeCount;
    }

    public double getConnectedness() {
        return this.m_connectedness;
    }

    public void setConnectedness(double connectedness) {
        this.m_connectedness = connectedness;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public void refresh() {
        this.clearVertices();
        this.clearEdges();
        switch (this.type) {
            case ErdosRenis: {
                this.createERRandomTopology(this.m_nodeCount, this.m_connectedness);
                break;
            }
            case BarabasiAlbert: {
                this.createBARandomTopology(this.m_nodeCount, this.m_connectedness);
                break;
            }
            default: {
                throw new IllegalStateException("Type not supported");
            }
        }
    }

    public Defaults getDefaults() {
        return new Defaults();
    }

    private void createBARandomTopology(int numberOfNodes, double averageNumberofNeighboors) {
        SimpleLeafVertex vertexi;
        HashMap<Integer, SimpleLeafVertex> nodes = new HashMap<Integer, SimpleLeafVertex>();
        ArrayList<AbstractEdge> edges = new ArrayList<AbstractEdge>();
        int i = 0;
        while ((double)i < 2.0 * averageNumberofNeighboors) {
            LOG.debug("Creating First Cluster from: {}", (Object)i);
            int j = (i + 1) % (int)Math.round(2.0 * averageNumberofNeighboors);
            vertexi = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i), Integer.valueOf(0), Integer.valueOf(0));
            vertexi.setIconKey("sfree.system");
            vertexi.setLabel("BarabasiAlbertNode" + i);
            if (!nodes.containsKey(i)) {
                nodes.put(i, vertexi);
                LOG.debug("Added Node: {}", (Object)vertexi.getId());
            }
            SimpleLeafVertex vertexj = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(j), Integer.valueOf(0), Integer.valueOf(0));
            vertexj.setIconKey("sfree.system");
            vertexj.setLabel("BarabasiAlbertNode" + j);
            if (!nodes.containsKey(j)) {
                nodes.put(j, vertexj);
                LOG.debug("Added Node: {}", (Object)vertexj.getId());
            }
            String edgeId = "link:" + i + "-" + j;
            SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(i)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(i));
            SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(j)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(j));
            edges.add(new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target));
            LOG.debug("Added Link: {}", (Object)edgeId);
            ++i;
        }
        Random r = new Random(new Date().getTime());
        for (int i2 = (int)Math.floor(2.0 * averageNumberofNeighboors); i2 < numberOfNodes; ++i2) {
            vertexi = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i2), Integer.valueOf(0), Integer.valueOf(0));
            vertexi.setIconKey("sfree.system");
            vertexi.setLabel("BarabasiAlbertNode" + i2);
            nodes.put(i2, vertexi);
            LOG.debug("Adding Node: {}", (Object)i2);
            int times = 0;
            while ((double)times < averageNumberofNeighboors) {
                double d = r.nextDouble() * (double)nodes.size();
                LOG.debug("Generated random position: {}", (Object)d);
                Long j = (long)d;
                LOG.debug("Try Adding edge: {}--->{}", (Object)j, (Object)i2);
                String edgeId = "link:" + i2 + "-" + j.intValue();
                SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(i2)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(i2));
                SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(j.intValue())).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(j.intValue()));
                AbstractEdge edge = new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target);
                if (i2 != j.intValue()) {
                    edges.add(edge);
                }
                ++times;
            }
        }
        this.addVertices(nodes.values().toArray(new Vertex[0]));
        this.addEdges(edges.toArray(new Edge[0]));
    }

    private void createERRandomTopology(int numberOfNodes, double averageNumberofNeighboors) {
        HashMap<Integer, SimpleLeafVertex> nodes = new HashMap<Integer, SimpleLeafVertex>();
        ArrayList<AbstractEdge> edges = new ArrayList<AbstractEdge>();
        Integer i = 0;
        while (i < numberOfNodes) {
            Object vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_SFREE, Integer.toString(i), Integer.valueOf(0), Integer.valueOf(0));
            vertex.setIconKey("sfree.system");
            vertex.setLabel("ErdosReniyNode" + i);
            nodes.put(i, (SimpleLeafVertex)vertex);
            vertex = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        Double z = 0.5 * (double)(numberOfNodes - 1);
        Random r = new Random(new Date().getTime());
        Integer start = 0;
        while (start < numberOfNodes) {
            Integer n;
            Integer end = start + 1;
            while (end < numberOfNodes) {
                if (z * r.nextDouble() < averageNumberofNeighboors) {
                    String edgeId = "link:" + start + "-" + end;
                    SimpleConnector source = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(start)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(start));
                    SimpleConnector target = new SimpleConnector(TOPOLOGY_NAMESPACE_SFREE, ((SimpleLeafVertex)nodes.get(end)).getId() + "-" + edgeId + "-connector", (VertexRef)nodes.get(end));
                    edges.add(new AbstractEdge(TOPOLOGY_NAMESPACE_SFREE, edgeId, source, target));
                }
                n = end;
                Integer n2 = end = Integer.valueOf(end + 1);
            }
            Integer n3 = start;
            n = start = Integer.valueOf(start + 1);
        }
        this.addVertices(nodes.values().toArray(new Vertex[0]));
        this.addEdges(edges.toArray(new Edge[0]));
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return false;
    }

    public static enum Type {
        ErdosRenis,
        BarabasiAlbert;

    }
}

