/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleConnector;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdPort;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;

public class LinkdEdge
extends AbstractEdge
implements Edge {
    private final LinkdPort m_sourcePort;
    private final LinkdPort m_targetPort;
    private final ProtocolSupported m_discoveredBy;

    public static LinkdEdge create(String id, LinkdPort sourceport, LinkdPort targetport, ProtocolSupported discoveredBy) {
        SimpleConnector source = new SimpleConnector("nodes", sourceport.getVertex().getId() + "-" + id + "-connector", (VertexRef)sourceport.getVertex());
        SimpleConnector target = new SimpleConnector("nodes", targetport.getVertex().getId() + "-" + id + "-connector", (VertexRef)targetport.getVertex());
        LinkdEdge edge = new LinkdEdge(id, sourceport, targetport, source, target, discoveredBy);
        return edge;
    }

    public LinkdEdge(String id, LinkdPort source, LinkdPort target, ProtocolSupported discoveredBy) {
        super("nodes", id, (VertexRef)source.getVertex(), (VertexRef)target.getVertex());
        this.m_discoveredBy = discoveredBy;
        this.m_sourcePort = source;
        this.m_targetPort = target;
    }

    public LinkdEdge(String id, LinkdPort sourcePort, LinkdPort targetPort, SimpleConnector source, SimpleConnector target, ProtocolSupported discoveredBy) {
        super("nodes", id, source, target);
        this.m_sourcePort = sourcePort;
        this.m_targetPort = targetPort;
        this.m_discoveredBy = discoveredBy;
    }

    private LinkdEdge(LinkdEdge edgeToClone) {
        this(edgeToClone.getId(), edgeToClone.getSourcePort().clone(), edgeToClone.getTargetPort().clone(), edgeToClone.getSource().clone(), edgeToClone.getTarget().clone(), edgeToClone.getDiscoveredBy());
        this.setLabel(edgeToClone.getLabel());
        this.setStyleName(edgeToClone.getStyleName());
        this.setTooltipText(edgeToClone.getTooltipText());
    }

    public LinkdEdge clone() {
        return new LinkdEdge(this);
    }

    public String getTooltipText() {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append("<p>");
        tooltipText.append("discovery by: ");
        tooltipText.append(this.m_discoveredBy.toString());
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(this.m_sourcePort.getToolTipText());
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(this.m_targetPort.getToolTipText());
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    public ProtocolSupported getDiscoveredBy() {
        return this.m_discoveredBy;
    }

    public LinkdPort getSourcePort() {
        return this.m_sourcePort;
    }

    public LinkdPort getTargetPort() {
        return this.m_targetPort;
    }
}

