/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.CollapsibleGraph;
import org.opennms.features.topology.api.topo.CollapsibleRef;
import org.opennms.features.topology.api.topo.CollapsibleVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;
import org.slf4j.LoggerFactory;

public class LinkdStatusProvider
implements StatusProvider {
    private final AlarmDao m_alarmDao;

    public String getNamespace() {
        return "nodes";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace() != null && this.getNamespace().equals(namespace);
    }

    public LinkdStatusProvider(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public Map<VertexRef, Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        HashMap<VertexRef, Status> returnMap = new HashMap<VertexRef, Status>();
        List<VertexRef> nodeRefs = LinkdStatusProvider.getNodeVertexRefs(graph, vertices, criteria);
        List<VertexRef> otherRefs = LinkdStatusProvider.getOtherVertexRefs(vertices);
        Map<Integer, VertexRef> nodeIdMap = LinkdStatusProvider.extractNodeIds(nodeRefs);
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        for (Integer eachNodeId : nodeIdMap.keySet()) {
            AlarmSummary summary = nodeIdToAlarmSummaryMap.get(eachNodeId);
            AlarmStatus status = summary == null ? LinkdStatusProvider.createDefaultStatus() : LinkdStatusProvider.createStatus(summary);
            VertexRef ref = nodeIdMap.get(eachNodeId);
            returnMap.put(ref, (Status)status);
            LoggerFactory.getLogger(this.getClass()).debug("Status for node '{}' with id '{}' is: {}", new Object[]{ref.getLabel(), ref.getId(), status});
        }
        for (VertexRef eachRef : otherRefs) {
            if (LinkdStatusProvider.isCollapsible(eachRef)) {
                ArrayList<AlarmSummary> alarmSummariesForGroup = new ArrayList<AlarmSummary>();
                List children = new CollapsibleGraph(graph).getVertices((CollapsibleRef)eachRef, criteria);
                for (Vertex eachChildren : children) {
                    AlarmSummary eachChildrenAlarmSummary = nodeIdToAlarmSummaryMap.get(eachChildren.getNodeID());
                    if (eachChildrenAlarmSummary == null) continue;
                    alarmSummariesForGroup.add(eachChildrenAlarmSummary);
                }
                AlarmStatus groupStatus = LinkdStatusProvider.calculateAlarmStatusForGroup(alarmSummariesForGroup);
                returnMap.put(eachRef, (Status)groupStatus);
                continue;
            }
            returnMap.put(eachRef, (Status)LinkdStatusProvider.createDefaultStatus());
        }
        return returnMap;
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        HashMap<Integer, AlarmSummary> resultMap = new HashMap<Integer, AlarmSummary>();
        List alarmSummaries = this.m_alarmDao.getNodeAlarmSummariesIncludeAcknowledgedOnes(new ArrayList<Integer>(nodeIds));
        for (AlarmSummary eachSummary : alarmSummaries) {
            resultMap.put(eachSummary.getNodeId(), eachSummary);
        }
        return resultMap;
    }

    private static AlarmStatus createStatus(AlarmSummary summary) {
        return new AlarmStatus(summary.getMaxSeverity().getLabel(), summary.getAlarmCount());
    }

    private static Map<Integer, VertexRef> extractNodeIds(Collection<VertexRef> inputList) {
        HashMap<Integer, VertexRef> vertexRefToNodeIdMap = new HashMap<Integer, VertexRef>();
        for (VertexRef eachRef : inputList) {
            if (!"nodes".equals(eachRef.getNamespace())) continue;
            try {
                Integer nodeId = Integer.parseInt(eachRef.getId());
                if (nodeId == null) continue;
                vertexRefToNodeIdMap.put(nodeId, eachRef);
            }
            catch (NumberFormatException nfe) {
                LoggerFactory.getLogger(LinkdStatusProvider.class).warn("Could not parse id '{}' of vertex '{}' as integer.", (Object)eachRef.getId(), (Object)eachRef);
            }
        }
        return vertexRefToNodeIdMap;
    }

    private static List<VertexRef> getNodeVertexRefs(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if (!"nodes".equals(eachRef.getNamespace())) continue;
            if (LinkdStatusProvider.isCollapsible(eachRef)) {
                LinkdStatusProvider.addChildrenRecursively(graph, (CollapsibleRef)eachRef, returnList, criteria);
                continue;
            }
            if (returnList.contains(eachRef)) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static List<VertexRef> getOtherVertexRefs(Collection<VertexRef> vertices) {
        ArrayList<VertexRef> returnList = new ArrayList<VertexRef>();
        for (VertexRef eachRef : vertices) {
            if ("nodes".equals(eachRef.getNamespace())) continue;
            returnList.add(eachRef);
        }
        return returnList;
    }

    private static void addChildrenRecursively(BackendGraph graph, CollapsibleRef collapsibleRef, Collection<VertexRef> vertexRefs, Criteria[] criteria) {
        List vertices = new CollapsibleGraph(graph).getVertices(collapsibleRef, criteria);
        for (Vertex vertex : vertices) {
            if (!LinkdStatusProvider.isCollapsible((VertexRef)vertex)) {
                if (vertexRefs.contains(vertex)) continue;
                vertexRefs.add((VertexRef)vertex);
                continue;
            }
            LinkdStatusProvider.addChildrenRecursively(graph, collapsibleRef, vertexRefs, criteria);
        }
    }

    private static boolean isCollapsible(VertexRef vertexRef) {
        return vertexRef instanceof CollapsibleVertex;
    }

    private static AlarmStatus createDefaultStatus() {
        return new AlarmStatus(OnmsSeverity.NORMAL.getLabel(), 0L);
    }

    private static AlarmStatus calculateAlarmStatusForGroup(List<AlarmSummary> alarmSummaries) {
        if (!alarmSummaries.isEmpty()) {
            Collections.sort(alarmSummaries, new Comparator<AlarmSummary>(){

                @Override
                public int compare(AlarmSummary o1, AlarmSummary o2) {
                    return o1.getMaxSeverity().compareTo((Enum)o2.getMaxSeverity());
                }
            });
            OnmsSeverity severity = alarmSummaries.get(0).getMaxSeverity();
            int count = 0;
            for (AlarmSummary eachSummary : alarmSummaries) {
                count = (int)((long)count + eachSummary.getAlarmCount());
            }
            return new AlarmStatus(severity.getLabel(), count);
        }
        return LinkdStatusProvider.createDefaultStatus();
    }

    private static class AlarmStatus
    extends DefaultStatus {
        public AlarmStatus(String label, long count) {
            super(label, count);
        }
    }
}

