/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.topo.EdgeProvider;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;

public class LinkdEdgeStatusProvider
implements EdgeStatusProvider {
    private AlarmDao m_alarmDao;

    public String getNamespace() {
        return "nodes";
    }

    public Map<EdgeRef, Status> getStatusForEdges(EdgeProvider edgeProvider, Collection<EdgeRef> edges, org.opennms.features.topology.api.topo.Criteria[] criteria) {
        LinkedHashMap<EdgeRef, Status> retVal = new LinkedHashMap<EdgeRef, Status>();
        block0: for (EdgeRef edgeRef : edges) {
            LinkdEdge edge = (LinkdEdge)edgeProvider.getEdge(edgeRef);
            for (OnmsAlarm alarm : this.getLinkdEdgeDownAlarms()) {
                if (alarm.getNode().getId() == null || alarm.getIfIndex() == null) continue;
                int alarmnodeid = alarm.getNode().getId();
                if (edge.getSourcePort().getVertex().getNodeID() != null && edge.getSourcePort().getVertex().getNodeID() == alarmnodeid && edge.getSourcePort().getIfIndex() != null && edge.getSourcePort().getIfIndex().intValue() == alarm.getIfIndex().intValue()) {
                    retVal.put(edgeRef, new LinkdEdgeStatus(alarm));
                    continue block0;
                }
                if (edge.getTargetPort().getVertex().getNodeID() == null || edge.getTargetPort().getVertex().getNodeID() != alarmnodeid || edge.getTargetPort().getIfIndex() == null || edge.getTargetPort().getIfIndex().intValue() != alarm.getIfIndex().intValue()) continue;
                retVal.put(edgeRef, new LinkdEdgeStatus(alarm));
                continue block0;
            }
            retVal.put(edgeRef, new LinkdEdgeStatus("up"));
        }
        return retVal;
    }

    public boolean contributesTo(String namespace) {
        return namespace.equals("nodes");
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    protected List<OnmsAlarm> getLinkdEdgeDownAlarms() {
        Criteria criteria = new Criteria(OnmsAlarm.class);
        criteria.addRestriction((Restriction)new EqRestriction("uei", (Object)"uei.opennms.org/internal/topology/linkDown"));
        criteria.addRestriction((Restriction)new NeRestriction("severity", (Object)OnmsSeverity.CLEARED));
        return this.getAlarmDao().findMatching(criteria);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public static class LinkdEdgeStatus
    implements Status {
        private final String m_status;

        public LinkdEdgeStatus(String status) {
            this.m_status = status;
        }

        public LinkdEdgeStatus(OnmsAlarm summary) {
            this.m_status = summary.getUei().equals("uei.opennms.org/internal/topology/linkDown") ? "down" : "up";
        }

        public String computeStatus() {
            return this.m_status.toLowerCase();
        }

        public Map<String, String> getStatusProperties() {
            LinkedHashMap<String, String> statusMap = new LinkedHashMap<String, String>();
            statusMap.put("status", this.m_status);
            return statusMap;
        }

        public Map<String, String> getStyleProperties() {
            return Maps.newHashMap();
        }

        public String toString() {
            return "LinkdEdgeStatus[" + this.m_status + "]";
        }
    }
}

