/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdPort;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdSelectionAware;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdVertex;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyException;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    private OnmsTopologyDao m_onmsTopologyDao;
    private final Timer m_loadFullTimer;
    private final Timer m_loadLldpLinksTimer;
    private final Timer m_loadOspfLinksTimer;
    private final Timer m_loadCdpLinksTimer;
    private final Timer m_loadIsisLinksTimer;
    private final Timer m_loadBridgeLinksTimer;
    private final Timer m_loadVerticesTimer;
    private final Timer m_loadEdgesTimer;
    private SelectionAware selectionAwareDelegate = new LinkdSelectionAware();

    public LinkdTopologyProvider(MetricRegistry registry) {
        super("nodes");
        Objects.requireNonNull(registry);
        this.m_loadFullTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "full"}));
        this.m_loadLldpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "lldp"}));
        this.m_loadOspfLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "ospf"}));
        this.m_loadCdpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "cdp"}));
        this.m_loadIsisLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "isis"}));
        this.m_loadBridgeLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "bridge"}));
        this.m_loadVerticesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "vertices", "none"}));
        this.m_loadEdgesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "edges", "none"}));
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.selectionAwareDelegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.selectionAwareDelegate.contributesTo(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEdges() {
        Timer.Context context = this.m_loadLldpLinksTimer.time();
        try {
            this.loadTopology(ProtocolSupported.LLDP);
            LOG.info("loadEdges: LldpLink loaded");
        }
        catch (OnmsTopologyException e) {
            LOG.info("loadEdges: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Loading LldpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadOspfLinksTimer.time();
        try {
            this.loadTopology(ProtocolSupported.OSPF);
            LOG.info("loadEdges: OspfLink loaded");
        }
        catch (OnmsTopologyException e) {
            LOG.info("loadEdges: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Loading OspfLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadCdpLinksTimer.time();
        try {
            this.loadTopology(ProtocolSupported.CDP);
            LOG.info("loadEdges: CdpLink loaded");
        }
        catch (OnmsTopologyException e) {
            LOG.info("loadEdges: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Loading CdpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIsisLinksTimer.time();
        try {
            this.loadTopology(ProtocolSupported.ISIS);
            LOG.info("loadEdges: IsIsLink loaded");
        }
        catch (OnmsTopologyException e) {
            LOG.info("loadEdges: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Exception getting IsIs link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadBridgeLinksTimer.time();
        try {
            this.loadTopology(ProtocolSupported.BRIDGE);
            LOG.info("loadEdges: BridgeLink loaded");
        }
        catch (OnmsTopologyException e) {
            LOG.info("loadEdges: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error("Loading BridgeLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
    }

    private void loadTopology(ProtocolSupported protocol) throws OnmsTopologyException {
        OnmsTopology topology = this.m_onmsTopologyDao.getTopology(protocol.name());
        HashMap vmap = new HashMap();
        topology.getVertices().stream().forEach(tvertex -> {
            LinkdVertex vertex = (LinkdVertex)this.getVertex("nodes", tvertex.getId());
            if (vertex == null) {
                vertex = LinkdVertex.create(tvertex);
                this.addVertices(new Vertex[]{vertex});
            }
            vertex.getProtocolSupported().add(protocol);
            vmap.put(vertex.getId(), vertex);
        });
        topology.getEdges().stream().forEach(tedge -> this.addEdges(new Edge[]{LinkdEdge.create(tedge.getId(), LinkdPort.create(tedge.getSource(), (LinkdVertex)((Object)((Object)vmap.get(tedge.getSource().getVertex().getId())))), LinkdPort.create(tedge.getTarget(), (LinkdVertex)((Object)((Object)vmap.get(tedge.getTarget().getVertex().getId())))), protocol)}));
    }

    public Vertex getDefaultVertex() {
        OnmsTopologyVertex node = null;
        try {
            node = this.m_onmsTopologyDao.getTopology(ProtocolSupported.NODES.name()).getDefaultVertex();
        }
        catch (OnmsTopologyException e) {
            LOG.error("getDefaultVertex: no default node found: {}", (Object)e.getMessage());
            return null;
        }
        if (node == null) {
            LOG.info("getDefaultVertex: no default node found!");
            return null;
        }
        LOG.info("getDefaultVertex: default node found: [{}]:{}", (Object)node.getId(), (Object)node.getLabel());
        return this.getVertex("nodes", node.getId());
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(1).withPreferredLayout("D3 Layout").withCriteria(() -> {
            Vertex defaultVertex = this.getDefaultVertex();
            if (defaultVertex != null) {
                LOG.info("getDefaults: default vertex found: [{}]:{}", (Object)defaultVertex.getId(), (Object)defaultVertex.getLabel());
                return Lists.newArrayList((Object[])new Criteria[]{LinkdHopCriteria.createCriteria(defaultVertex.getId(), defaultVertex.getLabel())});
            }
            LOG.info("getDefaults: default vertex not found");
            return Lists.newArrayList();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        Timer.Context vcontext = this.m_loadVerticesTimer.time();
        try {
            for (OnmsTopologyVertex tvertex : this.m_onmsTopologyDao.getTopology(ProtocolSupported.NODES.name()).getVertices()) {
                this.addVertices(new Vertex[]{LinkdVertex.create(tvertex)});
            }
            LOG.info("refresh: Loaded Vertices");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Vertices: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadEdgesTimer.time();
        try {
            this.loadEdges();
            LOG.info("refresh: Loaded Edges");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Edges: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
    }

    public void refresh() {
        Timer.Context context = this.m_loadFullTimer.time();
        try {
            this.resetContainer();
            this.doRefresh();
        }
        finally {
            context.stop();
        }
        LOG.info("refresh: Found {} groups", (Object)this.getGroups().size());
        LOG.info("refresh: Found {} vertices", (Object)this.getVerticesWithoutGroups().size());
        LOG.info("refresh: Found {} edges", (Object)this.getEdges(new Criteria[0]).size());
    }

    public OnmsTopologyDao getOnmsTopologyDao() {
        return this.m_onmsTopologyDao;
    }

    public void setOnmsTopologyDao(OnmsTopologyDao onmsTopologyDao) {
        this.m_onmsTopologyDao = onmsTopologyDao;
    }
}

