/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.CompositeKey;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdSelectionAware;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdVertex;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.enlinkd.model.CdpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.model.IsIsElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityCache;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyException;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.BroadcastDomain;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    private TransactionOperations m_transactionOperations;
    private NodeDao m_nodeDao;
    private TopologyEntityCache m_topologyEntityCache;
    private FilterManager m_filterManager;
    private BridgeTopologyService m_bridgeTopologyService;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private Map<Integer, IpInterfaceTopologyEntity> m_nodeToOnmsIpPrimaryMap = new HashMap<Integer, IpInterfaceTopologyEntity>();
    private Map<Integer, Map<Integer, SnmpInterfaceTopologyEntity>> m_nodeToOnmsSnmpMap = new HashMap<Integer, Map<Integer, SnmpInterfaceTopologyEntity>>();
    private Map<String, Integer> m_macToNodeidMap = new HashMap<String, Integer>();
    private Map<String, IpInterfaceTopologyEntity> m_macToOnmsIpMap = new HashMap<String, IpInterfaceTopologyEntity>();
    private Map<String, SnmpInterfaceTopologyEntity> m_macToOnmsSnmpMap = new HashMap<String, SnmpInterfaceTopologyEntity>();
    private final Timer m_loadFullTimer;
    private final Timer m_loadIpInterfacesTimer;
    private final Timer m_loadSnmpInterfacesTimer;
    private final Timer m_loadIpNetToMediaTimer;
    private final Timer m_loadLldpLinksTimer;
    private final Timer m_loadOspfLinksTimer;
    private final Timer m_loadCdpLinksTimer;
    private final Timer m_loadIsisLinksTimer;
    private final Timer m_loadBridgeLinksTimer;
    private final Timer m_loadVerticesTimer;
    private final Timer m_loadEdgesTimer;
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    private SelectionAware selectionAwareDelegate = new LinkdSelectionAware();

    static final String getEdgeId(AbstractVertex vertex, BridgePort bp) {
        return vertex.getId() + "|" + bp.getNodeId() + ":" + bp.getBridgePort();
    }

    static final String getEdgeId(AbstractVertex vertex, String mac) {
        return vertex.getId() + "|" + mac;
    }

    static final String getEdgeId(SharedSegment segment) throws BridgeTopologyException {
        return segment.getDesignatedBridge() + ":" + segment.getDesignatedPort().getBridgePort();
    }

    static final String getDefaultEdgeId(int sourceId, int targetId) {
        return Math.min(sourceId, targetId) + "|" + Math.max(sourceId, targetId);
    }

    static final String getEdgeId(BridgePort sourcebp, BridgePort targetbp) {
        if (sourcebp.getNodeId() < targetbp.getNodeId()) {
            return sourcebp.getNodeId() + ":" + sourcebp.getBridgePort() + "|" + targetbp.getNodeId() + ":" + targetbp.getBridgePort();
        }
        return targetbp.getNodeId() + ":" + targetbp.getBridgePort() + "|" + sourcebp.getNodeId() + ":" + sourcebp.getBridgePort();
    }

    static final String getEdgeId(BridgePort sourcebp, String targetmac) {
        return sourcebp.getNodeId() + ":" + sourcebp.getBridgePort() + "|" + targetmac;
    }

    public LinkdTopologyProvider(MetricRegistry registry) {
        super(TOPOLOGY_NAMESPACE_LINKD);
        Objects.requireNonNull(registry);
        this.m_loadFullTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "full"}));
        this.m_loadIpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipinterfaces"}));
        this.m_loadSnmpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "snmpinterfaces"}));
        this.m_loadIpNetToMediaTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipnettomedia"}));
        this.m_loadLldpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "lldp"}));
        this.m_loadOspfLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "ospf"}));
        this.m_loadCdpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "cdp"}));
        this.m_loadIsisLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "isis"}));
        this.m_loadBridgeLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "bridge"}));
        this.m_loadVerticesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "vertices", "none"}));
        this.m_loadEdgesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "edges", "none"}));
    }

    private SnmpInterfaceTopologyEntity getSnmpInterface(Integer nodeid, Integer ifindex) {
        if (this.m_nodeToOnmsSnmpMap.containsKey(nodeid) && this.m_nodeToOnmsSnmpMap.get(nodeid).containsKey(ifindex)) {
            return this.m_nodeToOnmsSnmpMap.get(nodeid).get(ifindex);
        }
        return new SnmpInterfaceTopologyEntity(null, ifindex, "No Interface Found", Long.valueOf(0L), nodeid);
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.selectionAwareDelegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.selectionAwareDelegate.contributesTo(type);
    }

    protected void connectVertices(String id, AbstractVertex sourceV, AbstractVertex targetV, SnmpInterfaceTopologyEntity sourceinterface, SnmpInterfaceTopologyEntity targetInterface, String sourceAddr, String targetAddr, ProtocolSupported discoveredBy) {
        this.addEdges(new Edge[]{LinkdEdge.create(id, sourceV, targetV, sourceinterface, targetInterface, sourceAddr, targetAddr, discoveredBy)});
    }

    private void loadVertices() {
        for (NodeTopologyEntity nodeTopologyEntity : this.m_topologyEntityCache.getNodeTopolgyEntities()) {
            IpInterfaceTopologyEntity primary = this.m_nodeToOnmsIpPrimaryMap.get(nodeTopologyEntity.getId());
            this.addVertices(new Vertex[]{LinkdVertex.create(nodeTopologyEntity, primary)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEdges() {
        Timer.Context context = this.m_loadLldpLinksTimer.time();
        try {
            this.getLldpLinks();
            LOG.info("loadEdges: LldpLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading LldpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadOspfLinksTimer.time();
        try {
            this.getOspfLinks();
            LOG.info("loadEdges: OspfLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading OspfLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadCdpLinksTimer.time();
        try {
            this.getCdpLinks();
            LOG.info("loadEdges: CdpLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading CdpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIsisLinksTimer.time();
        try {
            this.getIsIsLinks();
            LOG.info("loadEdges: IsIsLink loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting IsIs link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadBridgeLinksTimer.time();
        try {
            this.getBridgeLinks();
            LOG.info("loadEdges: BridgeLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading BridgeLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
    }

    private void getLldpLinks() {
        List allLinks = this.m_topologyEntityCache.getLldpLinkTopologyEntities();
        HashMap<Integer, LldpElementTopologyEntity> nodelldpelementidMap = new HashMap<Integer, LldpElementTopologyEntity>();
        HashMap<Integer, LinkdVertex> nodeVertexMap = new HashMap<Integer, LinkdVertex>();
        for (LldpElementTopologyEntity lldpelement : this.m_topologyEntityCache.getLldpElementTopologyEntities()) {
            nodelldpelementidMap.put(lldpelement.getNodeId(), lldpelement);
            LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, lldpelement.getNodeIdAsString());
            vertex.getProtocolSupported().add(ProtocolSupported.LLDP);
            nodeVertexMap.put(lldpelement.getNodeId(), vertex);
            System.err.println(vertex.getId());
        }
        List<Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> matchedLinks = this.matchLldpLinks(nodelldpelementidMap, allLinks);
        for (Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity> pair : matchedLinks) {
            LldpLinkTopologyEntity sourceLink = (LldpLinkTopologyEntity)pair.getLeft();
            LldpLinkTopologyEntity targetLink = (LldpLinkTopologyEntity)pair.getRight();
            LinkdVertex source = (LinkdVertex)((Object)nodeVertexMap.get(sourceLink.getNodeId()));
            LinkdVertex target = (LinkdVertex)((Object)nodeVertexMap.get(targetLink.getNodeId()));
            SnmpInterfaceTopologyEntity sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNodeId(), sourceLink.getLldpPortIfindex());
            SnmpInterfaceTopologyEntity targetSnmpInterface = this.getSnmpInterface(targetLink.getNodeId(), targetLink.getLldpPortIfindex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, sourceLink.getLldpPortDescr(), targetLink.getLldpPortDescr(), ProtocolSupported.LLDP);
        }
    }

    List<Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> matchLldpLinks(Map<Integer, LldpElementTopologyEntity> nodelldpelementidMap, List<LldpLinkTopologyEntity> allLinks) {
        ArrayList<Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> results = new ArrayList<Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity>>();
        HashMap<CompositeKey, LldpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, LldpLinkTopologyEntity>();
        for (LldpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getLldpRemChassisId(), nodelldpelementidMap.get(targetLink.getNodeId()).getLldpChassisId(), targetLink.getLldpPortId(), targetLink.getLldpPortIdSubType(), targetLink.getLldpRemPortId(), targetLink.getLldpRemPortIdSubType());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLinkTopologyEntity sourceLink : allLinks) {
            CompositeKey key;
            LldpLinkTopologyEntity targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            String sourceLldpChassisId = nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId();
            if (sourceLldpChassisId.equals(sourceLink.getLldpRemChassisId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getLldpLinks: self link not adding source: {}", (Object)sourceLink);
                }
                parsed.add(sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: source: {}", (Object)sourceLink);
            }
            if ((targetLink = (LldpLinkTopologyEntity)targetLinkMap.get(key = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpRemPortId(), sourceLink.getLldpRemPortIdSubType(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType()))) == null) {
                LOG.debug("getLldpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: lldp: {} target: {}", (Object)sourceLink.getLldpRemChassisId(), (Object)targetLink);
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add((Pair<LldpLinkTopologyEntity, LldpLinkTopologyEntity>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getOspfLinks() {
        List allLinks = this.m_topologyEntityCache.getOspfLinkTopologyEntities();
        List<Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> matchedLinks = this.matchOspfLinks(allLinks);
        for (Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity> pair : matchedLinks) {
            OspfLinkTopologyEntity sourceLink = (OspfLinkTopologyEntity)pair.getLeft();
            OspfLinkTopologyEntity targetLink = (OspfLinkTopologyEntity)pair.getRight();
            LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNodeIdAsString());
            source.getProtocolSupported().add(ProtocolSupported.OSPF);
            LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNodeIdAsString());
            target.getProtocolSupported().add(ProtocolSupported.OSPF);
            SnmpInterfaceTopologyEntity sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNodeId(), sourceLink.getOspfIfIndex());
            SnmpInterfaceTopologyEntity targetSnmpInterface = this.getSnmpInterface(targetLink.getNodeId(), targetLink.getOspfIfIndex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, InetAddressUtils.str((InetAddress)targetLink.getOspfRemIpAddr()), InetAddressUtils.str((InetAddress)sourceLink.getOspfRemIpAddr()), ProtocolSupported.OSPF);
        }
    }

    List<Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> matchOspfLinks(List<OspfLinkTopologyEntity> allLinks) {
        ArrayList<Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> results = new ArrayList<Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity>>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        HashMap<CompositeKey, OspfLinkTopologyEntity> targetLinks = new HashMap<CompositeKey, OspfLinkTopologyEntity>();
        for (OspfLinkTopologyEntity targetLink : allLinks) {
            targetLinks.put(new CompositeKey(targetLink.getOspfIpAddr(), targetLink.getOspfRemIpAddr()), targetLink);
        }
        for (OspfLinkTopologyEntity sourceLink : allLinks) {
            OspfLinkTopologyEntity targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            parsed.add(sourceLink.getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOspfLinks: source: {}", (Object)sourceLink);
            }
            if ((targetLink = (OspfLinkTopologyEntity)targetLinks.get(new CompositeKey(sourceLink.getOspfRemIpAddr(), sourceLink.getOspfIpAddr()))) == null) {
                LOG.debug("getOspfLinks: cannot find target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || parsed.contains(targetLink.getId())) continue;
            LOG.debug("getOspfLinks: target: {}", (Object)targetLink);
            parsed.add(targetLink.getId());
            results.add((Pair<OspfLinkTopologyEntity, OspfLinkTopologyEntity>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getCdpLinks() {
        List cdpElements = this.m_topologyEntityCache.getCdpElementTopologyEntities();
        List allLinks = this.m_topologyEntityCache.getCdpLinkTopologyEntities();
        List<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> matchedCdpLinks = this.matchCdpLinks(cdpElements, allLinks);
        for (Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity> pair : matchedCdpLinks) {
            this.connectCdpLinkPair(pair);
        }
    }

    private void connectCdpLinkPair(Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity> pair) {
        CdpLinkTopologyEntity sourceLink = (CdpLinkTopologyEntity)pair.getLeft();
        CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)pair.getRight();
        LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNodeIdAsString());
        source.getProtocolSupported().add(ProtocolSupported.CDP);
        LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNodeIdAsString());
        target.getProtocolSupported().add(ProtocolSupported.CDP);
        SnmpInterfaceTopologyEntity sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNodeId(), sourceLink.getCdpCacheIfIndex());
        SnmpInterfaceTopologyEntity targetSnmpInterface = this.getSnmpInterface(targetLink.getNodeId(), targetLink.getCdpCacheIfIndex());
        this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, targetLink.getCdpCacheAddress(), sourceLink.getCdpCacheAddress(), ProtocolSupported.CDP);
    }

    List<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> matchCdpLinks(List<CdpElementTopologyEntity> cdpElements, List<CdpLinkTopologyEntity> allLinks) {
        HashMap<Integer, CdpElementTopologyEntity> cdpelementmap = new HashMap<Integer, CdpElementTopologyEntity>();
        for (CdpElementTopologyEntity cdpElementTopologyEntity : cdpElements) {
            cdpelementmap.put(cdpElementTopologyEntity.getNodeId(), cdpElementTopologyEntity);
        }
        HashMap<CompositeKey, CdpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, CdpLinkTopologyEntity>();
        for (CdpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getCdpCacheDevicePort(), targetLink.getCdpInterfaceName(), ((CdpElementTopologyEntity)cdpelementmap.get(targetLink.getNodeId())).getCdpGlobalDeviceId(), targetLink.getCdpCacheDeviceId());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> results = new ArrayList<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>>();
        for (CdpLinkTopologyEntity sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: source: {} ", (Object)sourceLink);
            }
            CdpElementTopologyEntity sourceCdpElement = (CdpElementTopologyEntity)cdpelementmap.get(sourceLink.getNodeId());
            CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)targetLinkMap.get(new CompositeKey(sourceLink.getCdpInterfaceName(), sourceLink.getCdpCacheDevicePort(), sourceLink.getCdpCacheDeviceId(), sourceCdpElement.getCdpGlobalDeviceId()));
            if (targetLink == null) {
                LOG.debug("getCdpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: cdp: {}, target: {} ", (Object)sourceLink.getCdpCacheDevicePort(), (Object)targetLink);
            }
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
            results.add((Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getIsIsLinks() {
        List elements = this.m_topologyEntityCache.getIsIsElementTopologyEntities();
        List allLinks = this.m_topologyEntityCache.getIsIsLinkTopologyEntities();
        List<Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>> results = this.matchIsIsLinks(elements, allLinks);
        for (Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity> pair : results) {
            IsIsLinkTopologyEntity sourceLink = (IsIsLinkTopologyEntity)pair.getLeft();
            IsIsLinkTopologyEntity targetLink = (IsIsLinkTopologyEntity)pair.getRight();
            LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNodeIdAsString());
            source.getProtocolSupported().add(ProtocolSupported.ISIS);
            LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNodeIdAsString());
            target.getProtocolSupported().add(ProtocolSupported.ISIS);
            SnmpInterfaceTopologyEntity sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNodeId(), sourceLink.getIsisCircIfIndex());
            SnmpInterfaceTopologyEntity targetSnmpInterface = this.getSnmpInterface(targetLink.getNodeId(), targetLink.getIsisCircIfIndex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, targetLink.getIsisISAdjNeighSNPAAddress(), sourceLink.getIsisISAdjNeighSNPAAddress(), ProtocolSupported.ISIS);
        }
    }

    List<Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>> matchIsIsLinks(List<IsIsElementTopologyEntity> elements, List<IsIsLinkTopologyEntity> allLinks) {
        HashMap<Integer, IsIsElementTopologyEntity> elementmap = new HashMap<Integer, IsIsElementTopologyEntity>();
        for (IsIsElementTopologyEntity isIsElementTopologyEntity : elements) {
            elementmap.put(isIsElementTopologyEntity.getNodeId(), isIsElementTopologyEntity);
        }
        HashMap<CompositeKey, IsIsLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, IsIsLinkTopologyEntity>();
        for (IsIsLinkTopologyEntity targetLink : allLinks) {
            IsIsElementTopologyEntity targetElement = (IsIsElementTopologyEntity)elementmap.get(targetLink.getNodeId());
            targetLinkMap.put(new CompositeKey(targetLink.getIsisISAdjIndex(), targetElement.getIsisSysID(), targetLink.getIsisISAdjNeighSysID()), targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>> results = new ArrayList<Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>>();
        for (IsIsLinkTopologyEntity sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: source: {}", (Object)sourceLink);
            }
            IsIsElementTopologyEntity sourceElement = (IsIsElementTopologyEntity)elementmap.get(sourceLink.getNodeId());
            IsIsLinkTopologyEntity targetLink = (IsIsLinkTopologyEntity)targetLinkMap.get(new CompositeKey(sourceLink.getIsisISAdjIndex(), sourceLink.getIsisISAdjNeighSysID(), sourceElement.getIsisSysID()));
            if (targetLink == null) {
                LOG.debug("getIsIsLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().intValue() == targetLink.getId().intValue() || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: target: {}", (Object)targetLink);
            }
            results.add((Pair<IsIsLinkTopologyEntity, IsIsLinkTopologyEntity>)Pair.of((Object)sourceLink, (Object)targetLink));
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
        }
        return results;
    }

    private void getBridgeLinks() throws BridgeTopologyException {
        for (BroadcastDomain domain : this.m_bridgeTopologyService.findAll()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getBridgeLinks:\n {}", (Object)domain.printTopology());
            }
            this.parseDomain(domain);
        }
    }

    private void parseDomain(BroadcastDomain domain) throws BridgeTopologyException {
        for (SharedSegment segment : domain.getSharedSegments()) {
            LOG.debug("parseDomain: \n{}", (Object)segment.printTopology());
            this.parseSegment(segment);
        }
    }

    private void parseSegment(SharedSegment segment) throws BridgeTopologyException {
        SnmpInterfaceTopologyEntity targetinterface;
        BridgePort sourcebp;
        LinkdVertex target;
        LinkdVertex source;
        HashMap<BridgePort, Object> portToVertexMap = new HashMap<BridgePort, Object>();
        for (BridgePort bp : segment.getBridgePortsOnSegment()) {
            LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, bp.getNodeId().toString());
            vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
            portToVertexMap.put(bp, (Object)vertex);
        }
        HashSet<String> nomappedmacs = new HashSet<String>();
        HashMap<String, LinkdVertex> macToVertexMap = new HashMap<String, LinkdVertex>();
        for (String mac : segment.getMacsOnSegment()) {
            SnmpInterfaceTopologyEntity targetsnmpIface = this.m_macToOnmsSnmpMap.get(mac);
            if (targetsnmpIface != null) {
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetsnmpIface.getNodeIdAsString());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            IpInterfaceTopologyEntity targetipIface = this.m_macToOnmsIpMap.get(mac);
            if (targetipIface != null) {
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetipIface.getNodeIdAsString());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            if (this.m_macToNodeidMap.containsKey(mac)) {
                Integer nodeid = this.m_macToNodeidMap.get(mac);
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, nodeid.toString());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            nomappedmacs.add(mac);
        }
        if (portToVertexMap.size() == 2 && segment.getMacsOnSegment().size() == 0) {
            source = null;
            target = null;
            sourcebp = null;
            BridgePort targetbp = null;
            LOG.debug("point to point bridge link: segment {}", (Object)segment.printTopology());
            for (BridgePort bp : portToVertexMap.keySet()) {
                LOG.debug("point to point bridge link: parsinf {}", (Object)bp.printTopology());
                if (bp.getNodeId() == segment.getDesignatedBridge()) {
                    source = (LinkdVertex)((Object)portToVertexMap.get(bp));
                    sourcebp = bp;
                    continue;
                }
                target = (LinkdVertex)((Object)portToVertexMap.get(bp));
                targetbp = bp;
            }
            SnmpInterfaceTopologyEntity sourceSnmpInterface = this.getSnmpInterface(sourcebp.getNodeId(), sourcebp.getBridgePortIfIndex());
            SnmpInterfaceTopologyEntity targetSnmpInterface = this.getSnmpInterface(targetbp.getNodeId(), targetbp.getBridgePortIfIndex());
            this.connectVertices(LinkdTopologyProvider.getEdgeId(sourcebp, targetbp), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, "bp: " + sourcebp.getBridgePort(), "bp: " + targetbp.getBridgePort(), ProtocolSupported.BRIDGE);
            return;
        }
        if (portToVertexMap.size() == 1 && macToVertexMap.size() == 1 && segment.getMacsOnSegment().size() == 1) {
            source = (LinkdVertex)((Object)portToVertexMap.values().iterator().next());
            target = (LinkdVertex)((Object)macToVertexMap.values().iterator().next());
            sourcebp = (BridgePort)portToVertexMap.keySet().iterator().next();
            String targetmac = (String)macToVertexMap.keySet().iterator().next();
            SnmpInterfaceTopologyEntity sourceinterface = this.getSnmpInterface(sourcebp.getNodeId(), sourcebp.getBridgePortIfIndex());
            targetinterface = this.m_macToOnmsSnmpMap.get(targetmac);
            IpInterfaceTopologyEntity targetipinterface = this.m_macToOnmsIpMap.get(targetmac);
            StringBuffer targetAddr = new StringBuffer();
            targetAddr.append(targetmac);
            if (targetipinterface != null) {
                targetAddr.append(":");
                targetAddr.append(InetAddressUtils.str((InetAddress)targetipinterface.getIpAddress()));
            } else {
                targetAddr.append("Multiple ip addresses");
            }
            this.connectVertices(LinkdTopologyProvider.getEdgeId(sourcebp, targetmac), (AbstractVertex)source, (AbstractVertex)target, sourceinterface, targetinterface, "bp: " + sourcebp.getBridgePort(), targetAddr.toString(), ProtocolSupported.BRIDGE);
            return;
        }
        LinkdVertex topVertex = (LinkdVertex)((Object)portToVertexMap.get(segment.getDesignatedPort()));
        AbstractVertex cloudVertex = this.addVertex(LinkdTopologyProvider.getEdgeId(segment), 0, 0);
        if (nomappedmacs.size() > 0) {
            cloudVertex.setLabel("Multiple Mac Addresses");
        } else {
            cloudVertex.setLabel("");
        }
        cloudVertex.setIconKey("cloud");
        cloudVertex.setTooltipText("'Shared Segment' with designated up bridge: " + topVertex.getLabel() + " port: " + segment.getDesignatedPort().getBridgePort());
        this.addVertices(new Vertex[]{cloudVertex});
        LOG.debug("parseSegment: adding cloud: id: '{}', {}", (Object)cloudVertex.getId(), (Object)segment.printTopology());
        for (BridgePort bp : portToVertexMap.keySet()) {
            LinkdVertex bpportvertex = (LinkdVertex)((Object)portToVertexMap.get(bp));
            targetinterface = this.getSnmpInterface(bp.getNodeId(), bp.getBridgePortIfIndex());
            this.connectVertices(LinkdTopologyProvider.getEdgeId(cloudVertex, bp), cloudVertex, (AbstractVertex)bpportvertex, null, targetinterface, "shared segment: up bridge " + topVertex.getLabel() + " bp:" + segment.getDesignatedPort().getBridgePort(), "bp: " + bp.getBridgePort(), ProtocolSupported.BRIDGE);
        }
        for (String mac : macToVertexMap.keySet()) {
            LinkdVertex target2 = (LinkdVertex)((Object)macToVertexMap.get(mac));
            SnmpInterfaceTopologyEntity targetiface = this.m_macToOnmsSnmpMap.get(mac);
            IpInterfaceTopologyEntity targetipinterface = this.m_macToOnmsIpMap.get(mac);
            StringBuffer targetAddr = new StringBuffer();
            targetAddr.append(mac);
            if (targetipinterface != null) {
                targetAddr.append(":");
                targetAddr.append(InetAddressUtils.str((InetAddress)targetipinterface.getIpAddress()));
            } else {
                targetAddr.append("Multiple ip addresses");
            }
            this.connectVertices(LinkdTopologyProvider.getEdgeId(cloudVertex, mac), cloudVertex, (AbstractVertex)target2, null, targetiface, "shared segment: up bridge " + topVertex.getLabel() + " bp:" + segment.getDesignatedPort().getBridgePort(), targetAddr.toString(), ProtocolSupported.BRIDGE);
        }
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public TopologyEntityCache getTopologyEntityCache() {
        return this.m_topologyEntityCache;
    }

    public void setTopologyEntityCache(TopologyEntityCache topologyEntityCache) {
        this.m_topologyEntityCache = topologyEntityCache;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public BridgeTopologyService getBridgeTopologyService() {
        return this.m_bridgeTopologyService;
    }

    public void setBridgeTopologyService(BridgeTopologyService bridgeTopologyService) {
        this.m_bridgeTopologyService = bridgeTopologyService;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(1).withPreferredLayout("D3 Layout").withCriteria(() -> {
            Vertex defaultVertex;
            OnmsNode node = this.m_nodeDao.getDefaultFocusPoint();
            if (node != null && (defaultVertex = this.getVertex(TOPOLOGY_NAMESPACE_LINKD, node.getNodeId())) != null) {
                return Lists.newArrayList((Object[])new Criteria[]{LinkdHopCriteria.createCriteria(node.getNodeId(), node.getLabel())});
            }
            return Lists.newArrayList();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        Timer.Context vcontext = this.m_loadIpInterfacesTimer.time();
        HashMap<InetAddress, IpInterfaceTopologyEntity> ipToOnmsIpMap = new HashMap<InetAddress, IpInterfaceTopologyEntity>();
        HashSet<InetAddress> duplicated = new HashSet<InetAddress>();
        try {
            for (IpInterfaceTopologyEntity ip : this.m_topologyEntityCache.getIpInterfaceTopologyEntities()) {
                if (ip.getIsSnmpPrimary().equals((Object)PrimaryType.PRIMARY)) {
                    this.m_nodeToOnmsIpPrimaryMap.put(ip.getNodeId(), ip);
                } else {
                    this.m_nodeToOnmsIpPrimaryMap.putIfAbsent(ip.getNodeId(), ip);
                }
                if (!ipToOnmsIpMap.containsKey(ip.getIpAddress())) {
                    ipToOnmsIpMap.put(ip.getIpAddress(), ip);
                    continue;
                }
                duplicated.add(ip.getIpAddress());
                LOG.debug("refresh: found duplicated ip {}", (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
            }
            for (InetAddress ipdup : duplicated) {
                ipToOnmsIpMap.remove(ipdup);
            }
            LOG.info("refresh: Ip Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Loading Ip Interface failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadSnmpInterfacesTimer.time();
        try {
            for (SnmpInterfaceTopologyEntity snmp : this.m_topologyEntityCache.getSnmpInterfaceTopologyEntities()) {
                int nodeId = snmp.getNodeId();
                if (!this.m_nodeToOnmsSnmpMap.containsKey(nodeId)) {
                    this.m_nodeToOnmsSnmpMap.put(nodeId, new HashMap());
                }
                this.m_nodeToOnmsSnmpMap.get(nodeId).put(snmp.getIfIndex(), snmp);
            }
            LOG.info("refresh: Snmp Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Loading Snmp Interface failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadIpNetToMediaTimer.time();
        HashSet<String> multiIpMacs = new HashSet<String>();
        HashSet<String> multiSnmpMacs = new HashSet<String>();
        try {
            for (IpNetToMedia ipnettomedia : this.m_ipNetToMediaDao.findAll()) {
                IpInterfaceTopologyEntity onmsip = (IpInterfaceTopologyEntity)ipToOnmsIpMap.get(ipnettomedia.getNetAddress());
                if (onmsip == null) {
                    LOG.debug("refresh: ipNetToMedia: {}:{}. No OnmsIpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                    continue;
                }
                LOG.debug("refresh: ipNetToMedia: {}:{}. OnmsIpInterface found node:[{}].", new Object[]{ipnettomedia.getPhysAddress(), InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()), onmsip.getNodeId()});
                if (!this.m_macToNodeidMap.containsKey(ipnettomedia.getPhysAddress())) {
                    this.m_macToNodeidMap.put(ipnettomedia.getPhysAddress(), onmsip.getNodeId());
                }
                if (!this.m_macToOnmsIpMap.containsKey(ipnettomedia.getPhysAddress())) {
                    this.m_macToOnmsIpMap.put(ipnettomedia.getPhysAddress(), onmsip);
                } else {
                    multiIpMacs.add(ipnettomedia.getPhysAddress());
                    LOG.debug("refresh: ipNetToMedia: {}:{}. Multiple OnmsIpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                }
                if (this.m_nodeToOnmsSnmpMap.containsKey(onmsip.getNodeId())) {
                    for (SnmpInterfaceTopologyEntity onmssnmp : this.m_nodeToOnmsSnmpMap.get(onmsip.getNodeId()).values()) {
                        if (onmssnmp.getId().intValue() != onmssnmp.getId().intValue()) continue;
                        if (!this.m_macToOnmsSnmpMap.containsKey(ipnettomedia.getPhysAddress())) {
                            this.m_macToOnmsSnmpMap.put(ipnettomedia.getPhysAddress(), onmssnmp);
                            continue;
                        }
                        if (this.m_macToOnmsSnmpMap.get(ipnettomedia.getPhysAddress()).getId().intValue() == onmssnmp.getId().intValue()) continue;
                        multiSnmpMacs.add(ipnettomedia.getPhysAddress());
                        LOG.debug("refresh: ipNetToMedia: {}:{}. Multiple OnmsSnmpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                    }
                    continue;
                }
                LOG.debug("refresh: ipNetToMedia: {}:{}. No OnmsSnmpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
            }
            LOG.info("refresh: IpNetToMedia loaded");
        }
        catch (Exception e) {
            LOG.error("Loading ipNetToMedia failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadVerticesTimer.time();
        try {
            this.loadVertices();
            LOG.info("refresh: Loaded Vertices");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Vertices: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadEdgesTimer.time();
        try {
            this.loadEdges();
            LOG.info("refresh: Loaded Edges");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Edges: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
    }

    public void refresh() {
        Timer.Context context = this.m_loadFullTimer.time();
        try {
            this.resetContainer();
            this.m_nodeToOnmsSnmpMap.clear();
            this.m_nodeToOnmsIpPrimaryMap.clear();
            this.m_macToNodeidMap.clear();
            this.m_macToOnmsIpMap.clear();
            this.m_macToOnmsSnmpMap.clear();
            this.doRefresh();
        }
        finally {
            context.stop();
        }
        LOG.info("refresh: Found {} groups", (Object)this.getGroups().size());
        LOG.info("refresh: Found {} vertices", (Object)this.getVerticesWithoutGroups().size());
        LOG.info("refresh: Found {} edges", (Object)this.getEdges(new Criteria[0]).size());
    }
}

