/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.net.InetAddress;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;

public class LinkdVertex
extends SimpleLeafVertex {
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private static final EnumMap<OnmsNode.NodeType, String> s_nodeStatusMap = new EnumMap(OnmsNode.NodeType.class);
    private String m_nodeType;
    private String m_location;
    private String m_sysObjectId;
    private String m_isManaged;
    private Set<ProtocolSupported> m_protocolSupported = EnumSet.noneOf(ProtocolSupported.class);

    public static LinkdVertex create(OnmsNode node, OnmsIpInterface primary) {
        LinkdVertex vertex = new LinkdVertex(node);
        vertex.setNodeID(node.getId());
        vertex.setLabel(node.getLabel());
        vertex.setNodeType(s_nodeStatusMap.get(node.getType()));
        vertex.setSysObjectId(node.getSysObjectId());
        if (node.getLocation() != null) {
            vertex.setLocation(node.getLocation().getLocationName());
        }
        vertex.setIpAddress("no ip address");
        if (primary != null) {
            vertex.setIpAddress(InetAddressUtils.str((InetAddress)primary.getIpAddress()));
        }
        vertex.setManaged("Unmanaged");
        if (primary != null && primary.isManaged()) {
            vertex.setManaged("Managed");
        }
        return vertex;
    }

    public static LinkdVertex create(NodeTopologyEntity node, OnmsIpInterface primary) {
        LinkdVertex vertex = new LinkdVertex(node.getId().toString());
        vertex.setNodeID(node.getId());
        vertex.setLabel(node.getLabel());
        vertex.setNodeType(s_nodeStatusMap.get(node.getType()));
        vertex.setSysObjectId(node.getSysObjectId());
        if (node.getLocation() != null) {
            vertex.setLocation(node.getLocation());
        }
        vertex.setIpAddress("no ip address");
        if (primary != null) {
            vertex.setIpAddress(InetAddressUtils.str((InetAddress)primary.getIpAddress()));
        }
        vertex.setManaged("Unmanaged");
        if (primary != null && primary.isManaged()) {
            vertex.setManaged("Managed");
        }
        return vertex;
    }

    public Set<ProtocolSupported> getProtocolSupported() {
        return this.m_protocolSupported;
    }

    public String getSysObjectId() {
        return this.m_sysObjectId;
    }

    public void setSysObjectId(String sysObjectId) {
        this.m_sysObjectId = sysObjectId;
    }

    public String getNodeType() {
        return this.m_nodeType;
    }

    public void setNodeType(String nodeType) {
        this.m_nodeType = nodeType;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public String getManaged() {
        return this.m_isManaged;
    }

    public void setManaged(String isManaged) {
        this.m_isManaged = isManaged;
    }

    private LinkdVertex(OnmsNode node) {
        this(node.getNodeId());
    }

    private LinkdVertex(String id) {
        super("nodes", id, Integer.valueOf(0), Integer.valueOf(0));
    }

    public String getIconKey() {
        if (this.m_sysObjectId == null) {
            return "linkd.system";
        }
        if (this.m_sysObjectId.startsWith(".")) {
            return "linkd.system.snmp" + this.m_sysObjectId;
        }
        return "linkd.system.snmp." + this.m_sysObjectId;
    }

    public String getTooltipText() {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append(this.getLabel());
        tooltipText.append(": ");
        tooltipText.append("(");
        tooltipText.append(this.getIpAddress());
        tooltipText.append(")");
        tooltipText.append("(");
        tooltipText.append(this.m_nodeType);
        tooltipText.append("/");
        tooltipText.append(this.m_isManaged);
        tooltipText.append(")");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (this.m_location != null && this.m_location.trim().length() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append(this.m_location);
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        if (this.m_protocolSupported.size() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append(this.m_protocolSupported.toString());
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        return tooltipText.toString();
    }

    static {
        s_nodeStatusMap.put(OnmsNode.NodeType.ACTIVE, "Active");
        s_nodeStatusMap.put(OnmsNode.NodeType.UNKNOWN, "Unknown");
        s_nodeStatusMap.put(OnmsNode.NodeType.DELETED, "Deleted");
    }
}

