/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.GroupRef;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.slf4j.LoggerFactory;

public class LinkdSelectionAware
implements SelectionAware {
    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        List<Integer> nodeIds = this.extractNodeIds(selectedVertices);
        if (type == ContentType.Alarm) {
            return new SelectionChangedListener.AlarmNodeIdSelection(nodeIds);
        }
        if (type == ContentType.Node) {
            return new SelectionChangedListener.IdSelection(nodeIds);
        }
        return SelectionChangedListener.Selection.NONE;
    }

    public boolean contributesTo(ContentType type) {
        return Sets.newHashSet((Object[])new ContentType[]{ContentType.Alarm, ContentType.Node}).contains(type);
    }

    protected List<Integer> extractNodeIds(Collection<VertexRef> vertices) {
        ArrayList<Integer> nodeIdList = new ArrayList<Integer>();
        for (VertexRef eachRef : vertices) {
            if ("nodes".equals(eachRef.getNamespace())) {
                try {
                    nodeIdList.add(Integer.valueOf(eachRef.getId()));
                }
                catch (NumberFormatException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot filter nodes with ID: {}", (Object)eachRef.getId());
                }
                continue;
            }
            if (!((Vertex)eachRef).isGroup() || !"category".equals(eachRef.getNamespace())) continue;
            try {
                GroupRef group = (GroupRef)eachRef;
                nodeIdList.addAll(Collections2.transform((Collection)group.getChildren(), (Function)new Function<VertexRef, Integer>(){

                    public Integer apply(VertexRef input) {
                        return Integer.valueOf(input.getId());
                    }
                }));
            }
            catch (ClassCastException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Cannot filter category with ID: {} children: {}", (Object)eachRef.getId(), (Object)((GroupRef)eachRef).getChildren());
            }
        }
        return nodeIdList;
    }
}

