/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyProvider;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class LinkdEdge
extends AbstractEdge
implements Edge {
    private static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    private static final String HTML_TOOLTIP_TAG_END = "</p>";
    private Integer m_sourceNodeid;
    private Integer m_targetNodeid;
    private String m_sourceLabel;
    private String m_targetLabel;
    private String m_sourceIfName;
    private String m_targetIfName;
    private String m_sourceAddr;
    private String m_targetAddr;
    private String m_speed;
    private Integer m_sourceIfIndex;
    private Integer m_targetIfIndex;
    private final LinkdTopologyProvider.ProtocolSupported m_discoveredBy;

    public static LinkdEdge create(String id, Vertex sourceV, Vertex targetV, LinkdTopologyProvider.ProtocolSupported discoveredBy) {
        return new LinkdEdge(id, sourceV, targetV, discoveredBy);
    }

    public static LinkdEdge create(String id, AbstractVertex sourceV, AbstractVertex targetV, OnmsSnmpInterface sourceinterface, OnmsSnmpInterface targetInterface, String sourceAddr, String targetAddr, LinkdTopologyProvider.ProtocolSupported discoveredBy) {
        SimpleConnector source = new SimpleConnector("nodes", sourceV.getId() + "-" + id + "-connector", (VertexRef)sourceV);
        SimpleConnector target = new SimpleConnector("nodes", targetV.getId() + "-" + id + "-connector", (VertexRef)targetV);
        LinkdEdge edge = new LinkdEdge(id, source, target, discoveredBy);
        edge.setSourceNodeid(sourceV.getNodeID());
        edge.setTargetNodeid(targetV.getNodeID());
        edge.setSourceLabel(sourceV.getLabel());
        edge.setTargetLabel(targetV.getLabel());
        if (sourceinterface != null) {
            edge.setSourceIfIndex(sourceinterface.getIfIndex());
            edge.setSourceIfName(sourceinterface.getIfName());
            if (sourceinterface.getIfSpeed() != null) {
                edge.setSpeed(InetAddressUtils.getHumanReadableIfSpeed((long)sourceinterface.getIfSpeed()));
            }
        }
        if (targetInterface != null) {
            edge.setTargetIfIndex(targetInterface.getIfIndex());
            edge.setTargetIfName(targetInterface.getIfName());
            if (edge.getSpeed() == null && targetInterface.getIfSpeed() != null) {
                edge.setSpeed(InetAddressUtils.getHumanReadableIfSpeed((long)targetInterface.getIfSpeed()));
            }
        }
        edge.setSourceAddr(sourceAddr);
        edge.setTargetAddr(targetAddr);
        return edge;
    }

    private LinkdEdge(String id, Vertex source, Vertex target, LinkdTopologyProvider.ProtocolSupported discoveredBy) {
        super("nodes", id, (VertexRef)source, (VertexRef)target);
        this.m_discoveredBy = discoveredBy;
    }

    private LinkdEdge(String id, SimpleConnector source, SimpleConnector target, LinkdTopologyProvider.ProtocolSupported discoveredBy) {
        super("nodes", id, source, target);
        this.m_discoveredBy = discoveredBy;
    }

    private LinkdEdge(LinkdEdge edgeToClone) {
        this(edgeToClone.getId(), edgeToClone.getSource().clone(), edgeToClone.getTarget().clone(), edgeToClone.getDiscoveredBy());
        this.setSourceLabel(edgeToClone.getSourceLabel());
        this.setSourceNodeid(edgeToClone.getSourceNodeid());
        this.setSourceIfIndex(edgeToClone.getSourceIfIndex());
        this.setSourceIfName(edgeToClone.getSourceIfName());
        this.setSourceAddr(edgeToClone.getSourceAddr());
        this.setTargetLabel(edgeToClone.getTargetLabel());
        this.setTargetNodeid(edgeToClone.getTargetNodeid());
        this.setTargetIfIndex(edgeToClone.getTargetIfIndex());
        this.setTargetIfName(edgeToClone.getTargetIfName());
        this.setTargetAddr(edgeToClone.getTargetAddr());
        this.setSpeed(edgeToClone.getSpeed());
        this.setLabel(edgeToClone.getLabel());
        this.setStyleName(edgeToClone.getStyleName());
        this.setTooltipText(edgeToClone.getTooltipText());
    }

    public LinkdEdge clone() {
        return new LinkdEdge(this);
    }

    public String getTooltipText() {
        StringBuilder tooltipText = new StringBuilder();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append("discovery by: ");
        tooltipText.append(this.m_discoveredBy.toString());
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append(this.m_sourceLabel);
        if (this.m_sourceIfName != null) {
            tooltipText.append("(");
            tooltipText.append(this.m_sourceIfName);
            tooltipText.append(")");
        }
        if (this.m_sourceAddr != null) {
            tooltipText.append("(");
            tooltipText.append(this.m_sourceAddr);
            tooltipText.append(")");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append(this.m_targetLabel);
        if (this.m_targetIfName != null) {
            tooltipText.append("(");
            tooltipText.append(this.m_targetIfName);
            tooltipText.append(")");
        }
        if (this.m_targetAddr != null) {
            tooltipText.append("(");
            tooltipText.append(this.m_targetAddr);
            tooltipText.append(")");
        }
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (this.m_speed != null) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append(this.m_speed);
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        return tooltipText.toString();
    }

    public String getSourceAddr() {
        return this.m_sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.m_sourceAddr = sourceAddr;
    }

    public String getTargetAddr() {
        return this.m_targetAddr;
    }

    public void setTargetAddr(String targetIpAddr) {
        this.m_targetAddr = targetIpAddr;
    }

    public String getSourceLabel() {
        return this.m_sourceLabel;
    }

    public void setSourceLabel(String sourceLabel) {
        this.m_sourceLabel = sourceLabel;
    }

    public String getTargetLabel() {
        return this.m_targetLabel;
    }

    public void setTargetLabel(String targetLabel) {
        this.m_targetLabel = targetLabel;
    }

    public String getSourceIfName() {
        return this.m_sourceIfName;
    }

    public void setSourceIfName(String sourceIfName) {
        this.m_sourceIfName = sourceIfName;
    }

    public String getTargetIfName() {
        return this.m_targetIfName;
    }

    public void setTargetIfName(String targetIfName) {
        this.m_targetIfName = targetIfName;
    }

    public String getSpeed() {
        return this.m_speed;
    }

    public void setSpeed(String speed) {
        this.m_speed = speed;
    }

    public Integer getSourceIfIndex() {
        return this.m_sourceIfIndex;
    }

    public void setSourceIfIndex(Integer sourceIfIndex) {
        this.m_sourceIfIndex = sourceIfIndex;
    }

    public Integer getTargetIfIndex() {
        return this.m_targetIfIndex;
    }

    public void setTargetIfIndex(Integer targetIfIndex) {
        this.m_targetIfIndex = targetIfIndex;
    }

    public LinkdTopologyProvider.ProtocolSupported getDiscoveredBy() {
        return this.m_discoveredBy;
    }

    public Integer getSourceNodeid() {
        return this.m_sourceNodeid;
    }

    public void setSourceNodeid(Integer sourceNodeid) {
        this.m_sourceNodeid = sourceNodeid;
    }

    public Integer getTargetNodeid() {
        return this.m_targetNodeid;
    }

    public void setTargetNodeid(Integer targetNodeid) {
        this.m_targetNodeid = targetNodeid;
    }
}

