/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.CompositeKey;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdSelectionAware;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdVertex;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsElementDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.TopologyDao;
import org.opennms.netmgt.dao.api.TopologyEntityCache;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.NodeTopologyEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BridgeTopologyException;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class LinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider {
    private static Logger LOG = LoggerFactory.getLogger(LinkdTopologyProvider.class);
    private TransactionOperations m_transactionOperations;
    private NodeDao m_nodeDao;
    private TopologyEntityCache m_topologyEntityCache;
    private SnmpInterfaceDao m_snmpInterfaceDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private TopologyDao m_topologyDao;
    private FilterManager m_filterManager;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;
    private CdpElementDao m_cdpElementDao;
    private OspfLinkDao m_ospfLinkDao;
    private IsIsLinkDao m_isisLinkDao;
    private IsIsElementDao m_isisElementDao;
    private BridgeTopologyDao m_bridgeTopologyDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private Map<Integer, OnmsIpInterface> m_nodeToOnmsIpPrimaryMap = new HashMap<Integer, OnmsIpInterface>();
    private Map<Integer, Map<Integer, OnmsSnmpInterface>> m_nodeToOnmsSnmpMap = new HashMap<Integer, Map<Integer, OnmsSnmpInterface>>();
    private Map<String, Integer> m_macToNodeidMap = new HashMap<String, Integer>();
    private Map<String, OnmsIpInterface> m_macToOnmsIpMap = new HashMap<String, OnmsIpInterface>();
    private Map<String, OnmsSnmpInterface> m_macToOnmsSnmpMap = new HashMap<String, OnmsSnmpInterface>();
    private final Timer m_loadFullTimer;
    private final Timer m_loadIpInterfacesTimer;
    private final Timer m_loadSnmpInterfacesTimer;
    private final Timer m_loadIpNetToMediaTimer;
    private final Timer m_loadLldpLinksTimer;
    private final Timer m_loadOspfLinksTimer;
    private final Timer m_loadCdpLinksTimer;
    private final Timer m_loadIsisLinksTimer;
    private final Timer m_loadBridgeLinksTimer;
    private final Timer m_loadVerticesTimer;
    private final Timer m_loadEdgesTimer;
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    private SelectionAware selectionAwareDelegate = new LinkdSelectionAware();

    static final String getEdgeId(AbstractVertex vertex, BridgePort bp) {
        return vertex.getId() + "|" + bp.getNodeId() + ":" + bp.getBridgePort();
    }

    static final String getEdgeId(AbstractVertex vertex, String mac) {
        return vertex.getId() + "|" + mac;
    }

    static final String getEdgeId(SharedSegment segment) throws BridgeTopologyException {
        return segment.getDesignatedBridge() + ":" + segment.getDesignatedPort().getBridgePort();
    }

    static final String getDefaultEdgeId(int sourceId, int targetId) {
        return Math.min(sourceId, targetId) + "|" + Math.max(sourceId, targetId);
    }

    static final String getEdgeId(BridgePort sourcebp, BridgePort targetbp) {
        if (sourcebp.getNodeId() < targetbp.getNodeId()) {
            return sourcebp.getNodeId() + ":" + sourcebp.getBridgePort() + "|" + targetbp.getNodeId() + ":" + targetbp.getBridgePort();
        }
        return targetbp.getNodeId() + ":" + targetbp.getBridgePort() + "|" + sourcebp.getNodeId() + ":" + sourcebp.getBridgePort();
    }

    static final String getEdgeId(BridgePort sourcebp, String targetmac) {
        return sourcebp.getNodeId() + ":" + sourcebp.getBridgePort() + "|" + targetmac;
    }

    public LinkdTopologyProvider(MetricRegistry registry) {
        super(TOPOLOGY_NAMESPACE_LINKD);
        Objects.requireNonNull(registry);
        this.m_loadFullTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "full"}));
        this.m_loadIpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipinterfaces"}));
        this.m_loadSnmpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "snmpinterfaces"}));
        this.m_loadIpNetToMediaTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipnettomedia"}));
        this.m_loadLldpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "lldp"}));
        this.m_loadOspfLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "ospf"}));
        this.m_loadCdpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "cdp"}));
        this.m_loadIsisLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "isis"}));
        this.m_loadBridgeLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "bridge"}));
        this.m_loadVerticesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "vertices", "none"}));
        this.m_loadEdgesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "edges", "none"}));
    }

    private OnmsSnmpInterface getSnmpInterface(Integer nodeid, Integer ifindex) {
        if (this.m_nodeToOnmsSnmpMap.containsKey(nodeid) && this.m_nodeToOnmsSnmpMap.get(nodeid).containsKey(ifindex)) {
            return this.m_nodeToOnmsSnmpMap.get(nodeid).get(ifindex);
        }
        OnmsSnmpInterface snmpiface = new OnmsSnmpInterface();
        OnmsNode node = new OnmsNode();
        node.setId(nodeid);
        snmpiface.setNode(node);
        snmpiface.setIfIndex(ifindex);
        snmpiface.setIfName("No Interface Found");
        return snmpiface;
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.selectionAwareDelegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.selectionAwareDelegate.contributesTo(type);
    }

    protected void connectVertices(String id, AbstractVertex sourceV, AbstractVertex targetV, OnmsSnmpInterface sourceinterface, OnmsSnmpInterface targetInterface, String sourceAddr, String targetAddr, ProtocolSupported discoveredBy) {
        this.addEdges(new Edge[]{LinkdEdge.create(id, sourceV, targetV, sourceinterface, targetInterface, sourceAddr, targetAddr, discoveredBy)});
    }

    private void loadVertices() {
        for (NodeTopologyEntity vertex : this.m_topologyEntityCache.getNodeTopolgyEntities()) {
            OnmsIpInterface primary = this.m_nodeToOnmsIpPrimaryMap.get(vertex.getId());
            this.addVertices(new Vertex[]{LinkdVertex.create(vertex, primary)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEdges() {
        Timer.Context context = this.m_loadLldpLinksTimer.time();
        try {
            this.getLldpLinks();
            LOG.info("loadEdges: LldpLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading LldpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadOspfLinksTimer.time();
        try {
            this.getOspfLinks();
            LOG.info("loadEdges: OspfLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading OspfLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadCdpLinksTimer.time();
        try {
            this.getCdpLinks();
            LOG.info("loadEdges: CdpLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading CdpLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIsisLinksTimer.time();
        try {
            this.getIsIsLinks();
            LOG.info("loadEdges: IsIsLink loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting IsIs link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadBridgeLinksTimer.time();
        try {
            this.getBridgeLinks();
            LOG.info("loadEdges: BridgeLink loaded");
        }
        catch (Exception e) {
            LOG.error("Loading BridgeLink failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            context.stop();
        }
    }

    private void getLldpLinks() {
        List allLinks = this.m_lldpLinkDao.findAll();
        HashMap<Integer, LldpElement> nodelldpelementidMap = new HashMap<Integer, LldpElement>();
        HashMap<Integer, LinkdVertex> nodeVertexMap = new HashMap<Integer, LinkdVertex>();
        for (LldpElement lldpelement : this.m_lldpElementDao.findAll()) {
            nodelldpelementidMap.put(lldpelement.getNode().getId(), lldpelement);
            LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, lldpelement.getNode().getNodeId());
            vertex.getProtocolSupported().add(ProtocolSupported.LLDP);
            nodeVertexMap.put(lldpelement.getNode().getId(), vertex);
            System.err.println(vertex.getId());
        }
        List<Pair<LldpLink, LldpLink>> matchedLinks = this.matchLldpLinks(nodelldpelementidMap, allLinks);
        for (Pair<LldpLink, LldpLink> pair : matchedLinks) {
            LldpLink sourceLink = (LldpLink)pair.getLeft();
            LldpLink targetLink = (LldpLink)pair.getRight();
            LinkdVertex source = (LinkdVertex)((Object)nodeVertexMap.get(sourceLink.getNode().getId()));
            LinkdVertex target = (LinkdVertex)((Object)nodeVertexMap.get(targetLink.getNode().getId()));
            OnmsSnmpInterface sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNode().getId(), sourceLink.getLldpPortIfindex());
            OnmsSnmpInterface targetSnmpInterface = this.getSnmpInterface(targetLink.getNode().getId(), targetLink.getLldpPortIfindex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, sourceLink.getLldpPortDescr(), targetLink.getLldpPortDescr(), ProtocolSupported.LLDP);
        }
    }

    List<Pair<LldpLink, LldpLink>> matchLldpLinks(Map<Integer, LldpElement> nodelldpelementidMap, List<LldpLink> allLinks) {
        ArrayList<Pair<LldpLink, LldpLink>> results = new ArrayList<Pair<LldpLink, LldpLink>>();
        HashMap<CompositeKey, LldpLink> targetLinkMap = new HashMap<CompositeKey, LldpLink>();
        for (LldpLink targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getLldpRemChassisId(), nodelldpelementidMap.get(targetLink.getNode().getId()).getLldpChassisId(), targetLink.getLldpPortId(), targetLink.getLldpPortIdSubType(), targetLink.getLldpRemPortId(), targetLink.getLldpRemPortIdSubType());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLink sourceLink : allLinks) {
            CompositeKey key;
            LldpLink targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            String sourceLldpChassisId = nodelldpelementidMap.get(sourceLink.getNode().getId()).getLldpChassisId();
            if (sourceLldpChassisId.equals(sourceLink.getLldpRemChassisId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getLldpLinks: self link not adding source: {}", (Object)sourceLink.printTopology());
                }
                parsed.add(sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: source: {}", (Object)sourceLink.printTopology());
            }
            if ((targetLink = (LldpLink)targetLinkMap.get(key = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNode().getId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpRemPortId(), sourceLink.getLldpRemPortIdSubType(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType()))) == null) {
                LOG.debug("getLldpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLldpLinks: lldp: {} target: {}", (Object)sourceLink.getLldpRemChassisId(), (Object)targetLink.printTopology());
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add((Pair<LldpLink, LldpLink>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getOspfLinks() {
        List allLinks = this.getOspfLinkDao().findAll();
        List<Pair<OspfLink, OspfLink>> matchedLinks = this.matchOspfLinks(allLinks);
        for (Pair<OspfLink, OspfLink> pair : matchedLinks) {
            OspfLink sourceLink = (OspfLink)pair.getLeft();
            OspfLink targetLink = (OspfLink)pair.getRight();
            LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNode().getNodeId());
            source.getProtocolSupported().add(ProtocolSupported.OSPF);
            LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNode().getNodeId());
            target.getProtocolSupported().add(ProtocolSupported.OSPF);
            OnmsSnmpInterface sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNode().getId(), sourceLink.getOspfIfIndex());
            OnmsSnmpInterface targetSnmpInterface = this.getSnmpInterface(targetLink.getNode().getId(), targetLink.getOspfIfIndex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, InetAddressUtils.str((InetAddress)targetLink.getOspfRemIpAddr()), InetAddressUtils.str((InetAddress)sourceLink.getOspfRemIpAddr()), ProtocolSupported.OSPF);
        }
    }

    List<Pair<OspfLink, OspfLink>> matchOspfLinks(List<OspfLink> allLinks) {
        ArrayList<Pair<OspfLink, OspfLink>> results = new ArrayList<Pair<OspfLink, OspfLink>>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        HashMap<CompositeKey, OspfLink> targetLinks = new HashMap<CompositeKey, OspfLink>();
        for (OspfLink targetLink : allLinks) {
            targetLinks.put(new CompositeKey(targetLink.getOspfIpAddr(), targetLink.getOspfRemIpAddr()), targetLink);
        }
        for (OspfLink sourceLink : allLinks) {
            OspfLink targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            parsed.add(sourceLink.getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOspfLinks: source: {}", (Object)sourceLink.printTopology());
            }
            if ((targetLink = (OspfLink)targetLinks.get(new CompositeKey(sourceLink.getOspfRemIpAddr(), sourceLink.getOspfIpAddr()))) == null) {
                LOG.debug("getOspfLinks: cannot find target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || parsed.contains(targetLink.getId())) continue;
            LOG.debug("getOspfLinks: target: {}", (Object)targetLink.printTopology());
            parsed.add(targetLink.getId());
            results.add((Pair<OspfLink, OspfLink>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getCdpLinks() {
        List cdpElements = this.m_cdpElementDao.findAll();
        List allLinks = this.m_topologyEntityCache.getCdpLinkTopologyEntities();
        List<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> matchedCdpLinks = this.matchCdpLinks(cdpElements, allLinks);
        for (Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity> pair : matchedCdpLinks) {
            this.connectCdpLinkPair(pair);
        }
    }

    private void connectCdpLinkPair(Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity> pair) {
        CdpLinkTopologyEntity sourceLink = (CdpLinkTopologyEntity)pair.getLeft();
        CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)pair.getRight();
        LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNodeIdAsString());
        source.getProtocolSupported().add(ProtocolSupported.CDP);
        LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNodeIdAsString());
        target.getProtocolSupported().add(ProtocolSupported.CDP);
        OnmsSnmpInterface sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNodeId(), sourceLink.getCdpCacheIfIndex());
        OnmsSnmpInterface targetSnmpInterface = this.getSnmpInterface(targetLink.getNodeId(), targetLink.getCdpCacheIfIndex());
        this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, targetLink.getCdpCacheAddress(), sourceLink.getCdpCacheAddress(), ProtocolSupported.CDP);
    }

    List<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> matchCdpLinks(List<CdpElement> cdpElements, List<CdpLinkTopologyEntity> allLinks) {
        HashMap<Integer, CdpElement> cdpelementmap = new HashMap<Integer, CdpElement>();
        for (CdpElement cdpElement : cdpElements) {
            cdpelementmap.put(cdpElement.getNode().getId(), cdpElement);
        }
        HashMap<CompositeKey, CdpLinkTopologyEntity> targetLinkMap = new HashMap<CompositeKey, CdpLinkTopologyEntity>();
        for (CdpLinkTopologyEntity targetLink : allLinks) {
            CompositeKey key = new CompositeKey(targetLink.getCdpCacheDevicePort(), targetLink.getCdpInterfaceName(), ((CdpElement)cdpelementmap.get(targetLink.getNodeId())).getCdpGlobalDeviceId(), targetLink.getCdpCacheDeviceId());
            targetLinkMap.put(key, targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>> results = new ArrayList<Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>>();
        for (CdpLinkTopologyEntity sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: source: {} ", (Object)sourceLink.toString());
            }
            CdpElement sourceCdpElement = (CdpElement)cdpelementmap.get(sourceLink.getNodeId());
            CdpLinkTopologyEntity targetLink = (CdpLinkTopologyEntity)targetLinkMap.get(new CompositeKey(sourceLink.getCdpInterfaceName(), sourceLink.getCdpCacheDevicePort(), sourceLink.getCdpCacheDeviceId(), sourceCdpElement.getCdpGlobalDeviceId()));
            if (targetLink == null) {
                LOG.debug("getCdpLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCdpLinks: cdp: {}, target: {} ", (Object)sourceLink.getCdpCacheDevicePort(), (Object)targetLink.toString());
            }
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
            results.add((Pair<CdpLinkTopologyEntity, CdpLinkTopologyEntity>)Pair.of((Object)sourceLink, (Object)targetLink));
        }
        return results;
    }

    private void getIsIsLinks() {
        List elements = this.m_isisElementDao.findAll();
        List allLinks = this.m_isisLinkDao.findAll();
        List<Pair<IsIsLink, IsIsLink>> results = this.matchIsIsLinks(elements, allLinks);
        for (Pair<IsIsLink, IsIsLink> pair : results) {
            IsIsLink sourceLink = (IsIsLink)pair.getLeft();
            IsIsLink targetLink = (IsIsLink)pair.getRight();
            LinkdVertex source = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, sourceLink.getNode().getNodeId());
            source.getProtocolSupported().add(ProtocolSupported.ISIS);
            LinkdVertex target = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetLink.getNode().getNodeId());
            target.getProtocolSupported().add(ProtocolSupported.ISIS);
            OnmsSnmpInterface sourceSnmpInterface = this.getSnmpInterface(sourceLink.getNode().getId(), sourceLink.getIsisCircIfIndex());
            OnmsSnmpInterface targetSnmpInterface = this.getSnmpInterface(targetLink.getNode().getId(), targetLink.getIsisCircIfIndex());
            this.connectVertices(LinkdTopologyProvider.getDefaultEdgeId(sourceLink.getId(), targetLink.getId()), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, targetLink.getIsisISAdjNeighSNPAAddress(), sourceLink.getIsisISAdjNeighSNPAAddress(), ProtocolSupported.ISIS);
        }
    }

    List<Pair<IsIsLink, IsIsLink>> matchIsIsLinks(List<IsIsElement> elements, List<IsIsLink> allLinks) {
        HashMap<Integer, IsIsElement> elementmap = new HashMap<Integer, IsIsElement>();
        for (IsIsElement isIsElement : elements) {
            elementmap.put(isIsElement.getNode().getId(), isIsElement);
        }
        HashMap<CompositeKey, IsIsLink> targetLinkMap = new HashMap<CompositeKey, IsIsLink>();
        for (IsIsLink targetLink : allLinks) {
            IsIsElement targetElement = (IsIsElement)elementmap.get(targetLink.getNode().getId());
            targetLinkMap.put(new CompositeKey(targetLink.getIsisISAdjIndex(), targetElement.getIsisSysID(), targetLink.getIsisISAdjNeighSysID()), targetLink);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Pair<IsIsLink, IsIsLink>> results = new ArrayList<Pair<IsIsLink, IsIsLink>>();
        for (IsIsLink sourceLink : allLinks) {
            if (hashSet.contains(sourceLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: source: {}", (Object)sourceLink.printTopology());
            }
            IsIsElement sourceElement = (IsIsElement)elementmap.get(sourceLink.getNode().getId());
            IsIsLink targetLink = (IsIsLink)targetLinkMap.get(new CompositeKey(sourceLink.getIsisISAdjIndex(), sourceLink.getIsisISAdjNeighSysID(), sourceElement.getIsisSysID()));
            if (targetLink == null) {
                LOG.debug("getIsIsLinks: cannot found target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().intValue() == targetLink.getId().intValue() || hashSet.contains(targetLink.getId())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getIsIsLinks: target: {}", (Object)targetLink.printTopology());
            }
            results.add((Pair<IsIsLink, IsIsLink>)Pair.of((Object)sourceLink, (Object)targetLink));
            hashSet.add(sourceLink.getId());
            hashSet.add(targetLink.getId());
        }
        return results;
    }

    private void getBridgeLinks() throws BridgeTopologyException {
        for (BroadcastDomain domain : this.m_bridgeTopologyDao.load()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getBridgeLinks:\n {}", (Object)domain.printTopology());
            }
            this.parseDomain(domain);
        }
    }

    private void parseDomain(BroadcastDomain domain) throws BridgeTopologyException {
        for (SharedSegment segment : domain.getSharedSegments()) {
            LOG.debug("parseDomain: \n{}", (Object)segment.printTopology());
            this.parseSegment(segment);
        }
    }

    private void parseSegment(SharedSegment segment) throws BridgeTopologyException {
        OnmsSnmpInterface targetinterface;
        BridgePort sourcebp;
        LinkdVertex target;
        LinkdVertex source;
        HashMap<BridgePort, Object> portToVertexMap = new HashMap<BridgePort, Object>();
        for (BridgePort bp : segment.getBridgePortsOnSegment()) {
            LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, bp.getNodeId().toString());
            vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
            portToVertexMap.put(bp, (Object)vertex);
        }
        HashSet<String> nomappedmacs = new HashSet<String>();
        HashMap<String, LinkdVertex> macToVertexMap = new HashMap<String, LinkdVertex>();
        for (String mac : segment.getMacsOnSegment()) {
            OnmsSnmpInterface targetsnmpIface = this.m_macToOnmsSnmpMap.get(mac);
            if (targetsnmpIface != null) {
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetsnmpIface.getNode().getNodeId());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            OnmsIpInterface targetipIface = this.m_macToOnmsIpMap.get(mac);
            if (targetipIface != null) {
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, targetipIface.getNode().getNodeId());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            if (this.m_macToNodeidMap.containsKey(mac)) {
                Integer nodeid = this.m_macToNodeidMap.get(mac);
                LinkdVertex vertex = (LinkdVertex)this.getVertex(TOPOLOGY_NAMESPACE_LINKD, nodeid.toString());
                vertex.getProtocolSupported().add(ProtocolSupported.BRIDGE);
                macToVertexMap.put(mac, vertex);
                continue;
            }
            nomappedmacs.add(mac);
        }
        if (portToVertexMap.size() == 2 && segment.getMacsOnSegment().size() == 0) {
            source = null;
            target = null;
            sourcebp = null;
            BridgePort targetbp = null;
            for (BridgePort bp : portToVertexMap.keySet()) {
                if (bp.getNodeId() == segment.getDesignatedBridge()) {
                    source = (LinkdVertex)((Object)portToVertexMap.get(bp));
                    sourcebp = bp;
                    continue;
                }
                target = (LinkdVertex)((Object)portToVertexMap.get(bp));
                targetbp = bp;
            }
            OnmsSnmpInterface sourceSnmpInterface = this.getSnmpInterface(sourcebp.getNodeId(), sourcebp.getBridgePortIfIndex());
            OnmsSnmpInterface targetSnmpInterface = this.getSnmpInterface(targetbp.getNodeId(), targetbp.getBridgePortIfIndex());
            this.connectVertices(LinkdTopologyProvider.getEdgeId(sourcebp, targetbp), (AbstractVertex)source, (AbstractVertex)target, sourceSnmpInterface, targetSnmpInterface, "bp: " + sourcebp.getBridgePort(), "bp: " + targetbp.getBridgePort(), ProtocolSupported.BRIDGE);
            return;
        }
        if (portToVertexMap.size() == 1 && macToVertexMap.size() == 1 && segment.getMacsOnSegment().size() == 1) {
            source = (LinkdVertex)((Object)portToVertexMap.values().iterator().next());
            target = (LinkdVertex)((Object)macToVertexMap.values().iterator().next());
            sourcebp = (BridgePort)portToVertexMap.keySet().iterator().next();
            String targetmac = (String)macToVertexMap.keySet().iterator().next();
            OnmsSnmpInterface sourceinterface = this.getSnmpInterface(sourcebp.getNodeId(), sourcebp.getBridgePortIfIndex());
            targetinterface = this.m_macToOnmsSnmpMap.get(targetmac);
            OnmsIpInterface targetipinterface = this.m_macToOnmsIpMap.get(targetmac);
            StringBuffer targetAddr = new StringBuffer();
            targetAddr.append(targetmac);
            if (targetipinterface != null) {
                targetAddr.append(":");
                targetAddr.append(InetAddressUtils.str((InetAddress)targetipinterface.getIpAddress()));
            } else {
                targetAddr.append("Multiple ip addresses");
            }
            this.connectVertices(LinkdTopologyProvider.getEdgeId(sourcebp, targetmac), (AbstractVertex)source, (AbstractVertex)target, sourceinterface, targetinterface, "bp: " + sourcebp.getBridgePort(), targetAddr.toString(), ProtocolSupported.BRIDGE);
            return;
        }
        LinkdVertex topVertex = (LinkdVertex)((Object)portToVertexMap.get(segment.getDesignatedPort()));
        AbstractVertex cloudVertex = this.addVertex(LinkdTopologyProvider.getEdgeId(segment), 0, 0);
        if (nomappedmacs.size() > 0) {
            cloudVertex.setLabel("Multiple Mac Addresses");
        } else {
            cloudVertex.setLabel("");
        }
        cloudVertex.setIconKey("cloud");
        cloudVertex.setTooltipText("'Shared Segment' with designated up bridge: " + topVertex.getLabel() + " port: " + segment.getDesignatedPort().getBridgePort());
        this.addVertices(new Vertex[]{cloudVertex});
        LOG.debug("parseSegment: adding cloud: id: '{}', {}", (Object)cloudVertex.getId(), (Object)segment.printTopology());
        for (BridgePort bp : portToVertexMap.keySet()) {
            LinkdVertex bpportvertex = (LinkdVertex)((Object)portToVertexMap.get(bp));
            targetinterface = this.getSnmpInterface(bp.getNodeId(), bp.getBridgePortIfIndex());
            this.connectVertices(LinkdTopologyProvider.getEdgeId(cloudVertex, bp), cloudVertex, (AbstractVertex)bpportvertex, null, targetinterface, "shared segment: up bridge " + topVertex.getLabel() + " bp:" + segment.getDesignatedPort().getBridgePort(), "bp: " + bp.getBridgePort(), ProtocolSupported.BRIDGE);
        }
        for (String mac : macToVertexMap.keySet()) {
            LinkdVertex target2 = (LinkdVertex)((Object)macToVertexMap.get(mac));
            OnmsSnmpInterface targetiface = this.m_macToOnmsSnmpMap.get(mac);
            OnmsIpInterface targetipinterface = this.m_macToOnmsIpMap.get(mac);
            StringBuffer targetAddr = new StringBuffer();
            targetAddr.append(mac);
            if (targetipinterface != null) {
                targetAddr.append(":");
                targetAddr.append(InetAddressUtils.str((InetAddress)targetipinterface.getIpAddress()));
            } else {
                targetAddr.append("Multiple ip addresses");
            }
            this.connectVertices(LinkdTopologyProvider.getEdgeId(cloudVertex, mac), cloudVertex, (AbstractVertex)target2, null, targetiface, "shared segment: up bridge " + topVertex.getLabel() + " bp:" + segment.getDesignatedPort().getBridgePort(), targetAddr.toString(), ProtocolSupported.BRIDGE);
        }
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public TopologyEntityCache getTopologyEntityCache() {
        return this.m_topologyEntityCache;
    }

    public void setTopologyEntityCache(TopologyEntityCache topologyEntityCache) {
        this.m_topologyEntityCache = topologyEntityCache;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setTopologyDao(TopologyDao topologyDao) {
        this.m_topologyDao = topologyDao;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public IsIsElementDao getIsisElementDao() {
        return this.m_isisElementDao;
    }

    public void setIsisElementDao(IsIsElementDao isisElementDao) {
        this.m_isisElementDao = isisElementDao;
    }

    public BridgeTopologyDao getBridgeTopologyDao() {
        return this.m_bridgeTopologyDao;
    }

    public void setBridgeTopologyDao(BridgeTopologyDao bridgeTopologyDao) {
        this.m_bridgeTopologyDao = bridgeTopologyDao;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(1).withPreferredLayout("D3 Layout").withCriteria(() -> {
            Vertex defaultVertex;
            OnmsNode node = this.m_topologyDao.getDefaultFocusPoint();
            if (node != null && (defaultVertex = this.getVertex(TOPOLOGY_NAMESPACE_LINKD, node.getNodeId())) != null) {
                return Lists.newArrayList((Object[])new Criteria[]{LinkdHopCriteria.createCriteria(node.getNodeId(), node.getLabel())});
            }
            return Lists.newArrayList();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        Timer.Context vcontext = this.m_loadIpInterfacesTimer.time();
        HashMap<InetAddress, OnmsIpInterface> ipToOnmsIpMap = new HashMap<InetAddress, OnmsIpInterface>();
        HashSet<InetAddress> duplicated = new HashSet<InetAddress>();
        try {
            for (OnmsIpInterface ip : this.m_ipInterfaceDao.findAll()) {
                if (ip.getIsSnmpPrimary().equals((Object)PrimaryType.PRIMARY)) {
                    this.m_nodeToOnmsIpPrimaryMap.put(ip.getNode().getId(), ip);
                } else {
                    this.m_nodeToOnmsIpPrimaryMap.putIfAbsent(ip.getNode().getId(), ip);
                }
                if (!ipToOnmsIpMap.containsKey(ip.getIpAddress())) {
                    ipToOnmsIpMap.put(ip.getIpAddress(), ip);
                    continue;
                }
                duplicated.add(ip.getIpAddress());
                LOG.debug("refresh: found duplicated ip {}", (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
            }
            for (InetAddress ipdup : duplicated) {
                ipToOnmsIpMap.remove(ipdup);
            }
            LOG.info("refresh: Ip Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Loading Ip Interface failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadSnmpInterfacesTimer.time();
        try {
            for (OnmsSnmpInterface snmp : this.m_snmpInterfaceDao.findAll()) {
                int nodeId = snmp.getNode().getId();
                if (!this.m_nodeToOnmsSnmpMap.containsKey(nodeId)) {
                    this.m_nodeToOnmsSnmpMap.put(nodeId, new HashMap());
                }
                this.m_nodeToOnmsSnmpMap.get(nodeId).put(snmp.getIfIndex(), snmp);
            }
            LOG.info("refresh: Snmp Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Loading Snmp Interface failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadIpNetToMediaTimer.time();
        HashSet<String> multiIpMacs = new HashSet<String>();
        HashSet<String> multiSnmpMacs = new HashSet<String>();
        try {
            for (IpNetToMedia ipnettomedia : this.m_ipNetToMediaDao.findAll()) {
                OnmsIpInterface onmsip = (OnmsIpInterface)ipToOnmsIpMap.get(ipnettomedia.getNetAddress());
                if (onmsip == null) {
                    LOG.debug("refresh: ipNetToMedia: {}:{}. No OnmsIpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                    continue;
                }
                if (!this.m_macToNodeidMap.containsKey(ipnettomedia.getPhysAddress())) {
                    this.m_macToNodeidMap.put(ipnettomedia.getPhysAddress(), onmsip.getNodeId());
                }
                if (!this.m_macToOnmsIpMap.containsKey(ipnettomedia.getPhysAddress())) {
                    this.m_macToOnmsIpMap.put(ipnettomedia.getPhysAddress(), onmsip);
                } else {
                    multiIpMacs.add(ipnettomedia.getPhysAddress());
                    LOG.debug("refresh: ipNetToMedia: {}:{}. Multiple OnmsIpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                }
                for (OnmsSnmpInterface onmssnmp : this.m_nodeToOnmsSnmpMap.get(onmsip.getNodeId()).values()) {
                    if (onmssnmp.getId().intValue() != onmssnmp.getId().intValue()) continue;
                    if (!this.m_macToOnmsSnmpMap.containsKey(ipnettomedia.getPhysAddress())) {
                        this.m_macToOnmsSnmpMap.put(ipnettomedia.getPhysAddress(), onmssnmp);
                        continue;
                    }
                    if (this.m_macToOnmsSnmpMap.get(ipnettomedia.getPhysAddress()).getId().intValue() == onmssnmp.getId().intValue()) continue;
                    multiSnmpMacs.add(ipnettomedia.getPhysAddress());
                    LOG.debug("refresh: ipNetToMedia: {}:{}. Multiple OnmsSnmpInterface found.", (Object)ipnettomedia.getPhysAddress(), (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()));
                }
            }
            LOG.info("refresh: IpNetToMedia loaded");
        }
        catch (Exception e) {
            LOG.error("Loading ipNetToMedia failed: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadVerticesTimer.time();
        try {
            this.loadVertices();
            LOG.info("refresh: Loaded Vertices");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Vertices: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
        vcontext = this.m_loadEdgesTimer.time();
        try {
            this.loadEdges();
            LOG.info("refresh: Loaded Edges");
        }
        catch (Exception e) {
            LOG.error("Exception Loading Edges: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            vcontext.stop();
        }
    }

    public void refresh() {
        Timer.Context context = this.m_loadFullTimer.time();
        try {
            this.resetContainer();
            this.m_nodeToOnmsSnmpMap.clear();
            this.m_nodeToOnmsIpPrimaryMap.clear();
            this.m_macToNodeidMap.clear();
            this.m_macToOnmsIpMap.clear();
            this.m_macToOnmsSnmpMap.clear();
            this.doRefresh();
        }
        finally {
            context.stop();
        }
        LOG.info("refresh: Found {} groups", (Object)this.getGroups().size());
        LOG.info("refresh: Found {} vertices", (Object)this.getVerticesWithoutGroups().size());
        LOG.info("refresh: Found {} edges", (Object)this.getEdges(new Criteria[0]).size());
    }

    public static enum ProtocolSupported {
        LLDP,
        OSPF,
        ISIS,
        BRIDGE,
        CDP;

    }
}

