/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.AbstractTopologyProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Defaults;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.SimpleLeafVertex;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.TopologyDao;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractLinkdTopologyProvider
extends AbstractTopologyProvider
implements GraphProvider,
SearchProvider {
    public static final String TOPOLOGY_NAMESPACE_LINKD = "nodes";
    protected static final String HTML_TOOLTIP_TAG_OPEN = "<p>";
    protected static final String HTML_TOOLTIP_TAG_END = "</p>";
    protected static final DecimalFormat s_oneDigitAfterDecimal = new DecimalFormat("0.0##");
    protected static final DecimalFormat s_noDigitsAfterDecimal = new DecimalFormat("0");
    protected static final EnumMap<OnmsNode.NodeType, String> m_nodeStatusMap = new EnumMap(OnmsNode.NodeType.class);
    static final String[] OPER_ADMIN_STATUS;
    protected final boolean m_aclEnabled;
    protected TransactionOperations m_transactionOperations;
    protected NodeDao m_nodeDao;
    protected SnmpInterfaceDao m_snmpInterfaceDao;
    protected IpInterfaceDao m_ipInterfaceDao;
    protected TopologyDao m_topologyDao;
    protected FilterManager m_filterManager;
    protected boolean m_addNodeWithoutLink = false;
    protected LinkdHopCriteriaFactory m_criteriaHopFactory;

    protected AbstractLinkdTopologyProvider() {
        super(TOPOLOGY_NAMESPACE_LINKD);
        String aclsProp = System.getProperty("org.opennms.web.aclsEnabled");
        this.m_aclEnabled = aclsProp != null ? aclsProp.equals("true") : false;
    }

    protected static String getHumanReadableIfSpeed(long ifSpeed) {
        String units;
        double displaySpeed;
        DecimalFormat formatter;
        if (ifSpeed >= 1000000000L) {
            formatter = ifSpeed % 1000000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1.0E9;
            units = "Gbps";
        } else if (ifSpeed >= 1000000L) {
            formatter = ifSpeed % 1000000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000000.0;
            units = "Mbps";
        } else if (ifSpeed >= 1000L) {
            formatter = ifSpeed % 1000L == 0L ? s_noDigitsAfterDecimal : s_oneDigitAfterDecimal;
            displaySpeed = (double)ifSpeed / 1000.0;
            units = "kbps";
        } else {
            formatter = s_noDigitsAfterDecimal;
            displaySpeed = ifSpeed;
            units = "bps";
        }
        return formatter.format(displaySpeed) + " " + units;
    }

    public static String getIconName(String nodeSysObjectId) {
        if (nodeSysObjectId == null) {
            return "linkd.system";
        }
        if (nodeSysObjectId.startsWith(".")) {
            return "linkd.system.snmp" + nodeSysObjectId;
        }
        return "linkd.system.snmp." + nodeSysObjectId;
    }

    protected static String getNodeTooltipDefaultText(String ip, String label, boolean isManaged, String location, OnmsNode.NodeType nodeType) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
        tooltipText.append(label);
        tooltipText.append(": ");
        if (ip != null) {
            tooltipText.append("(");
            tooltipText.append(ip);
            tooltipText.append(")");
        }
        tooltipText.append("(");
        tooltipText.append(m_nodeStatusMap.get(nodeType));
        if (ip != null) {
            if (isManaged) {
                tooltipText.append("/Managed");
            } else {
                tooltipText.append("/Unmanaged");
            }
        }
        tooltipText.append(")");
        tooltipText.append(HTML_TOOLTIP_TAG_END);
        if (location != null && location.length() > 0) {
            tooltipText.append(HTML_TOOLTIP_TAG_OPEN);
            tooltipText.append(location);
            tooltipText.append(HTML_TOOLTIP_TAG_END);
        }
        return tooltipText.toString();
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    protected List<Vertex> getFilteredVertices() {
        if (this.isAclEnabled()) {
            List onmsNodes = this.getNodeDao().findAll();
            final List nodes = Lists.transform((List)onmsNodes, (Function)new Function<OnmsNode, Integer>(){

                public Integer apply(OnmsNode node) {
                    return node.getId();
                }
            });
            return Lists.newArrayList((Iterable)Collections2.filter((Collection)this.m_vertexProvider.getVertices(new Criteria[0]), (Predicate)new Predicate<Vertex>(){

                public boolean apply(Vertex vertex) {
                    return nodes.contains(vertex.getNodeID());
                }
            }));
        }
        return this.m_vertexProvider.getVertices(new Criteria[0]);
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setTopologyDao(TopologyDao topologyDao) {
        this.m_topologyDao = topologyDao;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public FilterManager getFilterManager() {
        return this.m_filterManager;
    }

    public void setAddNodeWithoutLink(boolean addNodeWithoutLink) {
        this.m_addNodeWithoutLink = addNodeWithoutLink;
    }

    public boolean isAddNodeWithoutLink() {
        return this.m_addNodeWithoutLink;
    }

    public boolean isAclEnabled() {
        return this.m_aclEnabled;
    }

    protected Map<Integer, String> getAllNodesNoACL() {
        if (this.getFilterManager().isEnabled()) {
            String[] userGroups = this.getFilterManager().getAuthorizationGroups();
            Map nodeLabelsById = null;
            try {
                this.getFilterManager().disableAuthorizationFilter();
                nodeLabelsById = this.getNodeDao().getAllLabelsById();
            }
            finally {
                if (userGroups != null) {
                    this.getFilterManager().enableAuthorizationFilter(userGroups);
                }
            }
            return nodeLabelsById != null ? nodeLabelsById : new HashMap();
        }
        return this.getNodeDao().getAllLabelsById();
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public LinkdHopCriteriaFactory getLinkdHopCriteriaFactory() {
        return this.m_criteriaHopFactory;
    }

    public void setLinkdHopCriteriaFactory(LinkdHopCriteriaFactory criteriaHopFactory) {
        this.m_criteriaHopFactory = criteriaHopFactory;
    }

    protected OnmsIpInterface getAddress(Integer nodeId) {
        OnmsIpInterface ip;
        block0: {
            OnmsIpInterface iterip;
            Iterator iterator;
            ip = this.getIpInterfaceDao().findPrimaryInterfaceByNodeId(nodeId);
            if (ip != null || !(iterator = this.getIpInterfaceDao().findByNodeId(nodeId).iterator()).hasNext()) break block0;
            ip = iterip = (OnmsIpInterface)iterator.next();
        }
        return ip;
    }

    protected AbstractVertex getDefaultVertex(Integer nodeId, String sysobjectId, String nodeLabel, String location, OnmsNode.NodeType nodeType, boolean isManaged, String ip) {
        return this.getVertex(nodeId, ip, sysobjectId, nodeLabel, AbstractLinkdTopologyProvider.getNodeTooltipDefaultText(ip, nodeLabel, isManaged, location, nodeType));
    }

    protected AbstractVertex getVertex(Integer nodeId, String ip, String sysobjectId, String nodeLabel, String tooltipText) {
        SimpleLeafVertex vertex = new SimpleLeafVertex(TOPOLOGY_NAMESPACE_LINKD, nodeId.toString(), Integer.valueOf(0), Integer.valueOf(0));
        vertex.setIconKey(AbstractLinkdTopologyProvider.getIconName(sysobjectId));
        vertex.setLabel(nodeLabel);
        vertex.setIpAddress(ip);
        vertex.setNodeID(nodeId);
        vertex.setTooltipText(tooltipText);
        return vertex;
    }

    public Defaults getDefaults() {
        return new Defaults().withSemanticZoomLevel(1).withPreferredLayout("D3 Layout").withCriteria(() -> {
            Vertex defaultVertex;
            OnmsNode node = this.m_topologyDao.getDefaultFocusPoint();
            if (node != null && (defaultVertex = this.createVertexFor(node, this.getAddress(node.getId()))) != null) {
                return Lists.newArrayList((Object[])new Criteria[]{new LinkdHopCriteria(node.getNodeId(), node.getLabel(), this.m_nodeDao)});
            }
            return Lists.newArrayList();
        });
    }

    protected Vertex createVertexFor(OnmsNode node, OnmsIpInterface ipInterface) {
        String ip = null;
        boolean isManaged = false;
        if (ipInterface != null && ipInterface.getIpAddress() != null) {
            ip = ipInterface.getIpAddress().getHostAddress();
            isManaged = ipInterface.isManaged();
        }
        return this.getVertex(node.getId(), ip, node.getSysObjectId(), node.getLabel(), AbstractLinkdTopologyProvider.getNodeTooltipDefaultText(ip, node.getLabel(), isManaged, node.getSysLocation(), node.getType()));
    }

    static {
        m_nodeStatusMap.put(OnmsNode.NodeType.ACTIVE, "Active");
        m_nodeStatusMap.put(OnmsNode.NodeType.UNKNOWN, "Unknown");
        m_nodeStatusMap.put(OnmsNode.NodeType.DELETED, "Deleted");
        OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    }

    private class LinkUnknownState
    extends AbstractLinkState {
        public LinkUnknownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && sourceInterface != null) {
                if (sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                } else {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
                }
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[4];
        }
    }

    private class LinkDownState
    extends AbstractLinkState {
        public LinkDownState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (targetInterface != null && targetInterface.getIfOperStatus() != null) {
                if (sourceInterface != null && sourceInterface.getIfOperStatus() == 1 && targetInterface.getIfOperStatus() == 1) {
                    this.getLinkStateMachine().setState(this.getLinkStateMachine().getUpState());
                }
            } else if (sourceInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[2];
        }
    }

    private class LinkUpState
    extends AbstractLinkState {
        public LinkUpState(LinkStateMachine linkStateMachine) {
            super(linkStateMachine);
        }

        @Override
        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            if (sourceInterface != null && sourceInterface.getIfOperStatus() != null && sourceInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (targetInterface != null && targetInterface.getIfOperStatus() != null && targetInterface.getIfOperStatus() != 1) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getDownState());
            }
            if (sourceInterface == null && targetInterface == null) {
                this.getLinkStateMachine().setState(this.getLinkStateMachine().getUnknownState());
            }
        }

        @Override
        public String getLinkStatus() {
            return OPER_ADMIN_STATUS[1];
        }
    }

    private abstract class AbstractLinkState
    implements LinkState {
        private LinkStateMachine m_linkStateMachine;

        public AbstractLinkState(LinkStateMachine linkStateMachine) {
            this.m_linkStateMachine = linkStateMachine;
        }

        protected LinkStateMachine getLinkStateMachine() {
            return this.m_linkStateMachine;
        }
    }

    protected class LinkStateMachine {
        LinkState m_upState;
        LinkState m_downState;
        LinkState m_unknownState;
        LinkState m_state;

        public LinkStateMachine() {
            this.m_upState = new LinkUpState(this);
            this.m_downState = new LinkDownState(this);
            this.m_unknownState = new LinkUnknownState(this);
            this.m_state = this.m_upState;
        }

        public void setParentInterfaces(OnmsSnmpInterface sourceInterface, OnmsSnmpInterface targetInterface) {
            this.m_state.setParentInterfaces(sourceInterface, targetInterface);
        }

        public String getLinkStatus() {
            return this.m_state.getLinkStatus();
        }

        public LinkState getUpState() {
            return this.m_upState;
        }

        public LinkState getDownState() {
            return this.m_downState;
        }

        public LinkState getUnknownState() {
            return this.m_unknownState;
        }

        public void setState(LinkState state) {
            this.m_state = state;
        }
    }

    private static interface LinkState {
        public void setParentInterfaces(OnmsSnmpInterface var1, OnmsSnmpInterface var2);

        public String getLinkStatus();
    }
}

