/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.SelectionAware;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.opennms.features.topology.api.support.VertexHopGraphProvider;
import org.opennms.features.topology.api.topo.AbstractSearchProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.SearchResult;
import org.opennms.features.topology.api.topo.SimpleConnector;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.AbstractLinkdTopologyProvider;
import org.opennms.features.topology.plugins.topo.linkd.internal.EnhancedLinkdSelectionAware;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdEdge;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteria;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdHopCriteriaFactory;
import org.opennms.netmgt.dao.api.BridgeBridgeLinkDao;
import org.opennms.netmgt.dao.api.BridgeMacLinkDao;
import org.opennms.netmgt.dao.api.BridgeTopologyDao;
import org.opennms.netmgt.dao.api.CdpElementDao;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.IsIsLinkDao;
import org.opennms.netmgt.dao.api.LldpElementDao;
import org.opennms.netmgt.dao.api.LldpLinkDao;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.topology.BridgePort;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.EdgeAlarmStatusSummary;
import org.opennms.netmgt.model.topology.IsisTopologyLink;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class EnhancedLinkdTopologyProvider
extends AbstractLinkdTopologyProvider {
    private static Logger LOG = LoggerFactory.getLogger(EnhancedLinkdTopologyProvider.class);
    static final String[] OPER_ADMIN_STATUS = new String[]{"&nbsp;", "Up", "Down", "Testing", "Unknown", "Dormant", "NotPresent", "LowerLayerDown"};
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;
    private CdpLinkDao m_cdpLinkDao;
    private CdpElementDao m_cdpElementDao;
    private OspfLinkDao m_ospfLinkDao;
    private IsIsLinkDao m_isisLinkDao;
    private BridgeBridgeLinkDao m_bridgeBridgeLinkDao;
    private BridgeMacLinkDao m_bridgeMacLinkDao;
    private BridgeTopologyDao m_bridgeTopologyDao;
    private IpNetToMediaDao m_ipNetToMediaDao;
    private SelectionAware selectionAwareDelegate = new EnhancedLinkdSelectionAware();
    public static final String LLDP_EDGE_NAMESPACE = "nodes::LLDP";
    public static final String OSPF_EDGE_NAMESPACE = "nodes::OSPF";
    public static final String ISIS_EDGE_NAMESPACE = "nodes::ISIS";
    public static final String BRIDGE_EDGE_NAMESPACE = "nodes::BRIDGE";
    public static final String CDP_EDGE_NAMESPACE = "nodes::CDP";
    private final Timer m_loadFullTimer;
    private final Timer m_loadNodesTimer;
    private final Timer m_loadIpInterfacesTimer;
    private final Timer m_loadSnmpInterfacesTimer;
    private final Timer m_loadIpNetToMediaTimer;
    private final Timer m_loadLldpLinksTimer;
    private final Timer m_loadOspfLinksTimer;
    private final Timer m_loadCdpLinksTimer;
    private final Timer m_loadIsisLinksTimer;
    private final Timer m_loadBridgeLinksTimer;
    private final Timer m_loadNoLinksTimer;
    private final Timer m_loadManualLinksTimer;

    public EnhancedLinkdTopologyProvider(MetricRegistry registry) {
        Objects.requireNonNull(registry);
        this.m_loadFullTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "full"}));
        this.m_loadNodesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "nodes"}));
        this.m_loadIpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipinterfaces"}));
        this.m_loadSnmpInterfacesTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "snmpinterfaces"}));
        this.m_loadIpNetToMediaTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "ipnettomedia"}));
        this.m_loadLldpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "lldp"}));
        this.m_loadOspfLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "ospf"}));
        this.m_loadCdpLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "cdp"}));
        this.m_loadIsisLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "isis"}));
        this.m_loadBridgeLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "bridge"}));
        this.m_loadNoLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "none"}));
        this.m_loadManualLinksTimer = registry.timer(MetricRegistry.name((String)"enlinkd", (String[])new String[]{"load", "links", "manual"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompleteTopology() throws MalformedURLException, JAXBException {
        try {
            this.resetContainer();
        }
        catch (Exception e) {
            LOG.error("Exception reset Container: " + e.getMessage(), (Throwable)e);
        }
        HashMap<Integer, OnmsNode> nodemap = new HashMap<Integer, OnmsNode>();
        HashMap<Integer, List<OnmsIpInterface>> nodeipmap = new HashMap<Integer, List<OnmsIpInterface>>();
        HashMap<Integer, OnmsIpInterface> nodeipprimarymap = new HashMap<Integer, OnmsIpInterface>();
        HashMap<String, List<OnmsIpInterface>> macipmap = new HashMap<String, List<OnmsIpInterface>>();
        HashMap<InetAddress, OnmsIpInterface> ipmap = new HashMap<InetAddress, OnmsIpInterface>();
        HashMap<Integer, List<OnmsSnmpInterface>> nodesnmpmap = new HashMap<Integer, List<OnmsSnmpInterface>>();
        Timer.Context context = this.m_loadNodesTimer.time();
        try {
            LOG.info("Loading nodes");
            for (Object node : this.m_nodeDao.findAll()) {
                nodemap.put(node.getId(), (OnmsNode)node);
            }
            LOG.info("Nodes loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting node list: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIpInterfacesTimer.time();
        try {
            LOG.info("Loading Ip Interface");
            HashSet<InetAddress> duplicatedips = new HashSet<InetAddress>();
            for (OnmsIpInterface ip : this.m_ipInterfaceDao.findAll()) {
                if (!nodeipmap.containsKey(ip.getNode().getId())) {
                    nodeipmap.put(ip.getNode().getId(), new ArrayList());
                    nodeipprimarymap.put(ip.getNode().getId(), ip);
                }
                ((List)nodeipmap.get(ip.getNode().getId())).add(ip);
                if (ip.getIsSnmpPrimary().equals((Object)PrimaryType.PRIMARY)) {
                    nodeipprimarymap.put(ip.getNode().getId(), ip);
                }
                if (duplicatedips.contains(ip.getIpAddress())) {
                    LOG.info("Loading ip Interface, found duplicated ip {}, skipping ", (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
                    continue;
                }
                if (ipmap.containsKey(ip.getIpAddress())) {
                    LOG.info("Loading ip Interface, found duplicated ip {}, skipping ", (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
                    duplicatedips.add(ip.getIpAddress());
                    continue;
                }
                ipmap.put(ip.getIpAddress(), ip);
            }
            for (InetAddress duplicated : duplicatedips) {
                ipmap.remove(duplicated);
            }
            LOG.info("Ip Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting ip list: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadSnmpInterfacesTimer.time();
        try {
            LOG.info("Loading Snmp Interface");
            for (OnmsSnmpInterface snmp : this.m_snmpInterfaceDao.findAll()) {
                int nodeId = snmp.getNode().getId();
                ArrayList<OnmsSnmpInterface> snmpinterfaces = (ArrayList<OnmsSnmpInterface>)nodesnmpmap.get(nodeId);
                if (snmpinterfaces == null) {
                    snmpinterfaces = new ArrayList<OnmsSnmpInterface>();
                    nodesnmpmap.put(nodeId, snmpinterfaces);
                }
                snmpinterfaces.add(snmp);
            }
            LOG.info("Snmp Interface loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting snmp interface list: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIpNetToMediaTimer.time();
        try {
            HashSet<String> duplicatednodemac = new HashSet<String>();
            HashMap<String, Integer> mactonodemap = new HashMap<String, Integer>();
            LOG.info("Loading ip net to media");
            for (IpNetToMedia ipnettomedia : this.m_ipNetToMediaDao.findAll()) {
                if (duplicatednodemac.contains(ipnettomedia.getPhysAddress())) {
                    LOG.info("load ip net media: different nodeid found for ip: {} mac: {}. Skipping...", (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()), (Object)ipnettomedia.getPhysAddress());
                    continue;
                }
                OnmsIpInterface ip = (OnmsIpInterface)ipmap.get(ipnettomedia.getNetAddress());
                if (ip == null) {
                    LOG.info("load ip net media: no nodeid found for ip: {} mac: {}. Skipping...", (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()), (Object)ipnettomedia.getPhysAddress());
                    continue;
                }
                if (mactonodemap.containsKey(ipnettomedia.getPhysAddress()) && ((Integer)mactonodemap.get(ipnettomedia.getPhysAddress())).intValue() != ip.getNode().getId().intValue()) {
                    LOG.info("load ip net media: different nodeid found for ip: {} mac: {}. Skipping...", (Object)InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress()), (Object)ipnettomedia.getPhysAddress());
                    duplicatednodemac.add(ipnettomedia.getPhysAddress());
                    continue;
                }
                if (!macipmap.containsKey(ipnettomedia.getPhysAddress())) {
                    macipmap.put(ipnettomedia.getPhysAddress(), new ArrayList());
                    mactonodemap.put(ipnettomedia.getPhysAddress(), ip.getNode().getId());
                }
                ((List)macipmap.get(ipnettomedia.getPhysAddress())).add(ip);
            }
            for (String dupmac : duplicatednodemac) {
                macipmap.remove(dupmac);
            }
            LOG.info("Ip net to media loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting ip net to media list: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadLldpLinksTimer.time();
        try {
            LOG.info("Loading Lldp link");
            this.getLldpLinks(nodemap, nodesnmpmap, nodeipprimarymap);
            LOG.info("Lldp link loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting Lldp link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadOspfLinksTimer.time();
        try {
            LOG.info("Loading Ospf link");
            this.getOspfLinks(nodemap, nodesnmpmap, nodeipprimarymap);
            LOG.info("Ospf link loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting Ospf link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadIsisLinksTimer.time();
        try {
            LOG.info("Loading Cdp link");
            this.getCdpLinks(nodemap, nodesnmpmap, nodeipprimarymap, ipmap);
            LOG.info("Cdp link loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting Cdp link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadCdpLinksTimer.time();
        try {
            LOG.info("Loading IsIs link");
            this.getIsIsLinks(nodesnmpmap, nodeipprimarymap);
            LOG.info("IsIs link loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting IsIs link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadBridgeLinksTimer.time();
        try {
            LOG.info("Loading Bridge link");
            this.getBridgeLinks(nodemap, nodesnmpmap, macipmap, nodeipmap, nodeipprimarymap);
            LOG.info("Bridge link loaded");
        }
        catch (Exception e) {
            LOG.error("Exception getting Bridge link: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
        context = this.m_loadNoLinksTimer.time();
        try {
            LOG.debug("loadtopology: adding nodes without links: " + this.isAddNodeWithoutLink());
            if (this.isAddNodeWithoutLink()) {
                this.addNodesWithoutLinks(nodemap, nodeipmap, nodeipprimarymap);
            }
        }
        finally {
            context.stop();
        }
        LOG.debug("Found {} groups", (Object)this.getGroups().size());
        LOG.debug("Found {} vertices", (Object)this.getVerticesWithoutGroups().size());
        LOG.debug("Found {} edges", (Object)this.getEdges(new Criteria[0]).size());
    }

    protected final Vertex getOrCreateVertex(OnmsNode sourceNode, OnmsIpInterface primary) {
        Vertex source = this.getVertex(this.getNamespace(), sourceNode.getNodeId());
        if (source == null) {
            source = this.getDefaultVertex(sourceNode.getId(), sourceNode.getSysObjectId(), sourceNode.getLabel(), sourceNode.getSysLocation(), sourceNode.getType(), primary.isManaged(), InetAddressUtils.str((InetAddress)primary.getIpAddress()));
            this.addVertices(new Vertex[]{source});
        }
        return source;
    }

    protected final LinkdEdge connectCloudMacVertices(String targetmac, VertexRef sourceRef, VertexRef targetRef, String nameSpace) {
        SimpleConnector source = new SimpleConnector(sourceRef.getNamespace(), sourceRef.getId() + "-" + targetRef.getId() + "-connector", sourceRef);
        SimpleConnector target = new SimpleConnector(targetRef.getNamespace(), targetRef.getId() + "-" + sourceRef.getId() + "-connector", targetRef);
        LinkdEdge edge = new LinkdEdge(nameSpace, targetRef.getId() + ":" + targetmac, source, target);
        edge.setTargetEndPoint(targetmac);
        this.addEdges(new Edge[]{edge});
        return edge;
    }

    protected final LinkdEdge connectVertices(BridgePort targetport, VertexRef sourceRef, VertexRef targetRef, String nameSpace) {
        SimpleConnector source = new SimpleConnector(sourceRef.getNamespace(), sourceRef.getId() + "-" + targetRef.getId() + "-connector", sourceRef);
        SimpleConnector target = new SimpleConnector(targetRef.getNamespace(), targetRef.getId() + "-" + sourceRef.getId() + "-connector", targetRef);
        LinkdEdge edge = new LinkdEdge(nameSpace, targetRef.getId() + ":" + targetport.getBridgePort(), source, target);
        edge.setTargetNodeid(targetport.getNode().getId());
        if (targetport.getBridgePortIfIndex() != null) {
            edge.setTargetEndPoint(String.valueOf(targetport.getBridgePortIfIndex()));
        }
        this.addEdges(new Edge[]{edge});
        return edge;
    }

    protected final LinkdEdge connectVertices(BridgeMacLink link, VertexRef sourceRef, VertexRef targetRef, String nameSpace) {
        SimpleConnector source = new SimpleConnector(sourceRef.getNamespace(), sourceRef.getId() + "-" + link.getId() + "-connector", sourceRef);
        SimpleConnector target = new SimpleConnector(targetRef.getNamespace(), targetRef.getId() + "-" + link.getId() + "-connector", targetRef);
        LinkdEdge edge = new LinkdEdge(nameSpace, String.valueOf(link.getId()), source, target);
        edge.setSourceNodeid(link.getNode().getId());
        if (link.getBridgePortIfIndex() != null) {
            edge.setSourceEndPoint(String.valueOf(link.getBridgePortIfIndex()));
        }
        edge.setTargetEndPoint(String.valueOf(link.getMacAddress()));
        this.addEdges(new Edge[]{edge});
        return edge;
    }

    protected final LinkdEdge connectVertices(LinkDetail<?> linkdetail, String nameSpace) {
        SimpleConnector source = new SimpleConnector(linkdetail.getSource().getNamespace(), linkdetail.getSource().getId() + "-" + linkdetail.getId() + "-connector", (VertexRef)linkdetail.getSource());
        SimpleConnector target = new SimpleConnector(linkdetail.getTarget().getNamespace(), linkdetail.getTarget().getId() + "-" + linkdetail.getId() + "-connector", (VertexRef)linkdetail.getTarget());
        LinkdEdge edge = new LinkdEdge(nameSpace, linkdetail.getId(), source, target);
        try {
            edge.setSourceNodeid(Integer.parseInt(linkdetail.getSource().getId()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            edge.setTargetNodeid(Integer.parseInt(linkdetail.getTarget().getId()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (linkdetail.getSourceIfIndex() != null) {
            edge.setSourceEndPoint(String.valueOf(linkdetail.getSourceIfIndex()));
        }
        if (linkdetail.getTargetIfIndex() != null) {
            edge.setTargetEndPoint(String.valueOf(linkdetail.getTargetIfIndex()));
        }
        this.addEdges(new Edge[]{edge});
        return edge;
    }

    private void getLldpLinks(Map<Integer, OnmsNode> nodemap, Map<Integer, List<OnmsSnmpInterface>> nodesnmpmap, Map<Integer, OnmsIpInterface> ipprimarymap) {
        HashMap<String, OnmsNode> nodesbysysname = new HashMap<String, OnmsNode>();
        for (OnmsNode onmsNode : nodemap.values()) {
            if (onmsNode.getSysName() == null) continue;
            nodesbysysname.putIfAbsent(onmsNode.getSysName(), onmsNode);
        }
        HashMap<Integer, LldpElement> lldpelementmap = new HashMap<Integer, LldpElement>();
        for (LldpElement lldpelement : this.m_lldpElementDao.findAll()) {
            lldpelementmap.put(lldpelement.getNode().getId(), lldpelement);
        }
        List list = this.m_lldpLinkDao.findAll();
        HashMap<String, List<Object>> linksByRemoteChassisId = new HashMap<String, List<Object>>();
        for (LldpLink link : list) {
            String remoteChassisId = link.getLldpRemChassisId();
            ArrayList<LldpLink> linksWithRemoteChassisId = (ArrayList<LldpLink>)linksByRemoteChassisId.get(remoteChassisId);
            if (linksWithRemoteChassisId == null) {
                linksWithRemoteChassisId = new ArrayList<LldpLink>();
                linksByRemoteChassisId.put(remoteChassisId, linksWithRemoteChassisId);
            }
            linksWithRemoteChassisId.add(link);
        }
        HashSet<LldpLinkDetail> combinedLinkDetails = new HashSet<LldpLinkDetail>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (LldpLink sourceLink : list) {
            OnmsNode node;
            if (parsed.contains(sourceLink.getId())) continue;
            LOG.debug("loadtopology: lldp link with id '{}' link '{}' ", (Object)sourceLink.getId(), (Object)sourceLink);
            LldpElement sourceLldpElement = (LldpElement)lldpelementmap.get(sourceLink.getNode().getId());
            LldpLink targetLink = null;
            for (LldpLink link : linksByRemoteChassisId.getOrDefault(sourceLldpElement.getLldpChassisId(), Collections.emptyList())) {
                boolean bool3;
                if (parsed.contains(link.getId()) || sourceLink.getId().intValue() == link.getId().intValue()) continue;
                LOG.debug("loadtopology: checking lldp link with id '{}' link '{}' ", (Object)link.getId(), (Object)link);
                LldpElement element = (LldpElement)lldpelementmap.get(link.getNode().getId());
                if (!sourceLink.getLldpRemChassisId().equals(element.getLldpChassisId())) continue;
                boolean bool1 = sourceLink.getLldpRemPortId().equals(link.getLldpPortId()) && link.getLldpRemPortId().equals(sourceLink.getLldpPortId());
                boolean bl = bool3 = sourceLink.getLldpRemPortIdSubType() == link.getLldpPortIdSubType() && link.getLldpRemPortIdSubType() == sourceLink.getLldpPortIdSubType();
                if (!bool1 || !bool3) continue;
                targetLink = link;
                LOG.info("loadtopology: found lldp mutual link: '{}' and '{}' ", (Object)sourceLink, (Object)targetLink);
                break;
            }
            if (targetLink == null && sourceLink.getLldpRemSysname() != null && (node = (OnmsNode)nodesbysysname.get(sourceLink.getLldpRemSysname())) != null) {
                targetLink = this.reverseLldpLink(node, sourceLldpElement, sourceLink);
                LOG.info("loadtopology: found lldp link using lldp rem sysname: '{}' and '{}'", (Object)sourceLink, (Object)targetLink);
            }
            if (targetLink == null) {
                LOG.info("loadtopology: cannot found target node for link: '{}'", (Object)sourceLink);
                continue;
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            Vertex source = this.getOrCreateVertex(nodemap.get(sourceLink.getNode().getId()), ipprimarymap.get(sourceLink.getNode().getId()));
            Vertex target = this.getOrCreateVertex(nodemap.get(targetLink.getNode().getId()), ipprimarymap.get(targetLink.getNode().getId()));
            combinedLinkDetails.add(new LldpLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink));
        }
        for (LldpLinkDetail linkDetail : combinedLinkDetails) {
            LinkdEdge edge = this.connectVertices(linkDetail, LLDP_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail, nodesnmpmap));
        }
    }

    private void getOspfLinks(Map<Integer, OnmsNode> nodemap, Map<Integer, List<OnmsSnmpInterface>> nodesnmpmap, Map<Integer, OnmsIpInterface> ipprimarymap) {
        List allLinks = this.getOspfLinkDao().findAll();
        HashSet<OspfLinkDetail> combinedLinkDetails = new HashSet<OspfLinkDetail>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        block0: for (OspfLink sourceLink : allLinks) {
            if (parsed.contains(sourceLink.getId())) continue;
            LOG.debug("loadtopology: ospf link with id '{}'", (Object)sourceLink.getId());
            for (OspfLink targetLink : allLinks) {
                if (sourceLink.getId().intValue() == targetLink.getId().intValue() || parsed.contains(targetLink.getId())) continue;
                LOG.debug("loadtopology: checking ospf link with id '{}'", (Object)targetLink.getId());
                if (!sourceLink.getOspfRemIpAddr().equals(targetLink.getOspfIpAddr()) || !targetLink.getOspfRemIpAddr().equals(sourceLink.getOspfIpAddr())) continue;
                LOG.info("loadtopology: found ospf mutual link: '{}' and '{}' ", (Object)sourceLink, (Object)targetLink);
                parsed.add(sourceLink.getId());
                parsed.add(targetLink.getId());
                Vertex source = this.getOrCreateVertex(nodemap.get(sourceLink.getNode().getId()), ipprimarymap.get(sourceLink.getNode().getId()));
                Vertex target = this.getOrCreateVertex(nodemap.get(targetLink.getNode().getId()), ipprimarymap.get(targetLink.getNode().getId()));
                OspfLinkDetail linkDetail = new OspfLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink);
                combinedLinkDetails.add(linkDetail);
                continue block0;
            }
        }
        for (OspfLinkDetail linkDetail : combinedLinkDetails) {
            LinkdEdge edge = this.connectVertices(linkDetail, OSPF_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail, nodesnmpmap));
        }
    }

    private void getCdpLinks(Map<Integer, OnmsNode> nodemap, Map<Integer, List<OnmsSnmpInterface>> nodesnmpmap, Map<Integer, OnmsIpInterface> ipprimarymap, Map<InetAddress, OnmsIpInterface> ipmap) {
        HashMap<Integer, CdpElement> cdpelementmap = new HashMap<Integer, CdpElement>();
        for (CdpElement cdpelement : this.m_cdpElementDao.findAll()) {
            cdpelementmap.put(cdpelement.getNode().getId(), cdpelement);
        }
        List allLinks = this.m_cdpLinkDao.findAll();
        HashSet<CdpLinkDetail> combinedLinkDetails = new HashSet<CdpLinkDetail>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        for (CdpLink sourceLink : allLinks) {
            if (parsed.contains(sourceLink.getId())) continue;
            LOG.debug("loadtopology: cdp link with id '{}' link '{}' ", (Object)sourceLink.getId(), (Object)sourceLink);
            CdpElement sourceCdpElement = (CdpElement)cdpelementmap.get(sourceLink.getNode().getId());
            CdpLink targetLink = null;
            for (CdpLink link : allLinks) {
                if (sourceLink.getId().intValue() == link.getId().intValue() || parsed.contains(link.getId())) continue;
                LOG.debug("loadtopology: checking cdp link with id '{}' link '{}' ", (Object)link.getId(), (Object)link);
                CdpElement element = (CdpElement)cdpelementmap.get(link.getNode().getId());
                if (!sourceLink.getCdpCacheDeviceId().equals(element.getCdpGlobalDeviceId()) || !link.getCdpCacheDeviceId().equals(sourceCdpElement.getCdpGlobalDeviceId()) || !sourceLink.getCdpInterfaceName().equals(link.getCdpCacheDevicePort()) || !link.getCdpInterfaceName().equals(sourceLink.getCdpCacheDevicePort())) continue;
                targetLink = link;
                LOG.info("loadtopology: found cdp mutual link: '{}' and '{}' ", (Object)sourceLink, (Object)targetLink);
                break;
            }
            if (targetLink == null && sourceLink.getCdpCacheAddressType() == CdpLink.CiscoNetworkProtocolType.ip) {
                try {
                    InetAddress targetAddress = InetAddressUtils.addr((String)sourceLink.getCdpCacheAddress());
                    if (ipmap.containsKey(targetAddress)) {
                        targetLink = this.reverseCdpLink(ipmap.get(targetAddress), sourceCdpElement, sourceLink);
                        LOG.info("loadtopology: found cdp link using cdp cache address: '{}' and '{}'", (Object)sourceLink, (Object)targetLink);
                    }
                }
                catch (Exception e) {
                    LOG.warn("loadtopology: cannot convert ip address: {}", (Object)sourceLink.getCdpCacheAddress(), (Object)e);
                }
            }
            if (targetLink == null) {
                LOG.info("loadtopology: cannot found target node for link: '{}'", (Object)sourceLink);
                continue;
            }
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            Vertex source = this.getOrCreateVertex(nodemap.get(sourceLink.getNode().getId()), ipprimarymap.get(sourceLink.getNode().getId()));
            Vertex target = this.getOrCreateVertex(nodemap.get(targetLink.getNode().getId()), ipprimarymap.get(targetLink.getNode().getId()));
            combinedLinkDetails.add(new CdpLinkDetail(Math.min(sourceLink.getId(), targetLink.getId()) + "|" + Math.max(sourceLink.getId(), targetLink.getId()), source, sourceLink, target, targetLink));
        }
        for (CdpLinkDetail linkDetail : combinedLinkDetails) {
            LinkdEdge edge = this.connectVertices(linkDetail, CDP_EDGE_NAMESPACE);
            edge.setTooltipText(this.getEdgeTooltipText(linkDetail, nodesnmpmap));
        }
    }

    private void getIsIsLinks(Map<Integer, List<OnmsSnmpInterface>> nodesnmpmap, Map<Integer, OnmsIpInterface> ipprimarymap) {
        List isislinks = this.m_isisLinkDao.getLinksForTopology();
        if (isislinks != null && isislinks.size() > 0) {
            for (IsisTopologyLink link : isislinks) {
                Vertex target;
                LOG.debug("loadtopology: adding isis link: '{}'", (Object)link);
                String id = Math.min(link.getSourceId(), link.getTargetId()) + "|" + Math.max(link.getSourceId(), link.getTargetId());
                Vertex source = this.getVertex(this.getNamespace(), link.getSrcNodeId().toString());
                if (source == null) {
                    OnmsIpInterface primary = ipprimarymap.get(link.getSrcNodeId());
                    source = this.getDefaultVertex(link.getSrcNodeId(), link.getSrcSysoid(), link.getSrcLabel(), link.getSrcLocation(), link.getSrcNodeType(), primary.isManaged(), InetAddressUtils.str((InetAddress)primary.getIpAddress()));
                    this.addVertices(new Vertex[]{source});
                }
                if ((target = this.getVertex(this.getNamespace(), link.getTargetNodeId().toString())) == null) {
                    OnmsIpInterface targetprimary = ipprimarymap.get(link.getSrcNodeId());
                    target = this.getDefaultVertex(link.getTargetNodeId(), link.getTargetSysoid(), link.getTargetLabel(), link.getTargetLocation(), link.getTargetNodeType(), targetprimary.isManaged(), InetAddressUtils.str((InetAddress)targetprimary.getIpAddress()));
                    this.addVertices(new Vertex[]{target});
                }
                IsIsLinkDetail linkDetail = new IsIsLinkDetail(id, source, link.getSourceId(), link.getSrcIfIndex(), target, link.getTargetId(), link.getTargetIfIndex());
                LinkdEdge edge = this.connectVertices(linkDetail, ISIS_EDGE_NAMESPACE);
                edge.setTooltipText(this.getEdgeTooltipText(linkDetail, nodesnmpmap));
            }
        }
    }

    private void getBridgeLinks(Map<Integer, OnmsNode> nodemap, Map<Integer, List<OnmsSnmpInterface>> nodesnmpmap, Map<String, List<OnmsIpInterface>> macToIpMap, Map<Integer, List<OnmsIpInterface>> ipmap, Map<Integer, OnmsIpInterface> ipprimarymap) {
        for (BroadcastDomain domain : this.m_bridgeTopologyDao.getAllPersisted(this.m_bridgeBridgeLinkDao, this.m_bridgeMacLinkDao)) {
            LOG.info("loadtopology: parsing broadcast Domain: '{}', {}", (Object)domain);
            for (SharedSegment segment : domain.getTopology()) {
                LinkdEdge edge;
                if (segment.noMacsOnSegment() && segment.getBridgeBridgeLinks().size() == 1) {
                    for (BridgeBridgeLink link : segment.getBridgeBridgeLinks()) {
                        Vertex source = this.getOrCreateVertex(nodemap.get(link.getNode().getId()), ipprimarymap.get(link.getNode().getId()));
                        Vertex target = this.getOrCreateVertex(nodemap.get(link.getDesignatedNode().getId()), ipprimarymap.get(link.getDesignatedNode().getId()));
                        BridgeLinkDetail detail = new BridgeLinkDetail("nodes", source, link.getBridgePortIfIndex(), target, link.getDesignatedPortIfIndex(), link.getBridgePort(), link.getDesignatedPort(), link.getId(), link.getId());
                        edge = this.connectVertices(detail, BRIDGE_EDGE_NAMESPACE);
                        edge.setTooltipText(this.getEdgeTooltipText(detail, nodesnmpmap));
                    }
                    continue;
                }
                if (segment.getBridgeMacLinks().size() == 1 && segment.getBridgeBridgeLinks().size() == 0) {
                    for (BridgeMacLink sourcelink : segment.getBridgeMacLinks()) {
                        if (!macToIpMap.containsKey(sourcelink.getMacAddress()) || macToIpMap.get(sourcelink.getMacAddress()).size() <= 0) continue;
                        List<OnmsIpInterface> targetInterfaces = macToIpMap.get(sourcelink.getMacAddress());
                        OnmsIpInterface targetIp = targetInterfaces.get(0);
                        if (segment.getBridgeIdsOnSegment().contains(targetIp.getNode().getId())) continue;
                        Vertex source = this.getOrCreateVertex(nodemap.get(sourcelink.getNode().getId()), ipprimarymap.get(sourcelink.getNode().getId()));
                        Vertex target = this.getOrCreateVertex(nodemap.get(targetIp.getNode().getId()), ipprimarymap.get(targetIp.getNode().getId()));
                        LinkdEdge edge2 = this.connectVertices(sourcelink, (VertexRef)source, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                        edge2.setTooltipText(this.getEdgeTooltipText(sourcelink, source, target, targetInterfaces, nodesnmpmap));
                    }
                    continue;
                }
                String cloudId = segment.getDesignatedBridge() + ":" + segment.getDesignatedPort();
                AbstractVertex cloudVertex = this.addVertex(cloudId, 0, 0);
                cloudVertex.setLabel("");
                cloudVertex.setIconKey("cloud");
                cloudVertex.setTooltipText("Shared Segment: " + nodemap.get(segment.getDesignatedBridge()).getLabel() + " port: " + segment.getDesignatedPort());
                this.addVertices(new Vertex[]{cloudVertex});
                LOG.info("loadtopology: adding cloud: id: '{}', {}", (Object)cloudId, (Object)cloudVertex.getTooltipText());
                for (BridgePort targetport : segment.getBridgePortsOnSegment()) {
                    Vertex target = this.getOrCreateVertex(nodemap.get(targetport.getNode().getId()), ipprimarymap.get(targetport.getNode().getId()));
                    edge = this.connectVertices(targetport, (VertexRef)cloudVertex, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                    edge.setTooltipText(this.getEdgeTooltipText(targetport, target, nodesnmpmap));
                }
                for (String targetmac : segment.getMacsOnSegment()) {
                    if (!macToIpMap.containsKey(targetmac) || macToIpMap.get(targetmac).size() <= 0) continue;
                    List<OnmsIpInterface> targetInterfaces = macToIpMap.get(targetmac);
                    OnmsIpInterface targetIp = targetInterfaces.get(0);
                    if (segment.getBridgeIdsOnSegment().contains(targetIp.getNode().getId())) continue;
                    Vertex target = this.getOrCreateVertex(nodemap.get(targetIp.getNode().getId()), ipprimarymap.get(targetIp.getNode().getId()));
                    LinkdEdge edge3 = this.connectCloudMacVertices(targetmac, (VertexRef)cloudVertex, (VertexRef)target, BRIDGE_EDGE_NAMESPACE);
                    edge3.setTooltipText(this.getEdgeTooltipText(targetmac, target, targetInterfaces));
                }
            }
        }
    }

    private void addNodesWithoutLinks(Map<Integer, OnmsNode> nodemap, Map<Integer, List<OnmsIpInterface>> nodeipmap, Map<Integer, OnmsIpInterface> nodeipprimarymap) {
        for (Map.Entry<Integer, OnmsNode> entry : nodemap.entrySet()) {
            List ipInterfaces;
            Integer nodeId = entry.getKey();
            OnmsNode node = entry.getValue();
            if (this.getVertex(this.getNamespace(), nodeId.toString()) != null) continue;
            LOG.debug("Adding link-less node: {}", (Object)node.getLabel());
            OnmsIpInterface ipInterface = nodeipprimarymap.get(nodeId);
            if (ipInterface == null && (ipInterfaces = nodeipmap.getOrDefault(nodeId, Collections.emptyList())).size() > 0) {
                ipInterfaces.get(0);
            }
            this.addVertices(new Vertex[]{this.createVertexFor(node, ipInterface)});
        }
    }

    @Transactional
    public void refresh() {
        Timer.Context context = this.m_loadFullTimer.time();
        try {
            this.loadCompleteTopology();
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            context.stop();
        }
    }

    private String getEdgeTooltipText(BridgeMacLink sourcelink, Vertex source, Vertex target, List<OnmsIpInterface> targetInterfaces, Map<Integer, List<OnmsSnmpInterface>> snmpmap) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append("<p>");
        tooltipText.append("Bridge Layer2");
        tooltipText.append("</p>");
        OnmsSnmpInterface sourceInterface = this.getByNodeIdAndIfIndex(sourcelink.getBridgePortIfIndex(), target, snmpmap);
        tooltipText.append("<p>");
        tooltipText.append(source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append("(");
            tooltipText.append(sourceInterface.getIfName());
            tooltipText.append(")");
        }
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(target.getLabel());
        tooltipText.append("(");
        tooltipText.append(sourcelink.getMacAddress());
        tooltipText.append(")");
        tooltipText.append("(");
        if (targetInterfaces.size() == 1) {
            tooltipText.append(InetAddressUtils.str((InetAddress)targetInterfaces.get(0).getIpAddress()));
        } else if (targetInterfaces.size() > 1) {
            tooltipText.append("Multiple ip Addresses ");
        } else {
            tooltipText.append("No ip Address found");
        }
        tooltipText.append(")");
        tooltipText.append("</p>");
        if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append("<p>");
            tooltipText.append(EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append("</p>");
        }
        return tooltipText.toString();
    }

    private String getEdgeTooltipText(String mac, Vertex target, List<OnmsIpInterface> ipifaces) {
        StringBuffer tooltipText = new StringBuffer();
        tooltipText.append("<p>");
        tooltipText.append("Bridge Layer2");
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(target.getLabel());
        tooltipText.append("(");
        tooltipText.append(mac);
        tooltipText.append(")");
        tooltipText.append("(");
        if (ipifaces.size() == 1) {
            tooltipText.append(InetAddressUtils.str((InetAddress)ipifaces.get(0).getIpAddress()));
        } else if (ipifaces.size() > 1) {
            tooltipText.append("Multiple ip Addresses ");
        } else {
            tooltipText.append("No ip Address found");
        }
        tooltipText.append(")");
        tooltipText.append("</p>");
        return tooltipText.toString();
    }

    private String getEdgeTooltipText(BridgePort port, Vertex target, Map<Integer, List<OnmsSnmpInterface>> snmpmap) {
        StringBuffer tooltipText = new StringBuffer();
        OnmsSnmpInterface targetInterface = this.getByNodeIdAndIfIndex(port.getBridgePortIfIndex(), target, snmpmap);
        tooltipText.append("<p>");
        tooltipText.append("Bridge Layer2");
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(target.getLabel());
        if (targetInterface != null) {
            tooltipText.append("(");
            tooltipText.append(targetInterface.getIfName());
            tooltipText.append(")");
        }
        tooltipText.append("</p>");
        if (targetInterface != null && targetInterface.getIfSpeed() != null) {
            tooltipText.append("<p>");
            tooltipText.append(EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
            tooltipText.append("</p>");
        }
        return tooltipText.toString();
    }

    private String getEdgeTooltipText(LinkDetail<?> linkDetail, Map<Integer, List<OnmsSnmpInterface>> snmpmap) {
        StringBuffer tooltipText = new StringBuffer();
        Vertex source = linkDetail.getSource();
        Vertex target = linkDetail.getTarget();
        OnmsSnmpInterface sourceInterface = this.getByNodeIdAndIfIndex(linkDetail.getSourceIfIndex(), source, snmpmap);
        OnmsSnmpInterface targetInterface = this.getByNodeIdAndIfIndex(linkDetail.getTargetIfIndex(), target, snmpmap);
        tooltipText.append("<p>");
        tooltipText.append(linkDetail.getType());
        if (sourceInterface != null && targetInterface != null && sourceInterface.getNetMask() != null && !sourceInterface.getNetMask().isLoopbackAddress() && targetInterface.getNetMask() != null && !targetInterface.getNetMask().isLoopbackAddress()) {
            tooltipText.append(" Layer3/Layer2");
        } else {
            tooltipText.append(" Layer2");
        }
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(source.getLabel());
        if (sourceInterface != null) {
            tooltipText.append("(");
            tooltipText.append(sourceInterface.getIfName());
            tooltipText.append(")");
        }
        tooltipText.append("</p>");
        tooltipText.append("<p>");
        tooltipText.append(target.getLabel());
        if (targetInterface != null) {
            tooltipText.append("(");
            tooltipText.append(targetInterface.getIfName());
            tooltipText.append(")");
        }
        tooltipText.append("</p>");
        if (targetInterface != null) {
            if (targetInterface.getIfSpeed() != null) {
                tooltipText.append("<p>");
                tooltipText.append(EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(targetInterface.getIfSpeed()));
                tooltipText.append("</p>");
            }
        } else if (sourceInterface != null && sourceInterface.getIfSpeed() != null) {
            tooltipText.append("<p>");
            tooltipText.append(EnhancedLinkdTopologyProvider.getHumanReadableIfSpeed(sourceInterface.getIfSpeed()));
            tooltipText.append("</p>");
        }
        return tooltipText.toString();
    }

    private OnmsSnmpInterface getByNodeIdAndIfIndex(Integer ifIndex, Vertex source, Map<Integer, List<OnmsSnmpInterface>> snmpmap) {
        if (source.getId() != null && StringUtils.isNumeric((String)source.getId()) && ifIndex != null && snmpmap.containsKey(Integer.parseInt(source.getId()))) {
            for (OnmsSnmpInterface snmpiface : snmpmap.get(Integer.parseInt(source.getId()))) {
                if (ifIndex.intValue() != snmpiface.getIfIndex().intValue()) continue;
                return snmpiface;
            }
        }
        return null;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public IsIsLinkDao getIsisLinkDao() {
        return this.m_isisLinkDao;
    }

    public void setIsisLinkDao(IsIsLinkDao isisLinkDao) {
        this.m_isisLinkDao = isisLinkDao;
    }

    public BridgeMacLinkDao getBridgeMacLinkDao() {
        return this.m_bridgeMacLinkDao;
    }

    public void setBridgeMacLinkDao(BridgeMacLinkDao bridgeMacLinkDao) {
        this.m_bridgeMacLinkDao = bridgeMacLinkDao;
    }

    public BridgeBridgeLinkDao getBridgeBridgeLinkDao() {
        return this.m_bridgeBridgeLinkDao;
    }

    public void setBridgeBridgeLinkDao(BridgeBridgeLinkDao bridgeBridgeLinkDao) {
        this.m_bridgeBridgeLinkDao = bridgeBridgeLinkDao;
    }

    public BridgeTopologyDao getBridgeTopologyDao() {
        return this.m_bridgeTopologyDao;
    }

    public void setBridgeTopologyDao(BridgeTopologyDao bridgeTopologyDao) {
        this.m_bridgeTopologyDao = bridgeTopologyDao;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }

    public CdpLinkDao getCdpLinkDao() {
        return this.m_cdpLinkDao;
    }

    public void setCdpLinkDao(CdpLinkDao cdpLinkDao) {
        this.m_cdpLinkDao = cdpLinkDao;
    }

    public CdpElementDao getCdpElementDao() {
        return this.m_cdpElementDao;
    }

    public void setCdpElementDao(CdpElementDao cdpElementDao) {
        this.m_cdpElementDao = cdpElementDao;
    }

    public String getSearchProviderNamespace() {
        return "nodes";
    }

    public List<SearchResult> query(SearchQuery searchQuery, GraphContainer graphContainer) {
        List<Vertex> vertices = this.getFilteredVertices();
        ArrayList searchResults = Lists.newArrayList();
        for (Vertex vertex : vertices) {
            if (!searchQuery.matches(vertex.getLabel())) continue;
            searchResults.add(new SearchResult((VertexRef)vertex));
        }
        return searchResults;
    }

    public void onFocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public void onDefocusSearchResult(SearchResult searchResult, OperationContext operationContext) {
    }

    public boolean supportsPrefix(String searchPrefix) {
        return AbstractSearchProvider.supportsPrefix((String)"nodes=", (String)searchPrefix);
    }

    public Set<VertexRef> getVertexRefsBy(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->getVertexRefsBy: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        Set vertices = ((VertexHopGraphProvider.VertexHopCriteria)criterion).getVertices();
        LOG.debug("SearchProvider->getVertexRefsBy: found '{}' vertices.", (Object)vertices.size());
        return vertices;
    }

    public void addVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->addVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        VertexHopGraphProvider.VertexHopCriteria criterion = LinkdHopCriteriaFactory.createCriteria(searchResult.getId(), searchResult.getLabel());
        container.addCriteria((Criteria)criterion);
        LOG.debug("SearchProvider->addVertexHop: adding hop criteria {}.", (Object)criterion);
        this.logCriteriaInContainer(container);
    }

    public void removeVertexHopCriteria(SearchResult searchResult, GraphContainer container) {
        LOG.debug("SearchProvider->removeVertexHopCriteria: called with search result: '{}'", (Object)searchResult);
        Criteria criterion = this.findCriterion(searchResult.getId(), container);
        if (criterion != null) {
            LOG.debug("SearchProvider->removeVertexHopCriteria: found criterion: {} for searchResult {}.", (Object)criterion, (Object)searchResult);
            container.removeCriteria(criterion);
        } else {
            LOG.debug("SearchProvider->removeVertexHopCriteria: did not find criterion for searchResult {}.", (Object)searchResult);
        }
        this.logCriteriaInContainer(container);
    }

    public void onCenterSearchResult(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onCenterSearchResult: called with search result: '{}'", (Object)searchResult);
    }

    public void onToggleCollapse(SearchResult searchResult, GraphContainer graphContainer) {
        LOG.debug("SearchProvider->onToggleCollapse: called with search result: '{}'", (Object)searchResult);
    }

    public SelectionChangedListener.Selection getSelection(List<VertexRef> selectedVertices, ContentType type) {
        return this.selectionAwareDelegate.getSelection(selectedVertices, type);
    }

    public boolean contributesTo(ContentType type) {
        return this.selectionAwareDelegate.contributesTo(type);
    }

    private Criteria findCriterion(String resultId, GraphContainer container) {
        Criteria[] criteria;
        for (Criteria criterion : criteria = container.getCriteria()) {
            String id;
            if (!(criterion instanceof LinkdHopCriteria) || !(id = ((LinkdHopCriteria)criterion).getId()).equals(resultId)) continue;
            return criterion;
        }
        return null;
    }

    private void logCriteriaInContainer(GraphContainer container) {
        Criteria[] criteria = container.getCriteria();
        LOG.debug("SearchProvider->addVertexHopCriteria: there are now {} criteria in the GraphContainer.", (Object)criteria.length);
        for (Criteria crit : criteria) {
            LOG.debug("SearchProvider->addVertexHopCriteria: criterion: '{}' is in the GraphContainer.", (Object)crit);
        }
    }

    private CdpLink reverseCdpLink(OnmsIpInterface iface, CdpElement element, CdpLink link) {
        CdpLink reverseLink = new CdpLink();
        reverseLink.setId(Integer.valueOf(-link.getId().intValue()));
        reverseLink.setNode(iface.getNode());
        reverseLink.setCdpCacheIfIndex(iface.getIfIndex());
        reverseLink.setCdpInterfaceName(link.getCdpCacheDevicePort());
        reverseLink.setCdpCacheDeviceId(element.getCdpGlobalDeviceId());
        reverseLink.setCdpCacheDevicePort(link.getCdpInterfaceName());
        return reverseLink;
    }

    private LldpLink reverseLldpLink(OnmsNode sourcenode, LldpElement element, LldpLink link) {
        LldpLink reverseLink = new LldpLink();
        reverseLink.setId(Integer.valueOf(-link.getId().intValue()));
        reverseLink.setNode(sourcenode);
        reverseLink.setLldpLocalPortNum(Integer.valueOf(0));
        reverseLink.setLldpPortId(link.getLldpRemPortId());
        reverseLink.setLldpPortIdSubType(link.getLldpRemPortIdSubType());
        reverseLink.setLldpPortDescr(link.getLldpRemPortDescr());
        if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
            try {
                reverseLink.setLldpPortIfindex(Integer.getInteger(link.getLldpRemPortId()));
            }
            catch (Exception e) {
                LOG.debug("reverseLldpLink: cannot create ifindex from  LldpRemPortId '{}'", (Object)link.getLldpRemPortId());
            }
        }
        reverseLink.setLldpRemChassisId(element.getLldpChassisId());
        reverseLink.setLldpRemChassisIdSubType(element.getLldpChassisIdSubType());
        reverseLink.setLldpRemSysname(element.getLldpSysname());
        reverseLink.setLldpRemPortId(link.getLldpPortId());
        reverseLink.setLldpRemPortIdSubType(link.getLldpPortIdSubType());
        reverseLink.setLldpRemPortDescr(link.getLldpPortDescr());
        reverseLink.setLldpLinkCreateTime(link.getLldpLinkCreateTime());
        reverseLink.setLldpLinkLastPollTime(link.getLldpLinkLastPollTime());
        return reverseLink;
    }

    public class CdpLinkDetail
    extends LinkDetail<CdpLink> {
        public CdpLinkDetail(String id, Vertex source, CdpLink sourceLink, Vertex target, CdpLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CdpLinkDetail) {
                CdpLinkDetail objDetail = (CdpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((CdpLink)this.getSourceLink()).getCdpCacheIfIndex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((CdpLink)this.getTargetLink()).getCdpCacheIfIndex();
        }

        @Override
        public String getType() {
            return "CDP";
        }
    }

    class BridgeLinkDetail
    extends LinkDetail<Integer> {
        private final String m_vertexNamespace;
        private final Integer m_sourceBridgePort;
        private final Integer m_targetBridgePort;
        private final Integer m_sourceIfIndex;
        private final Integer m_targetifIndex;

        public BridgeLinkDetail(String vertexNamespace, Vertex source, Integer sourceIfIndex, Vertex target, Integer targetIfIndex, Integer sourceBridgePort, Integer targetBridgePort, Integer sourceLink, Integer targetLink) {
            super(EdgeAlarmStatusSummary.getDefaultEdgeId((int)sourceLink, (int)targetLink), source, sourceLink, target, targetLink);
            this.m_vertexNamespace = vertexNamespace;
            this.m_sourceBridgePort = sourceBridgePort;
            this.m_targetBridgePort = targetBridgePort;
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_targetifIndex = targetIfIndex;
        }

        public BridgeLinkDetail(String id, String vertexNamespace, Vertex source, Integer sourceIfIndex, Vertex target, Integer targetIfIndex, Integer sourceBridgePort, Integer targetBridgePort, Integer sourceLink, Integer targetLink) {
            super(id, source, sourceLink, target, targetLink);
            this.m_vertexNamespace = vertexNamespace;
            this.m_sourceBridgePort = sourceBridgePort;
            this.m_targetBridgePort = targetBridgePort;
            this.m_sourceIfIndex = sourceIfIndex;
            this.m_targetifIndex = targetIfIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.getSource().getNodeID().hashCode()) + (this.getTargetLink() == null ? 0 : this.getTarget().getNodeID().hashCode());
            result = 31 * result + (this.getVertexNamespace() == null ? 0 : this.getVertexNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BridgeLinkDetail) {
                BridgeLinkDetail objDetail = (BridgeLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        public Integer getSourceBridgePort() {
            return this.m_sourceBridgePort;
        }

        public Integer getTargetBridgePort() {
            return this.m_targetBridgePort;
        }

        @Override
        public String getType() {
            return "Bridge";
        }

        public String getVertexNamespace() {
            return this.m_vertexNamespace;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfIndex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return this.m_targetifIndex;
        }
    }

    class IsIsLinkDetail
    extends LinkDetail<Integer> {
        private final int m_sourceIfindex;
        private final int m_targetIfindex;
        private final int m_sourceLinkId;
        private final int m_targetLinkId;

        public IsIsLinkDetail(String id, Vertex source, int sourceLinkId, Integer sourceIfIndex, Vertex target, int targetLinkId, Integer targetIfIndex) {
            super(id, source, null, target, null);
            this.m_sourceLinkId = sourceLinkId;
            this.m_targetLinkId = targetLinkId;
            this.m_sourceIfindex = sourceIfIndex;
            this.m_targetIfindex = targetIfIndex;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : this.m_sourceLinkId) + (this.getTargetLink() == null ? 0 : this.m_targetLinkId);
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof IsIsLinkDetail) {
                IsIsLinkDetail objDetail = (IsIsLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return this.m_sourceIfindex;
        }

        @Override
        public Integer getTargetIfIndex() {
            return this.m_targetIfindex;
        }

        @Override
        public String getType() {
            return "IsIs";
        }
    }

    class OspfLinkDetail
    extends LinkDetail<OspfLink> {
        public OspfLinkDetail(String id, Vertex source, OspfLink sourceLink, Vertex target, OspfLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((OspfLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((OspfLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof OspfLinkDetail) {
                OspfLinkDetail objDetail = (OspfLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((OspfLink)this.getSourceLink()).getOspfIfIndex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((OspfLink)this.getTargetLink()).getOspfIfIndex();
        }

        @Override
        public String getType() {
            return "OSPF";
        }
    }

    class LldpLinkDetail
    extends LinkDetail<LldpLink> {
        public LldpLinkDetail(String id, Vertex source, LldpLink sourceLink, Vertex target, LldpLink targetLink) {
            super(id, source, sourceLink, target, targetLink);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getSourceLink() == null ? 0 : ((LldpLink)this.getSourceLink()).getId().hashCode()) + (this.getTargetLink() == null ? 0 : ((LldpLink)this.getTargetLink()).getId().hashCode());
            result = 31 * result + (EnhancedLinkdTopologyProvider.this.getNamespace() == null ? 0 : EnhancedLinkdTopologyProvider.this.getNamespace().hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof LldpLinkDetail) {
                LldpLinkDetail objDetail = (LldpLinkDetail)obj;
                return this.getId().equals(objDetail.getId());
            }
            return false;
        }

        @Override
        public Integer getSourceIfIndex() {
            return ((LldpLink)this.getSourceLink()).getLldpPortIfindex();
        }

        @Override
        public Integer getTargetIfIndex() {
            return ((LldpLink)this.getTargetLink()).getLldpPortIfindex();
        }

        @Override
        public String getType() {
            return "LLDP";
        }
    }

    abstract class LinkDetail<K> {
        private final String m_id;
        private final Vertex m_source;
        private final K m_sourceLink;
        private final Vertex m_target;
        private final K m_targetLink;

        public LinkDetail(String id, Vertex source, K sourceLink, Vertex target, K targetLink) {
            this.m_id = id;
            this.m_source = source;
            this.m_sourceLink = sourceLink;
            this.m_target = target;
            this.m_targetLink = targetLink;
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract Integer getSourceIfIndex();

        public abstract Integer getTargetIfIndex();

        public abstract String getType();

        public String getId() {
            return this.m_id;
        }

        public Vertex getSource() {
            return this.m_source;
        }

        public Vertex getTarget() {
            return this.m_target;
        }

        public K getSourceLink() {
            return this.m_sourceLink;
        }

        public K getTargetLink() {
            return this.m_targetLink;
        }
    }
}

