/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm.browsers;

import com.vaadin.ui.Button;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.Table;
import org.opennms.features.topology.api.browsers.AbstractSelectionLinkGenerator;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.ToStringColumnGenerator;
import org.opennms.features.topology.plugins.topo.bsm.BusinessServiceVertex;

public class BusinessServicesSelectionLinkGenerator
extends AbstractSelectionLinkGenerator {
    private static final long serialVersionUID = 1L;
    private final String m_idPropertyName;
    private final String m_labelPropertyName;
    private final Table.ColumnGenerator m_columnGenerator;

    public BusinessServicesSelectionLinkGenerator(String idPropertyName, String labelPropertyName) {
        this.m_idPropertyName = idPropertyName;
        this.m_labelPropertyName = labelPropertyName;
        this.m_columnGenerator = new ToStringColumnGenerator();
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        final Property idProperty = source.getContainerProperty(itemId, (Object)this.m_idPropertyName);
        final Property labelProperty = source.getContainerProperty(itemId, (Object)this.m_labelPropertyName);
        Object cellValue = this.m_columnGenerator.generateCell(source, itemId, columnId);
        if (cellValue == null) {
            return null;
        }
        if (idProperty.getValue() == null) {
            return cellValue;
        }
        Button button = new Button(cellValue.toString());
        button.setStyleName("link");
        button.setDescription(((Long)idProperty.getValue()).toString());
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                Long businessServiceId = (Long)idProperty.getValue();
                String businessServiceLabel = (String)labelProperty.getValue();
                BusinessServiceVertex vertex = new BusinessServiceVertex(businessServiceId, businessServiceLabel, 0);
                BusinessServicesSelectionLinkGenerator.this.fireVertexUpdatedEvent((VertexRef)vertex);
            }
        });
        return button;
    }
}

